/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.map.impl.record.AbstractRecord;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.storage.DataRef;
import com.hazelcast.storage.Storage;

class NativeRecord
extends AbstractRecord<Data> {
    private Storage<DataRef> storage;
    private DataRef valueRef;

    NativeRecord() {
    }

    NativeRecord(Storage<DataRef> storage, Data key, Data value) {
        super(key);
        this.storage = storage;
        this.setValue(value);
    }

    @Override
    public long getCost() {
        long size = super.getCost();
        int objectReferenceInBytes = 4;
        size += 4L;
        return size += (long)(4 + (this.valueRef == null ? 0 : this.valueRef.heapCost()));
    }

    @Override
    public Data getValue() {
        if (this.valueRef != null) {
            return this.storage.get(this.key.getPartitionHash(), this.valueRef);
        }
        return null;
    }

    @Override
    public void setValue(Data value) {
        this.invalidate();
        if (value != null) {
            this.valueRef = this.storage.put(this.key.getPartitionHash(), value);
        }
    }

    @Override
    public void invalidate() {
        if (this.valueRef != null) {
            this.storage.remove(this.key.getPartitionHash(), this.valueRef);
        }
        this.valueRef = null;
    }
}

