/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStores;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.mapstore.MapStoreManager;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.StoreEvent;
import com.hazelcast.map.impl.mapstore.writebehind.StoreListener;
import com.hazelcast.map.impl.mapstore.writebehind.StoreWorker;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessors;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import com.hazelcast.util.executor.ExecutorType;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class WriteBehindManager
implements MapStoreManager {
    private static final String EXECUTOR_NAME_PREFIX = "hz:scheduled:mapstore:";
    private static final int EXECUTOR_DEFAULT_QUEUE_CAPACITY = 10000;
    private final ScheduledExecutorService scheduledExecutor;
    private WriteBehindProcessor writeBehindProcessor;
    private StoreWorker storeWorker;
    private String executorName;
    private final MapStoreContext mapStoreContext;

    public WriteBehindManager(MapStoreContext mapStoreContext) {
        this.mapStoreContext = mapStoreContext;
        this.writeBehindProcessor = this.createWriteBehindProcessor(mapStoreContext);
        this.storeWorker = new StoreWorker(mapStoreContext, this.writeBehindProcessor);
        this.executorName = EXECUTOR_NAME_PREFIX + mapStoreContext.getMapName();
        MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        this.scheduledExecutor = this.getScheduledExecutorService(mapServiceContext);
    }

    @Override
    public void start() {
        this.scheduledExecutor.scheduleAtFixedRate(this.storeWorker, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        MapServiceContext mapServiceContext = this.mapStoreContext.getMapServiceContext();
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        nodeEngine.getExecutionService().shutdownExecutor(this.executorName);
    }

    @Override
    public MapDataStore getMapDataStore(int partitionId) {
        return MapDataStores.createWriteBehindStore(this.mapStoreContext, partitionId, this.writeBehindProcessor);
    }

    private WriteBehindProcessor createWriteBehindProcessor(final MapStoreContext mapStoreContext) {
        final MapServiceContext mapServiceContext = mapStoreContext.getMapServiceContext();
        WriteBehindProcessor writeBehindProcessor = WriteBehindProcessors.createWriteBehindProcessor(mapStoreContext);
        writeBehindProcessor.addStoreListener(new StoreListener<DelayedEntry>(){

            @Override
            public void beforeStore(StoreEvent<DelayedEntry> storeEvent) {
            }

            @Override
            public void afterStore(StoreEvent<DelayedEntry> storeEvent) {
                DelayedEntry delayedEntry = storeEvent.getSource();
                Object value = delayedEntry.getValue();
                if (value != null) {
                    return;
                }
                Data key = (Data)storeEvent.getSource().getKey();
                int partitionId = delayedEntry.getPartitionId();
                PartitionContainer partitionContainer = mapServiceContext.getPartitionContainer(partitionId);
                RecordStore recordStore = partitionContainer.getExistingRecordStore(mapStoreContext.getMapName());
                if (recordStore != null) {
                    recordStore.getMapDataStore().addTransient(key, Clock.currentTimeMillis());
                }
            }
        });
        return writeBehindProcessor;
    }

    private ScheduledExecutorService getScheduledExecutorService(MapServiceContext mapServiceContext) {
        NodeEngine nodeEngine = mapServiceContext.getNodeEngine();
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(this.executorName, 1, 10000, ExecutorType.CACHED);
        return executionService.getScheduledExecutor(this.executorName);
    }
}

