/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.map.SizeEstimator;
import com.hazelcast.map.record.ObjectRecord;
import com.hazelcast.map.record.Record;

class MapSizeEstimator<T extends Record>
implements SizeEstimator<T> {
    private volatile long _size;

    MapSizeEstimator() {
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public void add(long size) {
        this._size += size;
    }

    @Override
    public void reset() {
        this._size = 0L;
    }

    @Override
    public long getCost(T record) {
        if (record == null) {
            return 0L;
        }
        if (record instanceof ObjectRecord) {
            return 0L;
        }
        long refSize = 16L;
        long valueSize = record.getCost();
        return refSize + valueSize;
    }
}

