/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.invite;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.invite.InviteCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class InviteFriendCmd
extends InviteCommand {
    private static final int TYPE_EMAIL = 17;
    private static final int TYPE_MSG = 21;
    private final String email;
    private final String message;

    protected InviteFriendCmd(SnacPacket snacPacket) {
        super(2);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        this.email = immutableTlvChain.getString(17);
        this.message = immutableTlvChain.getString(21);
    }

    public InviteFriendCmd(String string, String string2) {
        super(2);
        this.email = string;
        this.message = string2;
    }

    public final String getEmail() {
        return this.email;
    }

    public final String getMessage() {
        return this.message;
    }

    public void writeData(OutputStream outputStream) throws IOException {
        if (this.email != null) {
            Tlv.getStringInstance(17, this.email).write(outputStream);
        }
        if (this.message != null) {
            Tlv.getStringInstance(21, this.message).write(outputStream);
        }
    }

    public String toString() {
        return "InviteFriendCmd for " + this.email + ", message: " + this.message;
    }
}

