/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.sendfile;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.rvcmd.InvitationMessage;
import net.kano.joscar.rvcmd.RvConnectionInfo;
import net.kano.joscar.rvcmd.sendfile.FileSendBlock;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.tlv.TlvChain;

public class FileSendReqRvCmd
extends AbstractRequestRvCmd {
    private final InvitationMessage invMessage;
    private final RvConnectionInfo connInfo;
    private final FileSendBlock fileSendBlock;

    public FileSendReqRvCmd(RecvRvIcbm recvRvIcbm) {
        super(recvRvIcbm);
        TlvChain tlvChain = this.getRvTlvs();
        this.invMessage = InvitationMessage.readInvitationMessage(tlvChain);
        ByteBlock byteBlock = this.getServiceData();
        this.fileSendBlock = byteBlock == null ? null : FileSendBlock.readFileSendBlock(byteBlock);
        this.connInfo = RvConnectionInfo.readConnectionInfo(tlvChain);
    }

    public FileSendReqRvCmd(InvitationMessage invitationMessage, RvConnectionInfo rvConnectionInfo, FileSendBlock fileSendBlock) {
        this(1, invitationMessage, rvConnectionInfo, fileSendBlock);
    }

    public FileSendReqRvCmd(RvConnectionInfo rvConnectionInfo) {
        this(2, null, rvConnectionInfo, null);
    }

    public FileSendReqRvCmd(int n, InvitationMessage invitationMessage, RvConnectionInfo rvConnectionInfo, FileSendBlock fileSendBlock) {
        super(CapabilityBlock.BLOCK_FILE_SEND, n);
        this.connInfo = rvConnectionInfo;
        this.fileSendBlock = fileSendBlock;
        this.invMessage = invitationMessage;
    }

    public final InvitationMessage getMessage() {
        return this.invMessage;
    }

    public final RvConnectionInfo getConnInfo() {
        return this.connInfo;
    }

    public final FileSendBlock getFileSendBlock() {
        return this.fileSendBlock;
    }

    public void writeRvTlvs(OutputStream outputStream) throws IOException {
        if (this.invMessage != null) {
            this.invMessage.write(outputStream);
        }
        if (this.connInfo != null) {
            this.connInfo.write(outputStream);
        }
    }

    protected boolean hasServiceData() {
        return this.fileSendBlock != null;
    }

    protected void writeServiceData(OutputStream outputStream) throws IOException {
        if (this.fileSendBlock != null) {
            this.fileSendBlock.write(outputStream);
        }
    }

    public String toString() {
        return "FileSendReqRvCmd: reqType=" + this.getRequestType() + ", message='" + this.invMessage + "'" + ", connInfo=" + this.connInfo + ", fileSendBlock=" + this.fileSendBlock;
    }
}

