/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.memcache;

import com.hazelcast.internal.ascii.AbstractTextCommand;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.memcache.MemcacheEntry;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class GetCommand
extends AbstractTextCommand {
    final String key;
    ByteBuffer value;
    ByteBuffer lastOne;

    public GetCommand(TextCommandConstants.TextCommandType type, String key) {
        super(type);
        this.key = key;
    }

    public GetCommand(String key) {
        this(TextCommandConstants.TextCommandType.GET, key);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public boolean readFrom(ByteBuffer cb) {
        return true;
    }

    public void setValue(MemcacheEntry entry, boolean singleGet) {
        if (entry != null) {
            this.value = entry.toNewBuffer();
        }
        this.lastOne = singleGet ? ByteBuffer.wrap(TextCommandConstants.END) : null;
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        if (this.value != null) {
            IOUtil.copyToHeapBuffer(this.value, bb);
        }
        if (this.lastOne != null) {
            IOUtil.copyToHeapBuffer(this.lastOne, bb);
        }
        return !(this.value != null && this.value.hasRemaining() || this.lastOne != null && this.lastOne.hasRemaining());
    }

    @Override
    public String toString() {
        return "GetCommand{key='" + this.key + ", value=" + this.value + '\'' + "} " + super.toString();
    }
}

