/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelCloseListener;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.EventLoopGroup;
import com.hazelcast.internal.networking.spinning.SpinningChannel;
import com.hazelcast.internal.networking.spinning.SpinningChannelReader;
import com.hazelcast.internal.networking.spinning.SpinningChannelWriter;
import com.hazelcast.internal.networking.spinning.SpinningInputThread;
import com.hazelcast.internal.networking.spinning.SpinningOutputThread;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.Preconditions;
import java.io.IOException;

public class SpinningEventLoopGroup
implements EventLoopGroup {
    private final ChannelCloseListener channelCloseListener = new ChannelCloseListenerImpl();
    private final ILogger logger;
    private final LoggingService loggingService;
    private final SpinningInputThread inputThread;
    private final SpinningOutputThread outputThread;
    private final ChannelInitializer channelInitializer;
    private final ChannelErrorHandler errorHandler;
    private final MetricsRegistry metricsRegistry;
    private final ILogger readerLogger;
    private final ILogger writerLogger;

    public SpinningEventLoopGroup(LoggingService loggingService, MetricsRegistry metricsRegistry, ChannelErrorHandler errorHandler, ChannelInitializer channelInitializer, String hzName) {
        this.loggingService = loggingService;
        this.logger = loggingService.getLogger(SpinningEventLoopGroup.class);
        this.readerLogger = loggingService.getLogger(SpinningChannelReader.class);
        this.writerLogger = loggingService.getLogger(SpinningChannelReader.class);
        this.metricsRegistry = metricsRegistry;
        this.errorHandler = errorHandler;
        this.inputThread = new SpinningInputThread(hzName);
        this.outputThread = new SpinningOutputThread(hzName);
        this.channelInitializer = channelInitializer;
    }

    @Override
    public void register(Channel channel) {
        SpinningChannel spinningChannel = Preconditions.checkInstanceOf(SpinningChannel.class, channel);
        try {
            spinningChannel.socketChannel().configureBlocking(false);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
        SpinningChannelReader reader = new SpinningChannelReader(channel, this.readerLogger, this.errorHandler, this.channelInitializer);
        spinningChannel.setReader(reader);
        this.inputThread.register(reader);
        SpinningChannelWriter writer = new SpinningChannelWriter(channel, this.writerLogger, this.errorHandler, this.channelInitializer);
        spinningChannel.setWriter(writer);
        this.outputThread.register(writer);
        String metricsId = channel.getLocalSocketAddress() + "->" + channel.getRemoteSocketAddress();
        this.metricsRegistry.scanAndRegister(writer, "tcp.connection[" + metricsId + "].out");
        this.metricsRegistry.scanAndRegister(reader, "tcp.connection[" + metricsId + "].in");
        channel.addCloseListener(this.channelCloseListener);
    }

    @Override
    public void start() {
        this.logger.info("TcpIpConnectionManager configured with Spinning IO-threading model: 1 input thread and 1 output thread");
        this.inputThread.start();
        this.outputThread.start();
    }

    @Override
    public void shutdown() {
        this.inputThread.shutdown();
        this.outputThread.shutdown();
    }

    private class ChannelCloseListenerImpl
    implements ChannelCloseListener {
        private ChannelCloseListenerImpl() {
        }

        @Override
        public void onClose(Channel channel) {
            SpinningChannel spinningChannel = (SpinningChannel)channel;
            SpinningEventLoopGroup.this.metricsRegistry.deregister(spinningChannel.getReader());
            SpinningEventLoopGroup.this.metricsRegistry.deregister(spinningChannel.getWriter());
            SpinningEventLoopGroup.this.outputThread.unregister(spinningChannel.getWriter());
            SpinningEventLoopGroup.this.inputThread.unregister(spinningChannel.getReader());
        }
    }
}

