/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.BeginTxBackupOperation;
import com.hazelcast.transaction.impl.KeyAwareTransactionLog;
import com.hazelcast.transaction.impl.PurgeTxBackupOperation;
import com.hazelcast.transaction.impl.ReplicateTxOperation;
import com.hazelcast.transaction.impl.RollbackTxBackupOperation;
import com.hazelcast.transaction.impl.SerializableXID;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionLog;
import com.hazelcast.transaction.impl.TransactionManagerServiceImpl;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class TransactionImpl
implements Transaction,
TransactionSupport {
    private static final ThreadLocal<Boolean> threadFlag = new ThreadLocal();
    private final TransactionManagerServiceImpl transactionManagerService;
    private final NodeEngine nodeEngine;
    private final List<TransactionLog> txLogs = new LinkedList<TransactionLog>();
    private final Map<Object, TransactionLog> txLogMap = new HashMap<Object, TransactionLog>();
    private final String txnId;
    private final long threadId = Thread.currentThread().getId();
    private final long timeoutMillis;
    private final int durability;
    private final TransactionOptions.TransactionType transactionType;
    private final String txOwnerUuid;
    private final boolean checkThreadAccess;
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime = 0L;
    private Address[] backupAddresses;
    private SerializableXID xid = null;

    public TransactionImpl(TransactionManagerServiceImpl transactionManagerService, NodeEngine nodeEngine, TransactionOptions options, String txOwnerUuid) {
        this.transactionManagerService = transactionManagerService;
        this.nodeEngine = nodeEngine;
        this.txnId = UUID.randomUUID().toString();
        this.timeoutMillis = options.getTimeoutMillis();
        this.durability = options.getDurability();
        this.transactionType = options.getTransactionType();
        this.txOwnerUuid = txOwnerUuid == null ? nodeEngine.getLocalMember().getUuid() : txOwnerUuid;
        this.checkThreadAccess = txOwnerUuid != null;
    }

    TransactionImpl(TransactionManagerServiceImpl transactionManagerService, NodeEngine nodeEngine, String txnId, List<TransactionLog> txLogs, long timeoutMillis, long startTime, String txOwnerUuid) {
        this.transactionManagerService = transactionManagerService;
        this.nodeEngine = nodeEngine;
        this.txnId = txnId;
        this.timeoutMillis = timeoutMillis;
        this.startTime = startTime;
        this.durability = 0;
        this.transactionType = TransactionOptions.TransactionType.TWO_PHASE;
        this.txLogs.addAll(txLogs);
        this.state = Transaction.State.PREPARED;
        this.txOwnerUuid = txOwnerUuid;
        this.checkThreadAccess = false;
    }

    public void setXid(SerializableXID xid) {
        this.xid = xid;
    }

    public SerializableXID getXid() {
        return this.xid;
    }

    @Override
    public String getTxnId() {
        return this.txnId;
    }

    public TransactionOptions.TransactionType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public void addTransactionLog(TransactionLog transactionLog) {
        KeyAwareTransactionLog keyAwareTransactionLog;
        TransactionLog removed;
        if (this.state != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
        this.checkThread();
        if (transactionLog instanceof KeyAwareTransactionLog && (removed = this.txLogMap.remove((keyAwareTransactionLog = (KeyAwareTransactionLog)transactionLog).getKey())) != null) {
            this.txLogs.remove(removed);
        }
        this.txLogs.add(transactionLog);
        if (transactionLog instanceof KeyAwareTransactionLog) {
            keyAwareTransactionLog = (KeyAwareTransactionLog)transactionLog;
            this.txLogMap.put(keyAwareTransactionLog.getKey(), keyAwareTransactionLog);
        }
    }

    @Override
    public TransactionLog getTransactionLog(Object key) {
        return this.txLogMap.get(key);
    }

    public List<TransactionLog> getTxLogs() {
        return this.txLogs;
    }

    @Override
    public void removeTransactionLog(Object key) {
        TransactionLog removed = this.txLogMap.remove(key);
        if (removed != null) {
            this.txLogs.remove(removed);
        }
    }

    private void checkThread() {
        if (!this.checkThreadAccess && this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Transaction cannot span multiple threads!");
        }
    }

    @Override
    public void begin() throws IllegalStateException {
        if (this.state == Transaction.State.ACTIVE) {
            throw new IllegalStateException("Transaction is already active");
        }
        this.checkThread();
        if (threadFlag.get() != null) {
            throw new IllegalStateException("Nested transactions are not allowed!");
        }
        this.setThreadFlag(Boolean.TRUE);
        this.startTime = Clock.currentTimeMillis();
        this.backupAddresses = this.transactionManagerService.pickBackupAddresses(this.durability);
        if (this.durability > 0 && this.backupAddresses != null && this.transactionType == TransactionOptions.TransactionType.TWO_PHASE) {
            OperationService operationService = this.nodeEngine.getOperationService();
            ArrayList<Future> futures = new ArrayList<Future>(this.backupAddresses.length);
            for (Address backupAddress : this.backupAddresses) {
                if (this.nodeEngine.getClusterService().getMember(backupAddress) == null) continue;
                Invocation inv = operationService.createInvocationBuilder("hz:core:txManagerService", (Operation)new BeginTxBackupOperation(this.txOwnerUuid, this.txnId, this.xid), backupAddress).build();
                futures.add(inv.invoke());
            }
            for (Future future : futures) {
                try {
                    future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
                }
                catch (MemberLeftException e) {
                    this.nodeEngine.getLogger(Transaction.class).warning("Member left while replicating tx begin: " + e);
                }
                catch (Throwable e) {
                    if (e instanceof ExecutionException) {
                        Throwable throwable = e = e.getCause() != null ? e.getCause() : e;
                    }
                    if (e instanceof TargetNotMemberException) {
                        this.nodeEngine.getLogger(Transaction.class).warning("Member left while replicating tx begin: " + e);
                        continue;
                    }
                    throw ExceptionUtil.rethrow(e);
                }
            }
        }
        this.state = Transaction.State.ACTIVE;
    }

    private void setThreadFlag(Boolean flag) {
        if (!this.checkThreadAccess) {
            threadFlag.set(flag);
        }
    }

    @Override
    public void prepare() throws TransactionException {
        if (this.state != Transaction.State.ACTIVE) {
            throw new TransactionNotActiveException("Transaction is not active");
        }
        this.checkThread();
        this.checkTimeout();
        try {
            ArrayList<Future> futures = new ArrayList<Future>(this.txLogs.size());
            this.state = Transaction.State.PREPARING;
            for (TransactionLog txLog : this.txLogs) {
                futures.add(txLog.prepare(this.nodeEngine));
            }
            for (Future future : futures) {
                future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
            }
            futures.clear();
            this.state = Transaction.State.PREPARED;
            if (this.durability > 0) {
                OperationService operationService = this.nodeEngine.getOperationService();
                for (Address backupAddress : this.backupAddresses) {
                    if (this.nodeEngine.getClusterService().getMember(backupAddress) == null) continue;
                    Invocation inv = operationService.createInvocationBuilder("hz:core:txManagerService", (Operation)new ReplicateTxOperation(this.txLogs, this.txOwnerUuid, this.txnId, this.timeoutMillis, this.startTime), backupAddress).build();
                    futures.add(inv.invoke());
                }
                for (Future future : futures) {
                    future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
                }
                futures.clear();
            }
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e, TransactionException.class);
        }
    }

    @Override
    public void commit() throws TransactionException, IllegalStateException {
        if (this.transactionType.equals((Object)TransactionOptions.TransactionType.TWO_PHASE) && this.state != Transaction.State.PREPARED) {
            throw new IllegalStateException("Transaction is not prepared");
        }
        if (this.transactionType.equals((Object)TransactionOptions.TransactionType.LOCAL) && this.state != Transaction.State.ACTIVE) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.checkThread();
        this.checkTimeout();
        try {
            ArrayList<Future> futures = new ArrayList<Future>(this.txLogs.size());
            this.state = Transaction.State.COMMITTING;
            for (TransactionLog txLog : this.txLogs) {
                futures.add(txLog.commit(this.nodeEngine));
            }
            for (Future future : futures) {
                try {
                    future.get(5L, TimeUnit.MINUTES);
                }
                catch (Throwable e) {
                    this.nodeEngine.getLogger(this.getClass()).warning("Error during commit!", e);
                }
            }
            this.state = Transaction.State.COMMITTED;
            this.purgeTxBackups();
        }
        catch (Throwable e) {
            this.state = Transaction.State.COMMIT_FAILED;
            throw ExceptionUtil.rethrow(e, TransactionException.class);
        }
        finally {
            this.setThreadFlag(null);
        }
    }

    private void checkTimeout() throws TransactionException {
        if (this.startTime + this.timeoutMillis < Clock.currentTimeMillis()) {
            throw new TransactionException("Transaction is timed-out!");
        }
    }

    @Override
    public void rollback() throws IllegalStateException {
        if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
            throw new IllegalStateException("Transaction is not active");
        }
        this.checkThread();
        this.state = Transaction.State.ROLLING_BACK;
        try {
            ArrayList<Future> futures = new ArrayList<Future>(this.txLogs.size());
            OperationService operationService = this.nodeEngine.getOperationService();
            if (this.durability > 0 && this.transactionType.equals((Object)TransactionOptions.TransactionType.TWO_PHASE)) {
                for (Address backupAddress : this.backupAddresses) {
                    if (this.nodeEngine.getClusterService().getMember(backupAddress) == null) continue;
                    Invocation inv = operationService.createInvocationBuilder("hz:core:txManagerService", (Operation)new RollbackTxBackupOperation(this.txnId), backupAddress).build();
                    futures.add(inv.invoke());
                }
                for (Future future : futures) {
                    try {
                        future.get(this.timeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (Throwable e) {
                        this.nodeEngine.getLogger(this.getClass()).warning("Error during tx rollback backup!", e);
                    }
                }
                futures.clear();
            }
            ListIterator<TransactionLog> iter = this.txLogs.listIterator(this.txLogs.size());
            while (iter.hasPrevious()) {
                TransactionLog txLog = iter.previous();
                futures.add(txLog.rollback(this.nodeEngine));
            }
            for (Future future : futures) {
                try {
                    future.get(5L, TimeUnit.MINUTES);
                }
                catch (Throwable e) {
                    this.nodeEngine.getLogger(this.getClass()).warning("Error during rollback!", e);
                }
            }
            this.purgeTxBackups();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.state = Transaction.State.ROLLED_BACK;
            this.setThreadFlag(null);
        }
    }

    private void purgeTxBackups() {
        if (this.durability > 0 && this.transactionType.equals((Object)TransactionOptions.TransactionType.TWO_PHASE)) {
            OperationService operationService = this.nodeEngine.getOperationService();
            for (Address backupAddress : this.backupAddresses) {
                if (this.nodeEngine.getClusterService().getMember(backupAddress) == null) continue;
                try {
                    Invocation inv = operationService.createInvocationBuilder("hz:core:txManagerService", (Operation)new PurgeTxBackupOperation(this.txnId), backupAddress).build();
                    inv.invoke();
                }
                catch (Throwable e) {
                    this.nodeEngine.getLogger(this.getClass()).warning("Error during purging backups!", e);
                }
            }
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getOwnerUuid() {
        return this.txOwnerUuid;
    }

    @Override
    public Transaction.State getState() {
        return this.state;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Transaction");
        sb.append("{txnId='").append(this.txnId).append('\'');
        sb.append(", state=").append((Object)this.state);
        sb.append(", txType=").append((Object)this.transactionType);
        sb.append(", timeoutMillis=").append(this.timeoutMillis);
        sb.append('}');
        return sb.toString();
    }
}

