/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.util.ThreadUtil;
import java.io.IOException;

public abstract class TransactionRequest
extends CallableClientRequest
implements Portable {
    int clientThreadId = -1;

    protected TransactionRequest() {
    }

    protected TransactionRequest(int clientThreadId) {
        this.clientThreadId = clientThreadId;
    }

    protected abstract Object innerCall() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object call() throws Exception {
        ThreadUtil.setThreadId(this.clientThreadId);
        try {
            Object object = this.innerCall();
            return object;
        }
        finally {
            ThreadUtil.removeThreadId();
        }
    }

    public abstract void write(PortableWriter var1) throws IOException;

    public abstract void read(PortableReader var1) throws IOException;

    @Override
    public final void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("cti", this.clientThreadId);
        this.write(writer);
    }

    @Override
    public final void readPortable(PortableReader reader) throws IOException {
        this.clientThreadId = reader.readInt("cti");
        this.read(reader);
    }
}

