/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageStack;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;

public abstract class MessageProcessor
implements Runnable {
    protected ListeningPointImpl listeningPoint;
    protected int transactionCount;

    public abstract String getTransport();

    public abstract int getPort();

    public abstract SIPMessageStack getSIPStack();

    public abstract MessageChannel createMessageChannel(HostPort var1) throws IOException;

    public abstract MessageChannel createMessageChannel(InetAddress var1, int var2) throws IOException;

    public abstract Thread getThread();

    public abstract void start() throws IOException;

    public abstract void stop();

    public abstract int getDefaultTargetPort();

    public abstract boolean isSecure();

    public abstract int getMaximumMessageSize();

    public abstract boolean inUse();

    public Via getViaHeader() {
        try {
            Via via = new Via();
            Host host = new Host();
            host.setHostname(this.getSIPStack().getHostAddress());
            via.setHost(host);
            via.setPort(this.getPort());
            via.setTransport(this.getTransport());
            return via;
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public abstract void run();

    public ListeningPointImpl getListeningPoint() {
        return this.listeningPoint;
    }

    public void setListeningPoint(ListeningPointImpl lp) {
        this.listeningPoint = lp;
    }
}

