/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.logging;

import com.voxeo.logging.LoggingContext;
import com.voxeo.utils.Objects;
import java.util.concurrent.Executor;

public class LoggingContextExecutor
implements Executor {
    private Executor delegate;

    public LoggingContextExecutor(Executor executor) {
        this.delegate = executor;
    }

    public void execute(final Runnable runnable) {
        LoggingContext loggingContext = LoggingContext.get();
        final String accountID = loggingContext.getAccountID();
        final String command = loggingContext.getCommand();
        final String sessionGUID = loggingContext.getSessionGUID();
        final String sessionNumber = loggingContext.getSessionNumber();
        this.delegate.execute(new Runnable(){

            public void run() {
                LoggingContext innerContext = LoggingContext.get();
                innerContext.setAccountID(Objects.isNull(accountID, ""));
                innerContext.setCommand(Objects.isNull(command, ""));
                innerContext.setSessionGUID(Objects.isNull(sessionGUID, ""));
                innerContext.setSessionNumber(Objects.isNull(sessionNumber, ""));
                runnable.run();
            }
        });
    }
}

