/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MultivaluedMap;
import jersey.repackaged.com.google.common.base.Function;
import jersey.repackaged.com.google.common.util.concurrent.SettableFuture;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientAsyncExecutorLiteral;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.ClientFilteringStages;
import org.glassfish.jersey.client.ClientLifecycleListener;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.RequestProcessingInitializationStage;
import org.glassfish.jersey.client.ResponseCallback;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.client.spi.AsyncConnectorCallback;
import org.glassfish.jersey.client.spi.Connector;
import org.glassfish.jersey.internal.Version;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.MessageBodyWorkers;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.Stage;
import org.glassfish.jersey.process.internal.Stages;

class ClientRuntime
implements JerseyClient.ShutdownHook {
    private static final Logger LOG = Logger.getLogger(ClientRuntime.class.getName());
    private final Stage<ClientRequest> requestProcessingRoot;
    private final Stage<ClientResponse> responseProcessingRoot;
    private final Connector connector;
    private final ClientConfig config;
    private final RequestScope requestScope;
    private final LazyValue<ExecutorService> asyncRequestExecutor;
    private final ServiceLocator locator;
    private final Iterable<ClientLifecycleListener> lifecycleListeners;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public ClientRuntime(ClientConfig config, Connector connector, final ServiceLocator locator) {
        Stage.Builder requestingChainBuilder = Stages.chain((Function)((Function)locator.createAndInitialize(RequestProcessingInitializationStage.class)));
        ChainableStage<ClientRequest> requestFilteringStage = ClientFilteringStages.createRequestFilteringStage(locator);
        this.requestProcessingRoot = requestFilteringStage != null ? requestingChainBuilder.build(requestFilteringStage) : requestingChainBuilder.build();
        ChainableStage responseFilteringStage = ClientFilteringStages.createResponseFilteringStage(locator);
        this.responseProcessingRoot = responseFilteringStage != null ? responseFilteringStage : Stages.identity();
        this.config = config;
        this.connector = connector;
        this.requestScope = (RequestScope)locator.getService(RequestScope.class, new Annotation[0]);
        this.asyncRequestExecutor = Values.lazy((Value)new Value<ExecutorService>(){

            public ExecutorService get() {
                return (ExecutorService)locator.getService(ExecutorService.class, new Annotation[]{ClientAsyncExecutorLiteral.INSTANCE});
            }
        });
        this.locator = locator;
        this.lifecycleListeners = Providers.getAllProviders((ServiceLocator)locator, ClientLifecycleListener.class);
        for (ClientLifecycleListener listener : this.lifecycleListeners) {
            try {
                listener.onInit();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, LocalizationMessages.ERROR_LISTENER_INIT(listener.getClass().getName()), t);
            }
        }
    }

    public void submit(final ClientRequest request, final ResponseCallback callback) {
        this.submit((ExecutorService)this.asyncRequestExecutor.get(), new Runnable(){

            @Override
            public void run() {
                try {
                    ClientRequest processedRequest;
                    try {
                        processedRequest = (ClientRequest)((Object)Stages.process((Object)((Object)request), (Stage)ClientRuntime.this.requestProcessingRoot));
                        processedRequest = ClientRuntime.this.addUserAgent(processedRequest, ClientRuntime.this.connector.getName());
                    }
                    catch (AbortException aborted) {
                        ClientRuntime.this.processResponse(aborted.getAbortResponse(), callback);
                        return;
                    }
                    final SettableFuture responseFuture = SettableFuture.create();
                    AsyncConnectorCallback connectorCallback = new AsyncConnectorCallback(){

                        @Override
                        public void response(ClientResponse response) {
                            responseFuture.set((Object)response);
                        }

                        @Override
                        public void failure(Throwable failure) {
                            responseFuture.setException(failure);
                        }
                    };
                    ClientRuntime.this.connector.apply(processedRequest, connectorCallback);
                    ClientRuntime.this.processResponse((ClientResponse)((Object)responseFuture.get()), callback);
                }
                catch (ExecutionException e) {
                    ClientRuntime.this.processFailure(e.getCause(), callback);
                }
                catch (Throwable throwable) {
                    ClientRuntime.this.processFailure(throwable, callback);
                }
            }
        });
    }

    private void processResponse(ClientResponse response, ResponseCallback callback) {
        ClientResponse processedResponse;
        try {
            processedResponse = (ClientResponse)((Object)Stages.process((Object)((Object)response), this.responseProcessingRoot));
        }
        catch (Throwable throwable) {
            this.processFailure(throwable, callback);
            return;
        }
        callback.completed(processedResponse, this.requestScope);
    }

    private void processFailure(Throwable failure, ResponseCallback callback) {
        callback.failed(failure instanceof ProcessingException ? (ProcessingException)failure : new ProcessingException(failure));
    }

    private Future<?> submit(ExecutorService executor, final Runnable task) {
        return executor.submit(new Runnable(){

            @Override
            public void run() {
                ClientRuntime.this.requestScope.runInScope(task);
            }
        });
    }

    private ClientRequest addUserAgent(ClientRequest clientRequest, String connectorName) {
        MultivaluedMap headers = clientRequest.getHeaders();
        if (headers.containsKey((Object)"User-Agent")) {
            if (clientRequest.getHeaderString("User-Agent") == null) {
                headers.remove((Object)"User-Agent");
            }
        } else if (!clientRequest.ignoreUserAgent()) {
            if (connectorName != null && !connectorName.isEmpty()) {
                headers.put((Object)"User-Agent", Arrays.asList(String.format("Jersey/%s (%s)", Version.getVersion(), connectorName)));
            } else {
                headers.put((Object)"User-Agent", Arrays.asList(String.format("Jersey/%s", Version.getVersion())));
            }
        }
        return clientRequest;
    }

    public ClientResponse invoke(ClientRequest request) {
        try {
            ClientResponse response;
            try {
                response = this.connector.apply(this.addUserAgent((ClientRequest)((Object)Stages.process((Object)((Object)request), this.requestProcessingRoot)), this.connector.getName()));
            }
            catch (AbortException aborted) {
                response = aborted.getAbortResponse();
            }
            return (ClientResponse)((Object)Stages.process((Object)((Object)response), this.responseProcessingRoot));
        }
        catch (ProcessingException pe) {
            throw pe;
        }
        catch (Throwable t) {
            throw new ProcessingException(t.getMessage(), t);
        }
    }

    public RequestScope getRequestScope() {
        return this.requestScope;
    }

    public ClientConfig getConfig() {
        return this.config;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                for (ClientLifecycleListener listener : this.lifecycleListeners) {
                    try {
                        listener.onClose();
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, LocalizationMessages.ERROR_LISTENER_CLOSE(listener.getClass().getName()), t);
                    }
                }
            }
            finally {
                try {
                    this.connector.close();
                }
                finally {
                    Injections.shutdownLocator((ServiceLocator)this.locator);
                }
            }
        }
    }

    public void preInitialize() {
        this.locator.getService(MessageBodyWorkers.class, new Annotation[0]);
    }

    public Connector getConnector() {
        return this.connector;
    }

    ServiceLocator getServiceLocator() {
        return this.locator;
    }
}

