/*
 * Decompiled with CFR 0.152.
 */
package pl.mn.communicator.packet.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import pl.mn.communicator.GGToken;
import pl.mn.communicator.IGGConfiguration;
import pl.mn.communicator.packet.http.HttpRequest;
import pl.mn.communicator.packet.http.HttpResponse;

public class GGTokenRequest
extends HttpRequest {
    public GGTokenRequest(IGGConfiguration configuration) throws IOException {
        super(configuration);
        this.m_huc.setRequestProperty("Accept", "image/gif, image/jpeg, */*");
        this.m_huc.setRequestProperty("Accept-Language", "pl");
    }

    public HttpResponse getResponse() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.m_huc.getInputStream(), "windows-1250"));
        String line1 = reader.readLine();
        String line2 = reader.readLine();
        String line3 = reader.readLine();
        return new GGTokenResponse(line1, line2, line3);
    }

    protected String getURL() {
        return this.m_ggconfiguration.getTokenRequestURL();
    }

    protected String getRequestBody() throws UnsupportedEncodingException {
        return "";
    }

    protected boolean wannaWrite() {
        return false;
    }

    public static class GGTokenResponse
    extends HttpResponse {
        private String m_responseLine1 = null;
        private String m_responseLine2 = null;
        private String m_responseLine3 = null;

        private GGTokenResponse(String responseLine1, String responseLine2, String responseLine3) {
            this.m_responseLine1 = responseLine1;
            this.m_responseLine2 = responseLine2;
            this.m_responseLine3 = responseLine3;
        }

        public boolean isOKResponse() {
            return this.m_responseLine1 != null && this.m_responseLine2 != null && this.m_responseLine3 != null;
        }

        public GGToken getGGToken() {
            GGToken token = new GGToken();
            StringTokenizer tokenizer = new StringTokenizer(this.m_responseLine1, " ");
            String widthString = tokenizer.nextToken();
            String heightString = tokenizer.nextToken();
            String lengthString = tokenizer.nextToken();
            token.setImageWidth(Integer.parseInt(widthString));
            token.setImageHeight(Integer.parseInt(heightString));
            token.setTokenLength(Integer.parseInt(lengthString));
            token.setTokenID(this.m_responseLine2.trim());
            token.setTokenURL(this.m_responseLine3.trim());
            return token;
        }

        public String getResponseMessage() {
            return this.m_responseLine1 + "\n" + this.m_responseLine2 + "\n" + this.m_responseLine3;
        }
    }
}

