/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bytestreams.BytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Close;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Data;
import org.jivesoftware.smackx.bytestreams.ibb.packet.DataPacketExtension;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.packet.SyncPacketSend;

public class InBandBytestreamSession
implements BytestreamSession {
    private final Connection connection;
    private final Open byteStreamRequest;
    private IBBInputStream inputStream;
    private IBBOutputStream outputStream;
    private String remoteJID;
    private boolean closeBothStreamsEnabled = false;
    private boolean isClosed = false;

    protected InBandBytestreamSession(Connection connection, Open byteStreamRequest, String remoteJID) {
        this.connection = connection;
        this.byteStreamRequest = byteStreamRequest;
        this.remoteJID = remoteJID;
        switch (byteStreamRequest.getStanza()) {
            case IQ: {
                this.inputStream = new IQIBBInputStream();
                this.outputStream = new IQIBBOutputStream();
                break;
            }
            case MESSAGE: {
                this.inputStream = new MessageIBBInputStream();
                this.outputStream = new MessageIBBOutputStream();
            }
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public int getReadTimeout() {
        return this.inputStream.readTimeout;
    }

    public void setReadTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout must be >= 0");
        }
        this.inputStream.readTimeout = timeout;
    }

    public boolean isCloseBothStreamsEnabled() {
        return this.closeBothStreamsEnabled;
    }

    public void setCloseBothStreamsEnabled(boolean closeBothStreamsEnabled) {
        this.closeBothStreamsEnabled = closeBothStreamsEnabled;
    }

    public void close() throws IOException {
        this.closeByLocal(true);
        this.closeByLocal(false);
    }

    protected void closeByPeer(Close closeRequest) {
        this.inputStream.closeInternal();
        this.inputStream.cleanup();
        this.outputStream.closeInternal(false);
        IQ confirmClose = IQ.createResultIQ(closeRequest);
        this.connection.sendPacket(confirmClose);
    }

    protected synchronized void closeByLocal(boolean in) throws IOException {
        if (this.isClosed) {
            return;
        }
        if (this.closeBothStreamsEnabled) {
            this.inputStream.closeInternal();
            this.outputStream.closeInternal(true);
        } else if (in) {
            this.inputStream.closeInternal();
        } else {
            this.outputStream.closeInternal(true);
        }
        if (this.inputStream.isClosed && this.outputStream.isClosed) {
            this.isClosed = true;
            Close close = new Close(this.byteStreamRequest.getSessionID());
            close.setTo(this.remoteJID);
            try {
                SyncPacketSend.getReply(this.connection, close);
            }
            catch (XMPPException e) {
                throw new IOException("Error while closing stream: " + e.getMessage());
            }
            this.inputStream.cleanup();
            InBandBytestreamManager.getByteStreamManager(this.connection).getSessions().remove(this);
        }
    }

    private class MessageIBBOutputStream
    extends IBBOutputStream {
        private MessageIBBOutputStream() {
        }

        protected synchronized void writeToXML(DataPacketExtension data) {
            Message message = new Message(InBandBytestreamSession.this.remoteJID);
            message.addExtension(data);
            InBandBytestreamSession.this.connection.sendPacket(message);
        }
    }

    private class IQIBBOutputStream
    extends IBBOutputStream {
        private IQIBBOutputStream() {
        }

        protected synchronized void writeToXML(DataPacketExtension data) throws IOException {
            block2: {
                Data iq = new Data(data);
                iq.setTo(InBandBytestreamSession.this.remoteJID);
                try {
                    SyncPacketSend.getReply(InBandBytestreamSession.this.connection, iq);
                }
                catch (XMPPException e) {
                    if (this.isClosed) break block2;
                    InBandBytestreamSession.this.close();
                    throw new IOException("Error while sending Data: " + e.getMessage());
                }
            }
        }
    }

    private abstract class IBBOutputStream
    extends OutputStream {
        protected final byte[] buffer;
        protected int bufferPointer = 0;
        protected long seq = 0L;
        protected boolean isClosed = false;

        public IBBOutputStream() {
            this.buffer = new byte[InBandBytestreamSession.this.byteStreamRequest.getBlockSize()];
        }

        protected abstract void writeToXML(DataPacketExtension var1) throws IOException;

        public synchronized void write(int b) throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (this.bufferPointer >= this.buffer.length) {
                this.flushBuffer();
            }
            this.buffer[this.bufferPointer++] = (byte)b;
        }

        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            if (len >= this.buffer.length) {
                this.writeOut(b, off, this.buffer.length);
                this.write(b, off + this.buffer.length, len - this.buffer.length);
            } else {
                this.writeOut(b, off, len);
            }
        }

        public synchronized void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        private synchronized void writeOut(byte[] b, int off, int len) throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            int available = 0;
            if (len > this.buffer.length - this.bufferPointer) {
                available = this.buffer.length - this.bufferPointer;
                System.arraycopy(b, off, this.buffer, this.bufferPointer, available);
                this.bufferPointer += available;
                this.flushBuffer();
            }
            System.arraycopy(b, off + available, this.buffer, this.bufferPointer, len - available);
            this.bufferPointer += len - available;
        }

        public synchronized void flush() throws IOException {
            if (this.isClosed) {
                throw new IOException("Stream is closed");
            }
            this.flushBuffer();
        }

        private synchronized void flushBuffer() throws IOException {
            if (this.bufferPointer == 0) {
                return;
            }
            String enc = StringUtils.encodeBase64(this.buffer, 0, this.bufferPointer, false);
            DataPacketExtension data = new DataPacketExtension(InBandBytestreamSession.this.byteStreamRequest.getSessionID(), this.seq, enc);
            this.writeToXML(data);
            this.bufferPointer = 0;
            this.seq = this.seq + 1L == 65535L ? 0L : this.seq + 1L;
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            InBandBytestreamSession.this.closeByLocal(false);
        }

        protected void closeInternal(boolean flush) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            try {
                if (flush) {
                    this.flushBuffer();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class IBBDataPacketFilter
    implements PacketFilter {
        private IBBDataPacketFilter() {
        }

        public boolean accept(Packet packet) {
            if (!packet.getFrom().equalsIgnoreCase(InBandBytestreamSession.this.remoteJID)) {
                return false;
            }
            PacketExtension packetExtension = packet.getExtension("data", "http://jabber.org/protocol/ibb");
            if (packetExtension == null || !(packetExtension instanceof DataPacketExtension)) {
                return false;
            }
            DataPacketExtension data = (DataPacketExtension)packetExtension;
            return data.getSessionID().equals(InBandBytestreamSession.this.byteStreamRequest.getSessionID());
        }
    }

    private class MessageIBBInputStream
    extends IBBInputStream {
        private MessageIBBInputStream() {
        }

        protected PacketListener getDataPacketListener() {
            return new PacketListener(){

                public void processPacket(Packet packet) {
                    DataPacketExtension data = (DataPacketExtension)packet.getExtension("data", "http://jabber.org/protocol/ibb");
                    if (data.getDecodedData() == null) {
                        return;
                    }
                    MessageIBBInputStream.this.dataQueue.offer(data);
                }
            };
        }

        protected PacketFilter getDataPacketFilter() {
            return new AndFilter(new PacketTypeFilter(Message.class), new IBBDataPacketFilter());
        }
    }

    private class IQIBBInputStream
    extends IBBInputStream {
        private IQIBBInputStream() {
        }

        protected PacketListener getDataPacketListener() {
            return new PacketListener(){
                private long lastSequence = -1L;

                public void processPacket(Packet packet) {
                    DataPacketExtension data = (DataPacketExtension)packet.getExtension("data", "http://jabber.org/protocol/ibb");
                    if (data.getSeq() <= this.lastSequence) {
                        IQ unexpectedRequest = IQ.createErrorResponse((IQ)packet, new XMPPError(XMPPError.Condition.unexpected_request));
                        InBandBytestreamSession.this.connection.sendPacket(unexpectedRequest);
                        return;
                    }
                    if (data.getDecodedData() == null) {
                        IQ badRequest = IQ.createErrorResponse((IQ)packet, new XMPPError(XMPPError.Condition.bad_request));
                        InBandBytestreamSession.this.connection.sendPacket(badRequest);
                        return;
                    }
                    IQIBBInputStream.this.dataQueue.offer(data);
                    IQ confirmData = IQ.createResultIQ((IQ)packet);
                    InBandBytestreamSession.this.connection.sendPacket(confirmData);
                    this.lastSequence = data.getSeq();
                    if (this.lastSequence == 65535L) {
                        this.lastSequence = -1L;
                    }
                }
            };
        }

        protected PacketFilter getDataPacketFilter() {
            return new AndFilter(new PacketTypeFilter(Data.class), new IBBDataPacketFilter());
        }
    }

    private abstract class IBBInputStream
    extends InputStream {
        private final PacketListener dataPacketListener;
        protected final BlockingQueue<DataPacketExtension> dataQueue = new LinkedBlockingQueue<DataPacketExtension>();
        private byte[] buffer;
        private int bufferPointer = -1;
        private long seq = -1L;
        private boolean isClosed = false;
        private boolean closeInvoked = false;
        private int readTimeout = 0;

        public IBBInputStream() {
            this.dataPacketListener = this.getDataPacketListener();
            InBandBytestreamSession.this.connection.addPacketListener(this.dataPacketListener, this.getDataPacketFilter());
        }

        protected abstract PacketListener getDataPacketListener();

        protected abstract PacketFilter getDataPacketFilter();

        public synchronized int read() throws IOException {
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            return this.buffer[this.bufferPointer++];
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            this.checkClosed();
            if (!(this.bufferPointer != -1 && this.bufferPointer < this.buffer.length || this.loadBuffer())) {
                return -1;
            }
            int bytesAvailable = this.buffer.length - this.bufferPointer;
            if (len > bytesAvailable) {
                len = bytesAvailable;
            }
            System.arraycopy(this.buffer, this.bufferPointer, b, off, len);
            this.bufferPointer += len;
            return len;
        }

        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        private synchronized boolean loadBuffer() throws IOException {
            long seq;
            DataPacketExtension data = null;
            try {
                if (this.readTimeout == 0) {
                    while (data == null) {
                        if (this.isClosed && this.dataQueue.isEmpty()) {
                            return false;
                        }
                        data = this.dataQueue.poll(1000L, TimeUnit.MILLISECONDS);
                    }
                } else {
                    data = this.dataQueue.poll(this.readTimeout, TimeUnit.MILLISECONDS);
                    if (data == null) {
                        throw new SocketTimeoutException();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            if (this.seq == 65535L) {
                this.seq = -1L;
            }
            if ((seq = data.getSeq()) - 1L != this.seq) {
                InBandBytestreamSession.this.close();
                throw new IOException("Packets out of sequence");
            }
            this.seq = seq;
            this.buffer = data.getDecodedData();
            this.bufferPointer = 0;
            return true;
        }

        private void checkClosed() throws IOException {
            if (this.isClosed && this.dataQueue.isEmpty() || this.closeInvoked) {
                this.dataQueue.clear();
                throw new IOException("Stream is closed");
            }
        }

        public boolean markSupported() {
            return false;
        }

        public void close() throws IOException {
            if (this.isClosed) {
                return;
            }
            this.closeInvoked = true;
            InBandBytestreamSession.this.closeByLocal(true);
        }

        private void closeInternal() {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }

        private void cleanup() {
            InBandBytestreamSession.this.connection.removePacketListener(this.dataPacketListener);
        }
    }
}

