/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;

class IOHandler {
    private SipStackImpl sipStack;
    private static String TCP = "tcp";
    private static String TLS = "tls";
    private Hashtable socketTable;

    protected static String makeKey(InetAddress inetAddress, int n) {
        return inetAddress.getHostAddress() + ":" + n;
    }

    protected IOHandler(SIPTransactionStack sIPTransactionStack) {
        this.sipStack = (SipStackImpl)sIPTransactionStack;
        this.socketTable = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putSocket(String string, Socket socket) {
        Hashtable hashtable = this.socketTable;
        synchronized (hashtable) {
            this.socketTable.put(string, socket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket getSocket(String string) {
        Hashtable hashtable = this.socketTable;
        synchronized (hashtable) {
            return (Socket)this.socketTable.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSocket(String string) {
        Hashtable hashtable = this.socketTable;
        synchronized (hashtable) {
            this.socketTable.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeChunks(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        OutputStream outputStream2 = outputStream;
        synchronized (outputStream2) {
            int n2 = 8192;
            for (int i = 0; i < n; i += n2) {
                int n3 = i + n2 < n ? n2 : n - i;
                outputStream.write(byArray, i, n3);
            }
        }
        outputStream.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket sendBytes(InetAddress inetAddress, InetAddress inetAddress2, int n, String string, byte[] byArray, boolean bl) throws IOException {
        int n2 = 0;
        int n3 = bl ? 2 : 1;
        int n4 = byArray.length;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("sendBytes " + string + " inAddr " + inetAddress2.getHostAddress() + " port = " + n + " length = " + n4);
        }
        if (string.compareToIgnoreCase(TCP) == 0) {
            String string2 = IOHandler.makeKey(inetAddress2, n);
            Hashtable hashtable = this.socketTable;
            synchronized (hashtable) {
                Socket socket = this.getSocket(string2);
                while (n2 < n3) {
                    if (socket == null) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("inaddr = " + inetAddress2);
                            this.sipStack.logWriter.logDebug("port = " + n);
                        }
                        socket = this.sipStack.getNetworkLayer().createSocket(inetAddress2, n, inetAddress);
                        OutputStream outputStream = socket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        this.putSocket(string2, socket);
                        break;
                    }
                    try {
                        OutputStream outputStream = socket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        break;
                    }
                    catch (IOException iOException) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logException(iOException);
                        }
                        this.removeSocket(string2);
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        socket = null;
                        ++n2;
                    }
                }
                if (socket == null) {
                    throw new IOException("Could not connect to " + inetAddress2 + ":" + n);
                }
                return socket;
            }
        }
        if (string.compareToIgnoreCase(TLS) == 0) {
            String string3 = IOHandler.makeKey(inetAddress2, n);
            Hashtable hashtable = this.socketTable;
            synchronized (hashtable) {
                Socket socket = this.getSocket(string3);
                while (n2 < n3) {
                    if (socket == null) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("inaddr = " + inetAddress2);
                            this.sipStack.logWriter.logDebug("port = " + n);
                        }
                        socket = !this.sipStack.useTlsAccelerator ? this.sipStack.getNetworkLayer().createSSLSocket(inetAddress2, n, inetAddress) : this.sipStack.getNetworkLayer().createSocket(inetAddress2, n, inetAddress);
                        OutputStream outputStream = socket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        this.putSocket(string3, socket);
                        break;
                    }
                    try {
                        OutputStream outputStream = socket.getOutputStream();
                        this.writeChunks(outputStream, byArray, n4);
                        break;
                    }
                    catch (IOException iOException) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logException(iOException);
                        }
                        this.removeSocket(string3);
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        socket = null;
                        ++n2;
                    }
                }
                if (socket == null) {
                    throw new IOException("Could not connect to " + inetAddress2 + ":" + n);
                }
                return socket;
            }
        }
        DatagramSocket datagramSocket = this.sipStack.getNetworkLayer().createDatagramSocket();
        datagramSocket.connect(inetAddress2, n);
        DatagramPacket datagramPacket = new DatagramPacket(byArray, 0, n4, inetAddress2, n);
        datagramSocket.send(datagramPacket);
        datagramSocket.close();
        return null;
    }

    public void closeAll() {
        Enumeration enumeration = this.socketTable.elements();
        while (enumeration.hasMoreElements()) {
            Socket socket = (Socket)enumeration.nextElement();
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
    }
}

