/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.config;

import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.AbstractConfig;
import com.install4j.runtime.installer.config.InstallerConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nanoxml.XMLElement;

public class ComponentConfig
extends AbstractConfig {
    private String name = "";
    private boolean includesAll;
    private boolean selected;
    private boolean mandatory;
    private List locations = new ArrayList();

    public static boolean isIncludedInSelectedComponents(String string) {
        String string2;
        string = string.replace('\\', '/');
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (installerConfig.getType().equals("macos") && installerConfig.getMacSpecificConfig().isSingleBundle()) {
            string2 = installerConfig.getMacSpecificConfig().getRuntimeDirParent().trim();
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            } else {
                return true;
            }
        }
        if (string.startsWith(".install4j")) {
            return true;
        }
        string2 = installerConfig.getUninstallerFilename().trim();
        if (string2 != null && string2.length() > 0 && (string.equals(string2) || string.startsWith(string2 + ".app"))) {
            return true;
        }
        List list = installerConfig.getComponents();
        if (list.size() == 0) {
            return true;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ComponentConfig componentConfig = (ComponentConfig)iterator.next();
            if (!componentConfig.isSelected()) continue;
            if (componentConfig.isIncludesAll()) {
                return true;
            }
            if (!ComponentConfig.isIncludedInComponent(string, componentConfig)) continue;
            return true;
        }
        return false;
    }

    private static boolean isIncludedInComponent(String string, ComponentConfig componentConfig) {
        Iterator iterator = componentConfig.getLocations().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!ComponentConfig.isEqualOrContained(string2, string) && (!InstallerUtil.isMacOS() || !ComponentConfig.isEqualOrContained(string2 + ".app", string))) continue;
            return true;
        }
        return false;
    }

    private static boolean isEqualOrContained(String string, String string2) {
        return string.equals(string2) || string2.startsWith(string + "/");
    }

    public String getName() {
        return this.name;
    }

    public boolean isIncludesAll() {
        return this.includesAll;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public List getLocations() {
        return this.locations;
    }

    protected void read(XMLElement xMLElement) {
        this.name = ComponentConfig.readAttribute(xMLElement, "name", this.name);
        this.includesAll = ComponentConfig.readAttribute(xMLElement, "allIncluded", this.includesAll);
        this.selected = ComponentConfig.readAttribute(xMLElement, "selected", this.selected);
        this.mandatory = ComponentConfig.readAttribute(xMLElement, "mandatory", this.mandatory);
        Iterator iterator = xMLElement.getChildren().iterator();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            String string = ComponentConfig.readAttribute(xMLElement2, "location", "").replace('\\', '/');
            this.locations.add(string);
        }
    }
}

