/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.map.impl.BasicRecordStoreLoader;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.RecordStore;
import com.hazelcast.map.impl.RecordStoreLoader;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.SizeEstimators;
import com.hazelcast.map.impl.mapstore.MapStoreContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.IndexService;
import com.hazelcast.query.impl.QueryEntry;
import com.hazelcast.spi.DefaultObjectNamespace;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.Clock;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

abstract class AbstractRecordStore
implements RecordStore {
    protected static final long DEFAULT_TTL = -1L;
    protected final ConcurrentMap<Data, Record> records = new ConcurrentHashMap<Data, Record>(1000, 0.75f, 1);
    protected final RecordFactory recordFactory;
    protected final String name;
    protected final MapContainer mapContainer;
    protected final MapServiceContext mapServiceContext;
    protected final SerializationService serializationService;
    protected final int partitionId;
    private SizeEstimator sizeEstimator;

    protected AbstractRecordStore(MapContainer mapContainer, int partitionId) {
        this.mapContainer = mapContainer;
        this.partitionId = partitionId;
        this.mapServiceContext = mapContainer.getMapServiceContext();
        this.serializationService = this.mapServiceContext.getNodeEngine().getSerializationService();
        this.name = mapContainer.getName();
        this.recordFactory = mapContainer.getRecordFactory();
        this.sizeEstimator = SizeEstimators.createMapSizeEstimator();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MapContainer getMapContainer() {
        return this.mapContainer;
    }

    @Override
    public long getHeapCost() {
        return this.sizeEstimator.getSize();
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }

    protected Record createRecord(Data key, Object value, long ttl, long now) {
        return this.mapContainer.createRecord(key, value, ttl, now);
    }

    protected Record createRecord(Data key, Object value, long now) {
        return this.mapContainer.createRecord(key, value, -1L, now);
    }

    protected void accessRecord(Record record, long now) {
        record.setLastAccessTime(now);
        record.onAccess();
    }

    protected void accessRecord(Record record) {
        long now = this.getNow();
        this.accessRecord(record, now);
    }

    protected void updateSizeEstimator(long recordSize) {
        this.sizeEstimator.add(recordSize);
    }

    protected long calculateRecordHeapCost(Record record) {
        return this.sizeEstimator.getCost(record);
    }

    protected long calculateRecordHeapCost(Collection<Record> collection) {
        long totalSize = 0L;
        for (Record record : collection) {
            totalSize += this.calculateRecordHeapCost(record);
        }
        return totalSize;
    }

    protected void resetSizeEstimator() {
        this.sizeEstimator.reset();
    }

    protected void updateRecord(Record record, Object value, long now) {
        this.accessRecord(record, now);
        record.setLastUpdateTime(now);
        record.onUpdate();
        this.recordFactory.setValue(record, value);
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    protected void saveIndex(Record record) {
        Data dataKey = record.getKey();
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            SerializationService ss = this.mapServiceContext.getNodeEngine().getSerializationService();
            QueryEntry queryableEntry = new QueryEntry(ss, dataKey, dataKey, record.getValue());
            indexService.saveEntryIndex(queryableEntry);
        }
    }

    protected void removeIndex(Data key) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            indexService.removeEntryIndex(key);
        }
    }

    protected void removeIndex(Set<Data> keys) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            for (Data key : keys) {
                indexService.removeEntryIndex(key);
            }
        }
    }

    protected void removeIndexByPreservingKeys(Set<Data> keysToRemove, Set<Data> keysToPreserve) {
        IndexService indexService = this.mapContainer.getIndexService();
        if (indexService.hasIndex()) {
            for (Data key : keysToRemove) {
                if (keysToPreserve.contains(key)) continue;
                indexService.removeEntryIndex(key);
            }
        }
    }

    protected LockStore createLockStore() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService == null) {
            return null;
        }
        return lockService.createLockStore(this.partitionId, new DefaultObjectNamespace("hz:impl:mapService", this.name));
    }

    protected void onStore(Record record) {
        if (record != null) {
            record.onStore();
        }
    }

    protected RecordStoreLoader createRecordStoreLoader(MapStoreContext mapStoreContext) {
        return mapStoreContext.getMapStoreWrapper() == null ? RecordStoreLoader.EMPTY_LOADER : new BasicRecordStoreLoader(this);
    }

    protected void clearRecordsMap(Map<Data, Record> excludeRecords) {
        InMemoryFormat inMemoryFormat = this.recordFactory.getStorageFormat();
        switch (inMemoryFormat) {
            case BINARY: 
            case OBJECT: {
                this.records.clear();
                if (excludeRecords != null && !excludeRecords.isEmpty()) {
                    this.records.putAll(excludeRecords);
                }
                return;
            }
            case NATIVE: {
                Iterator iter = this.records.values().iterator();
                while (iter.hasNext()) {
                    Record record = (Record)iter.next();
                    if (excludeRecords != null && excludeRecords.containsKey(record.getKey())) continue;
                    record.invalidate();
                    iter.remove();
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown storage format: " + (Object)((Object)inMemoryFormat));
    }

    protected Data toData(Object value) {
        return this.mapServiceContext.toData(value);
    }

    public void setSizeEstimator(SizeEstimator sizeEstimator) {
        this.sizeEstimator = sizeEstimator;
    }
}

