/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl;

import com.hazelcast.executor.impl.ExecutorServiceProxy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.monitor.LocalExecutorStats;
import com.hazelcast.monitor.impl.LocalExecutorStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.ExecutionTracingService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.ResponseHandler;
import com.hazelcast.spi.StatisticsAwareService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.MapUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DistributedExecutorService
implements ManagedService,
RemoteService,
ExecutionTracingService,
StatisticsAwareService {
    public static final String SERVICE_NAME = "hz:impl:executorService";
    private static final AtomicReferenceFieldUpdater<CallableProcessor, Boolean> RESPONSE_FLAG_FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(CallableProcessor.class, Boolean.class, "responseFlag");
    private NodeEngine nodeEngine;
    private ExecutionService executionService;
    private final ConcurrentMap<String, CallableProcessor> submittedTasks = new ConcurrentHashMap<String, CallableProcessor>(100);
    private final Set<String> shutdownExecutors = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentHashMap<String, LocalExecutorStatsImpl> statsMap = new ConcurrentHashMap();
    private final ConstructorFunction<String, LocalExecutorStatsImpl> localExecutorStatsConstructorFunction = new ConstructorFunction<String, LocalExecutorStatsImpl>(){

        @Override
        public LocalExecutorStatsImpl createNew(String key) {
            return new LocalExecutorStatsImpl();
        }
    };
    private ILogger logger;

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = nodeEngine;
        this.executionService = nodeEngine.getExecutionService();
        this.logger = nodeEngine.getLogger(DistributedExecutorService.class);
    }

    @Override
    public void reset() {
        this.shutdownExecutors.clear();
        this.submittedTasks.clear();
        this.statsMap.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public void execute(String name, String uuid, Callable callable, ResponseHandler responseHandler) {
        this.startPending(name);
        CallableProcessor processor = new CallableProcessor(name, uuid, callable, responseHandler);
        if (uuid != null) {
            this.submittedTasks.put(uuid, processor);
        }
        try {
            this.executionService.execute(name, processor);
        }
        catch (RejectedExecutionException e) {
            this.rejectExecution(name);
            this.logger.warning("While executing " + callable + " on Executor[" + name + "]", e);
            if (uuid != null) {
                this.submittedTasks.remove(uuid);
            }
            processor.sendResponse(e);
        }
    }

    public boolean cancel(String uuid, boolean interrupt) {
        CallableProcessor processor = (CallableProcessor)this.submittedTasks.remove(uuid);
        if (processor != null && processor.cancel(interrupt)) {
            processor.sendResponse(new CancellationException());
            this.getLocalExecutorStats(processor.name).cancelExecution();
            return true;
        }
        return false;
    }

    public void shutdownExecutor(String name) {
        this.executionService.shutdownExecutor(name);
        this.shutdownExecutors.add(name);
    }

    public boolean isShutdown(String name) {
        return this.shutdownExecutors.contains(name);
    }

    @Override
    public ExecutorServiceProxy createDistributedObject(String name) {
        return new ExecutorServiceProxy(name, this.nodeEngine, this);
    }

    @Override
    public void destroyDistributedObject(String name) {
        this.shutdownExecutors.remove(name);
        this.executionService.shutdownExecutor(name);
    }

    LocalExecutorStatsImpl getLocalExecutorStats(String name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localExecutorStatsConstructorFunction);
    }

    private void startExecution(String name, long elapsed) {
        this.getLocalExecutorStats(name).startExecution(elapsed);
    }

    private void finishExecution(String name, long elapsed) {
        this.getLocalExecutorStats(name).finishExecution(elapsed);
    }

    private void startPending(String name) {
        this.getLocalExecutorStats(name).startPending();
    }

    private void rejectExecution(String name) {
        this.getLocalExecutorStats(name).rejectExecution();
    }

    @Override
    public boolean isOperationExecuting(Address callerAddress, String callerUuid, Object identifier) {
        String uuid = String.valueOf(identifier);
        return this.submittedTasks.containsKey(uuid);
    }

    public Map<String, LocalExecutorStats> getStats() {
        Map<String, LocalExecutorStats> executorStats = MapUtil.createHashMap(this.statsMap.size());
        for (Map.Entry<String, LocalExecutorStatsImpl> queueStat : this.statsMap.entrySet()) {
            executorStats.put(queueStat.getKey(), queueStat.getValue());
        }
        return executorStats;
    }

    private final class CallableProcessor
    extends FutureTask
    implements Runnable {
        volatile Boolean responseFlag;
        private final String name;
        private final String uuid;
        private final ResponseHandler responseHandler;
        private final String callableToString;
        private final long creationTime;

        private CallableProcessor(String name, String uuid, Callable callable, ResponseHandler responseHandler) {
            super(callable);
            this.responseFlag = Boolean.FALSE;
            this.creationTime = Clock.currentTimeMillis();
            this.name = name;
            this.uuid = uuid;
            this.callableToString = String.valueOf(callable);
            this.responseHandler = responseHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = Clock.currentTimeMillis();
            DistributedExecutorService.this.startExecution(this.name, start - this.creationTime);
            Exception result = null;
            try {
                super.run();
                if (!this.isCancelled()) {
                    result = (Exception)this.get();
                }
            }
            catch (Exception e) {
                this.logException(e);
                result = e;
            }
            finally {
                if (this.uuid != null) {
                    DistributedExecutorService.this.submittedTasks.remove(this.uuid);
                }
                this.sendResponse(result);
                if (!this.isCancelled()) {
                    DistributedExecutorService.this.finishExecution(this.name, Clock.currentTimeMillis() - start);
                }
            }
        }

        private void logException(Exception e) {
            if (DistributedExecutorService.this.logger.isFinestEnabled()) {
                DistributedExecutorService.this.logger.finest("While executing callable: " + this.callableToString, e);
            }
        }

        private void sendResponse(Object result) {
            if (RESPONSE_FLAG_FIELD_UPDATER.compareAndSet(this, Boolean.FALSE, Boolean.TRUE)) {
                this.responseHandler.sendResponse(result);
            }
        }
    }
}

