/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.examples.interpreter;

import org.xml.sax.SAXException;
import weblogicx.xml.stream.EndElementEvent;
import weblogicx.xml.stream.StartElementEvent;
import weblogicx.xml.stream.TextEvent;
import weblogicx.xml.stream.XMLEvent;
import weblogicx.xml.stream.XMLEventStream;

public class ExpressionReader {
    public static final int STARTEVENT = 1;
    public static final int ENDEVENT = 2;
    public static final int TEXTEVENT = 3;
    public static final int OTHEREVENT = 4;
    private XMLEvent xmlEvent;
    private XMLEventStream stream;

    public XMLEvent getEvent() {
        return this.xmlEvent;
    }

    public ExpressionReader(XMLEventStream xMLEventStream) throws SAXException {
        this.stream = xMLEventStream;
        this.read();
    }

    public boolean read(int n) throws SAXException {
        this.read();
        if (this.getType(this.xmlEvent) != n) {
            throw new SAXException("Unexpected Event");
        }
        return true;
    }

    public boolean read(int n, String string) throws SAXException {
        this.read();
        if (this.getType(this.xmlEvent) != n) {
            throw new SAXException("Unexpected Element:" + this.xmlEvent);
        }
        return true;
    }

    public boolean read() throws SAXException {
        this.xmlEvent = this.stream.next();
        while (this.getType(this.xmlEvent) == 4 && this.stream.hasNext()) {
            this.xmlEvent = this.stream.next();
        }
        return true;
    }

    public void skipSpace() throws SAXException {
        while (this.getType(this.xmlEvent) == 3 && this.stream.hasNext()) {
            this.xmlEvent = this.stream.next();
        }
    }

    public int getType(XMLEvent xMLEvent) {
        if (xMLEvent instanceof StartElementEvent) {
            return 1;
        }
        if (xMLEvent instanceof EndElementEvent) {
            return 2;
        }
        if (xMLEvent instanceof TextEvent) {
            return 3;
        }
        return 4;
    }
}

