/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.map;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapGetAllCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAllPartitionsMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.operation.MapGetAllOperationFactory;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.OperationFactory;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapGetAllMessageTask
extends AbstractAllPartitionsMessageTask<MapGetAllCodec.RequestParameters> {
    public MapGetAllMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected OperationFactory createOperationFactory() {
        return new MapGetAllOperationFactory(((MapGetAllCodec.RequestParameters)this.parameters).name, (Set)((MapGetAllCodec.RequestParameters)this.parameters).keys);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        HashMap<Data, Data> dataMap = new HashMap<Data, Data>();
        MapService mapService = (MapService)this.getService("hz:impl:mapService");
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            MapEntrySet mapEntrySet = (MapEntrySet)mapService.getMapServiceContext().toObject(entry.getValue());
            Set<Map.Entry<Data, Data>> entrySet = mapEntrySet.getEntrySet();
            for (Map.Entry<Data, Data> dataEntry : entrySet) {
                dataMap.put(dataEntry.getKey(), dataEntry.getValue());
            }
        }
        return dataMap;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    protected MapGetAllCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MapGetAllCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MapGetAllCodec.encodeResponse((Map)response);
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(((MapGetAllCodec.RequestParameters)this.parameters).name, "read");
    }

    @Override
    public String getDistributedObjectName() {
        return ((MapGetAllCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return "getAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((MapGetAllCodec.RequestParameters)this.parameters).keys};
    }
}

