/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import com.voxeo.logging.Loggerf;
import com.voxeo.ssl.EasySSLProtocolSocketFactory;
import com.voxeo.utils.Closer;
import com.voxeo.utils.HttpCallback;
import com.voxeo.utils.Objects;
import com.voxeo.utils.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.joda.time.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTemplate {
    private static final Loggerf log = Loggerf.getLogger(HttpTemplate.class);
    private final HttpClient client;
    private String url;
    private Map<String, String> params;
    private byte[] body;
    private String authToken;
    private String contentType;
    private String username;
    private String password;

    public HttpTemplate(String url, Map<String, String> params) {
        this.url = url;
        this.params = params;
        this.client = new HttpClient();
    }

    public HttpTemplate(String url) {
        this(url, null);
    }

    public HttpTemplate() {
        this.client = new HttpClient();
    }

    public HttpTemplate(String url, int retryCount) {
        this(url, null);
        DefaultHttpMethodRetryHandler retryHandler = retryCount > 0 ? new DefaultHttpMethodRetryHandler(retryCount, true) : new DefaultHttpMethodRetryHandler(0, false);
        this.client.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
    }

    public void addParameter(String key, String value) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void head() throws IOException {
        HeadMethod method = null;
        try {
            method = new HeadMethod(this.url);
            this.execute((HttpMethod)method, true);
            this.release((HttpMethod)method);
        }
        catch (Throwable throwable) {
            this.release((HttpMethod)method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() throws IOException {
        GetMethod method = null;
        try {
            method = new GetMethod(this.url);
            this.doGet((HttpMethod)method, true);
            String string = method.getResponseBodyAsString();
            this.release((HttpMethod)method);
            return string;
        }
        catch (Throwable throwable) {
            this.release((HttpMethod)method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void get(HttpCallback callback) throws HttpException, IOException {
        GetMethod method = null;
        BufferedReader in = null;
        try {
            method = new GetMethod(this.url);
            int status = this.doGet((HttpMethod)method, false);
            in = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
            callback.go(status, in);
        }
        catch (Throwable throwable) {
            Closer.close(in);
            this.release((HttpMethod)method);
            throw throwable;
        }
        Closer.close(in);
        this.release((HttpMethod)method);
    }

    public String post() throws IOException {
        return this.post(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(boolean multipart) throws IOException {
        PostMethod method = null;
        try {
            method = new PostMethod(this.url);
            this.doPost(method, multipart, true);
            String string = method.getResponseBodyAsString();
            this.release((HttpMethod)method);
            return string;
        }
        catch (Throwable throwable) {
            this.release((HttpMethod)method);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(HttpCallback callback, boolean multipart) throws IOException {
        PostMethod method = null;
        BufferedReader in = null;
        try {
            method = new PostMethod(this.url);
            int status = this.doPost(method, multipart, false);
            in = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream()));
            callback.go(status, in);
        }
        catch (Throwable throwable) {
            Closer.close(in);
            this.release((HttpMethod)method);
            throw throwable;
        }
        Closer.close(in);
        this.release((HttpMethod)method);
    }

    public static void main(String[] args) throws IOException {
        System.out.println(new HttpTemplate("https://localhost:9976/services/auth/login", Objects.toMap(new String[][]{{"username", "prophecy"}, {"password", "prophecy"}})).post(false));
    }

    private int doPost(PostMethod method, boolean multipart, boolean failFast) throws IOException {
        if (this.params != null) {
            if (multipart) {
                Part[] parts = new Part[this.params.size()];
                int idx = 0;
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    parts[idx++] = new StringPart(entry.getKey(), entry.getValue());
                }
                method.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, method.getParams()));
            } else {
                NameValuePair[] pairs = new NameValuePair[this.params.size()];
                int idx = 0;
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    pairs[idx++] = new NameValuePair(entry.getKey(), entry.getValue());
                }
                method.setRequestBody(pairs);
            }
        }
        if (this.body != null) {
            ByteArrayRequestEntity entity = !Strings.isEmpty(this.contentType) ? new ByteArrayRequestEntity(this.body, this.contentType) : new ByteArrayRequestEntity(this.body);
            method.setRequestEntity((RequestEntity)entity);
        }
        return this.execute((HttpMethod)method, failFast);
    }

    private int execute(HttpMethod method, boolean failFast) throws IOException, HttpException {
        log.trace("Executing HTTP method %s to URL %s with params %s", method.getName(), this.url, this.params);
        this.doAuthorization(method);
        int code = this.client.executeMethod(method);
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                break;
            }
            default: {
                String errorMessage = String.format("Error performing %s on URL %s status code = %d", method.getName(), this.url, code);
                if (log.isDebugEnabled()) {
                    log.debug("%s, error body: %s", errorMessage, method.getResponseBodyAsString());
                }
                if (!failFast) break;
                throw new IOException(errorMessage);
            }
        }
        return code;
    }

    private int doGet(HttpMethod method, boolean failFast) throws IOException {
        if (this.params != null) {
            NameValuePair[] pairs = new NameValuePair[this.params.size()];
            int idx = 0;
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                pairs[idx++] = new NameValuePair(entry.getKey(), entry.getValue());
            }
            method.setQueryString(pairs);
        }
        return this.execute(method, failFast);
    }

    private void doAuthorization(HttpMethod method) {
        if (!Strings.isEmpty(this.authToken)) {
            method.setDoAuthentication(true);
            method.setRequestHeader("Authorization", this.authToken);
        } else if (this.username != null && this.password != null) {
            this.client.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
        }
    }

    private void release(HttpMethod method) {
        if (method != null) {
            try {
                method.releaseConnection();
            }
            catch (Exception e) {
                log.error("Error releasing method connection", e);
            }
        }
    }

    public void setConnectionTimeout(int newTimeoutInMilliseconds) {
        this.client.getHttpConnectionManager().getParams().setConnectionTimeout(newTimeoutInMilliseconds);
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public void setAuthCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBody(String body) {
        this.body = body.getBytes();
    }

    public void setBody(String body, String charset) throws UnsupportedEncodingException {
        this.body = body.getBytes(charset);
    }

    @Deprecated
    public void setTimeout(int timeout) {
        this.setTimeout(new Duration((long)timeout));
    }

    public void setTimeout(Duration timeout) {
        this.client.getParams().setSoTimeout((int)timeout.getMillis());
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    static {
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)new EasySSLProtocolSocketFactory(), 443));
    }
}

