/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.NameValue;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.header.ParametersHeader;
import gov.nist.javax.sip.header.Protocol;
import gov.nist.javax.sip.stack.HopImpl;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Hop;
import javax.sip.header.Parameters;
import javax.sip.header.ViaHeader;

public class Via
extends ParametersHeader
implements ViaHeader {
    private static final long serialVersionUID = 5281728373401351378L;
    public static final String BRANCH = "branch";
    public static final String RECEIVED = "received";
    public static final String MADDR = "maddr";
    public static final String TTL = "ttl";
    public static final String RPORT = "rport";
    protected Protocol sentProtocol = new Protocol();
    protected HostPort sentBy;
    protected String comment;

    public Via() {
        super("Via");
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ViaHeader) {
            ViaHeader viaHeader = (ViaHeader)object;
            return this.getProtocol().equalsIgnoreCase(viaHeader.getProtocol()) && this.getTransport().equalsIgnoreCase(viaHeader.getTransport()) && this.getHost().equalsIgnoreCase(viaHeader.getHost()) && this.getPort() == viaHeader.getPort() && this.equalParameters((Parameters)viaHeader);
        }
        return false;
    }

    public String getProtocolVersion() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocolVersion();
    }

    public Protocol getSentProtocol() {
        return this.sentProtocol;
    }

    public HostPort getSentBy() {
        return this.sentBy;
    }

    public Hop getHop() {
        HopImpl hopImpl = new HopImpl(this.sentBy.getHost().getHostname(), this.sentBy.getPort(), this.sentProtocol.getTransport());
        return hopImpl;
    }

    public NameValueList getViaParms() {
        return this.parameters;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean hasPort() {
        return this.getSentBy().hasPort();
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void removePort() {
        this.sentBy.removePort();
    }

    public void removeComment() {
        this.comment = null;
    }

    public void setProtocolVersion(String string) {
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocolVersion(string);
    }

    public void setHost(Host host) {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setHost(host);
    }

    public void setSentProtocol(Protocol protocol) {
        this.sentProtocol = protocol;
    }

    public void setSentBy(HostPort hostPort) {
        this.sentBy = hostPort;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    protected String encodeBody() {
        return this.encodeBody(new StringBuffer()).toString();
    }

    protected StringBuffer encodeBody(StringBuffer stringBuffer) {
        this.sentProtocol.encode(stringBuffer);
        stringBuffer.append(" ");
        this.sentBy.encode(stringBuffer);
        if (!this.parameters.isEmpty()) {
            stringBuffer.append(";");
            this.parameters.encode(stringBuffer);
        }
        if (this.comment != null) {
            stringBuffer.append(" ").append("(").append(this.comment).append(")");
        }
        return stringBuffer;
    }

    public void setHost(String string) throws ParseException {
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        try {
            Host host = new Host(string);
            this.sentBy.setHost(host);
        }
        catch (Exception exception) {
            throw new NullPointerException(" host parameter is null");
        }
    }

    public String getHost() {
        if (this.sentBy == null) {
            return null;
        }
        Host host = this.sentBy.getHost();
        if (host == null) {
            return null;
        }
        return host.getHostname();
    }

    public void setPort(int n) throws InvalidArgumentException {
        if (n != -1 && (n < 1 || n > 65535)) {
            throw new InvalidArgumentException("Port value out of range -1, [1..65535]");
        }
        if (this.sentBy == null) {
            this.sentBy = new HostPort();
        }
        this.sentBy.setPort(n);
    }

    public void setRPort() {
        try {
            this.setParameter(RPORT, "");
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    public int getPort() {
        if (this.sentBy == null) {
            return -1;
        }
        return this.sentBy.getPort();
    }

    public int getRPort() {
        String string = this.getParameter(RPORT);
        if (string != null) {
            return new Integer(string);
        }
        return -1;
    }

    public String getTransport() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getTransport();
    }

    public void setTransport(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setTransport(), the transport parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setTransport(string);
    }

    public String getProtocol() {
        if (this.sentProtocol == null) {
            return null;
        }
        return this.sentProtocol.getProtocol();
    }

    public void setProtocol(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setProtocol(), the protocol parameter is null.");
        }
        if (this.sentProtocol == null) {
            this.sentProtocol = new Protocol();
        }
        this.sentProtocol.setProtocol(string);
    }

    public int getTTL() {
        int n = this.getParameterAsInt(TTL);
        return n;
    }

    public void setTTL(int n) throws InvalidArgumentException {
        if (n < 0 && n != -1) {
            throw new InvalidArgumentException("JAIN-SIP Exception, Via, setTTL(), the ttl parameter is < 0");
        }
        this.setParameter(new NameValue(TTL, new Integer(n)));
    }

    public String getMAddr() {
        return this.getParameter(MADDR);
    }

    public void setMAddr(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setMAddr(), the mAddr parameter is null.");
        }
        Host host = new Host();
        host.setAddress(string);
        NameValue nameValue = new NameValue(MADDR, host);
        this.setParameter(nameValue);
    }

    public String getReceived() {
        return this.getParameter(RECEIVED);
    }

    public void setReceived(String string) throws ParseException {
        if (string == null) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setReceived(), the received parameter is null.");
        }
        this.setParameter(RECEIVED, string);
    }

    public String getBranch() {
        return this.getParameter(BRANCH);
    }

    public void setBranch(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            throw new NullPointerException("JAIN-SIP Exception, Via, setBranch(), the branch parameter is null or length 0.");
        }
        this.setParameter(BRANCH, string);
    }

    public Object clone() {
        Via via = (Via)super.clone();
        if (this.sentProtocol != null) {
            via.sentProtocol = (Protocol)this.sentProtocol.clone();
        }
        if (this.sentBy != null) {
            via.sentBy = (HostPort)this.sentBy.clone();
        }
        return via;
    }
}

