/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.jabber.ActiveCallsRepositoryJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallPeerJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomConfigurationFormJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ChatRoomMemberJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ContactJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.MessageJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetMultiUserChatJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetPersistentPresenceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.extensions.ConferenceDescriptionPacketExtension;
import net.java.sip.communicator.service.protocol.AbstractChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomConfigurationForm;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.ChatRoomMemberRole;
import net.java.sip.communicator.service.protocol.ConferenceDescription;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomLocalUserRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPresenceListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberPropertyChangeListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMemberRoleListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageListener;
import net.java.sip.communicator.service.protocol.event.ChatRoomMessageReceivedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeFailedEvent;
import net.java.sip.communicator.service.protocol.event.ChatRoomPropertyChangeListener;
import net.java.sip.communicator.service.protocol.jabberconstants.JabberStatusEnum;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jitsi.util.StringUtils;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.MessageEventManager;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.packet.MessageEvent;

public class ChatRoomJabberImpl
extends AbstractChatRoom {
    private static final Logger logger = Logger.getLogger(ChatRoomJabberImpl.class);
    private MultiUserChat multiUserChat = null;
    private final Vector<ChatRoomMemberPresenceListener> memberListeners = new Vector();
    private final Vector<ChatRoomMemberRoleListener> memberRoleListeners = new Vector();
    private final Vector<ChatRoomLocalUserRoleListener> localUserRoleListeners = new Vector();
    private final Vector<ChatRoomMessageListener> messageListeners = new Vector();
    private final Vector<ChatRoomPropertyChangeListener> propertyChangeListeners = new Vector();
    private final Vector<ChatRoomMemberPropertyChangeListener> memberPropChangeListeners = new Vector();
    private final ProtocolProviderServiceJabberImpl provider;
    private final OperationSetMultiUserChatJabberImpl opSetMuc;
    private final Hashtable<String, ChatRoomMemberJabberImpl> members = new Hashtable();
    private final Hashtable<String, ChatRoomMember> banList = new Hashtable();
    private String nickname;
    private String oldSubject;
    private ChatRoomMemberRole role = null;
    private ChatRoomConfigurationFormJabberImpl configForm;
    private InvitationRejectionListeners invitationRejectionListeners = new InvitationRejectionListeners();
    private ConferenceDescription publishedConference = null;
    private ConferenceDescriptionPacketExtension publishedConferenceExt = null;
    private Presence lastPresenceSent = null;
    private List<CallJabberImpl> chatRoomConferenceCalls = new ArrayList<CallJabberImpl>();
    private PresenceListener presenceListener = null;

    public ChatRoomJabberImpl(MultiUserChat multiUserChat, ProtocolProviderServiceJabberImpl provider) {
        this.multiUserChat = multiUserChat;
        this.provider = provider;
        this.opSetMuc = (OperationSetMultiUserChatJabberImpl)provider.getOperationSet(OperationSetMultiUserChat.class);
        this.oldSubject = multiUserChat.getSubject();
        multiUserChat.addSubjectUpdatedListener((SubjectUpdatedListener)new SmackSubjectUpdatedListener());
        multiUserChat.addMessageListener((PacketListener)new SmackMessageListener());
        multiUserChat.addParticipantStatusListener((ParticipantStatusListener)new MemberListener());
        multiUserChat.addUserStatusListener((UserStatusListener)new UserListener());
        multiUserChat.addPresenceInterceptor((PacketInterceptor)new PresenceInterceptor());
        this.provider.getConnection().addPacketListener((PacketListener)this.invitationRejectionListeners, (PacketFilter)new PacketTypeFilter(Message.class));
    }

    private MUCUser getMUCUserExtension(Packet packet) {
        if (packet != null) {
            return (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            if (!this.propertyChangeListeners.contains(listener)) {
                this.propertyChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(ChatRoomPropertyChangeListener listener) {
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            this.propertyChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            if (!this.memberPropChangeListeners.contains(listener)) {
                this.memberPropChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberPropertyChangeListener(ChatRoomMemberPropertyChangeListener listener) {
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            this.memberPropChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(ChatRoomMessageListener listener) {
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            if (!this.messageListeners.contains(listener)) {
                this.messageListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(ChatRoomMessageListener listener) {
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            this.messageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            if (!this.memberListeners.contains(listener)) {
                this.memberListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberPresenceListener(ChatRoomMemberPresenceListener listener) {
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            this.memberListeners.remove(listener);
        }
    }

    public synchronized void addConferenceCall(CallJabberImpl call) {
        if (!this.chatRoomConferenceCalls.contains((Object)call)) {
            this.chatRoomConferenceCalls.add(call);
        }
    }

    public synchronized void removeConferenceCall(CallJabberImpl call) {
        if (this.chatRoomConferenceCalls.contains((Object)call)) {
            this.chatRoomConferenceCalls.remove((Object)call);
        }
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(byte[] content, String contentType, String contentEncoding, String subject) {
        return new MessageJabberImpl(new String(content), contentType, contentEncoding, subject);
    }

    public net.java.sip.communicator.service.protocol.Message createMessage(String messageText) {
        MessageJabberImpl msg = new MessageJabberImpl(messageText, "text/plain", "UTF-8", null);
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChatRoomMember> getMembers() {
        Hashtable<String, ChatRoomMemberJabberImpl> hashtable = this.members;
        synchronized (hashtable) {
            return new LinkedList<ChatRoomMemberJabberImpl>(this.members.values());
        }
    }

    public int getMembersCount() {
        return this.multiUserChat.getOccupantsCount();
    }

    public String getName() {
        return this.multiUserChat.getRoom();
    }

    public String getIdentifier() {
        return this.multiUserChat.getRoom();
    }

    public String getUserNickname() {
        return this.multiUserChat.getNickname();
    }

    public Contact getPrivateContactByNickname(String nickname) {
        String jid;
        OperationSetPersistentPresenceJabberImpl opSetPersPresence = (OperationSetPersistentPresenceJabberImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        Object sourceContact = opSetPersPresence.findContactByID(jid = this.getName() + "/" + nickname);
        if (sourceContact == null) {
            sourceContact = opSetPersPresence.createVolatileContact(jid, true);
        }
        return sourceContact;
    }

    public String getSubject() {
        return this.multiUserChat.getSubject();
    }

    public void invite(String userAddress, String reason) {
        this.multiUserChat.invite(userAddress, reason);
    }

    public boolean isJoined() {
        return this.multiUserChat.isJoined();
    }

    public void join(byte[] password) throws OperationFailedException {
        this.joinAs(JabberActivator.getGlobalDisplayDetailsService().getDisplayName(this.getParentProvider()), password);
    }

    public void join() throws OperationFailedException {
        this.joinAs(JabberActivator.getGlobalDisplayDetailsService().getDisplayName(this.getParentProvider()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinAs(String nickname, byte[] password) throws OperationFailedException {
        this.assertConnected();
        this.nickname = ChatRoomJabberImpl.getNickName(org.jivesoftware.smack.util.StringUtils.parseName((String)nickname));
        if (this.nickname.length() == 0) {
            this.nickname = nickname;
        }
        try {
            if (this.multiUserChat.isJoined()) {
                if (!this.multiUserChat.getNickname().equals(nickname)) {
                    this.multiUserChat.changeNickname(nickname);
                }
            } else {
                this.presenceListener = new PresenceListener((ChatRoom)this);
                this.provider.getConnection().addPacketListener((PacketListener)this.presenceListener, (PacketFilter)new AndFilter(new PacketFilter[]{new FromMatchesFilter(this.multiUserChat.getRoom()), new PacketTypeFilter(Presence.class)}));
                if (password == null) {
                    this.multiUserChat.join(nickname);
                } else {
                    this.multiUserChat.join(nickname, new String(password));
                }
            }
            ChatRoomMemberJabberImpl member = new ChatRoomMemberJabberImpl(this, nickname, this.provider.getAccountID().getAccountAddress());
            Hashtable<String, ChatRoomMemberJabberImpl> hashtable = this.members;
            synchronized (hashtable) {
                this.members.put(nickname, member);
            }
            this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)this, "LocalUserJoined", null);
        }
        catch (XMPPException ex) {
            if (ex.getXMPPError() == null) {
                String errorMessage = "Failed to join room " + this.getName() + " with nickname: " + nickname;
                logger.error((Object)errorMessage, (Throwable)ex);
                throw new OperationFailedException(errorMessage, 1, (Throwable)ex);
            }
            if (ex.getXMPPError().getCode() == 401) {
                String errorMessage = "Failed to join chat room " + this.getName() + " with nickname: " + nickname + ". The chat room requests a password.";
                logger.error((Object)errorMessage, (Throwable)ex);
                throw new OperationFailedException(errorMessage, 401, (Throwable)ex);
            }
            if (ex.getXMPPError().getCode() == 407) {
                String errorMessage = "Failed to join chat room " + this.getName() + " with nickname: " + nickname + ". The chat room requires registration.";
                logger.error((Object)errorMessage, (Throwable)ex);
                throw new OperationFailedException(errorMessage, 13, (Throwable)ex);
            }
            String errorMessage = "Failed to join room " + this.getName() + " with nickname: " + nickname;
            logger.error((Object)errorMessage, (Throwable)ex);
            throw new OperationFailedException(errorMessage, 1, (Throwable)ex);
        }
        catch (Throwable ex) {
            String errorMessage = "Failed to join room " + this.getName() + " with nickname: " + nickname;
            logger.error((Object)errorMessage, ex);
            throw new OperationFailedException(errorMessage, 1, ex);
        }
    }

    public void joinAs(String nickname) throws OperationFailedException {
        this.joinAs(nickname, null);
    }

    public static ChatRoomMemberRole smackRoleToScRole(String smackRole, String affiliation) {
        if (affiliation != null) {
            if (affiliation.equals("admin")) {
                return ChatRoomMemberRole.ADMINISTRATOR;
            }
            if (affiliation.equals("owner")) {
                return ChatRoomMemberRole.OWNER;
            }
        }
        if (smackRole != null) {
            if (smackRole.equalsIgnoreCase("moderator")) {
                return ChatRoomMemberRole.MODERATOR;
            }
            if (smackRole.equalsIgnoreCase("participant")) {
                return ChatRoomMemberRole.MEMBER;
            }
        }
        return ChatRoomMemberRole.GUEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatRoomMemberJabberImpl smackParticipantToScMember(String participant) {
        String participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)participant);
        Hashtable<String, ChatRoomMemberJabberImpl> hashtable = this.members;
        synchronized (hashtable) {
            for (ChatRoomMemberJabberImpl member : this.members.values()) {
                if (!participantName.equals(member.getName()) && !participant.equals(member.getContactAddress()) && !participantName.equals(member.getContactAddress())) continue;
                return member;
            }
        }
        return null;
    }

    public boolean destroy(String reason, String alternateAddress) {
        try {
            this.multiUserChat.destroy(reason, alternateAddress);
        }
        catch (XMPPException e) {
            logger.warn((Object)"Error occured while destroying chat room", (Throwable)e);
            return false;
        }
        return true;
    }

    public void leave() {
        this.leave(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leave(String reason, String alternateAddress) {
        Hashtable<String, ChatRoomMemberJabberImpl> membersCopy;
        ArrayList<CallJabberImpl> tmpConferenceCalls;
        Object callid;
        OperationSetBasicTelephonyJabberImpl basicTelephony = (OperationSetBasicTelephonyJabberImpl)this.provider.getOperationSet(OperationSetBasicTelephony.class);
        if (basicTelephony != null && this.publishedConference != null) {
            ActiveCallsRepositoryJabberGTalkImpl<CallJabberImpl, CallPeerJabberImpl> activeRepository = basicTelephony.getActiveCallsRepository();
            callid = this.publishedConference.getCallId();
            if (callid != null) {
                CallJabberImpl call = activeRepository.findCallId((String)callid);
                for (CallPeerJabberImpl callPeerJabberImpl : call.getCallPeerList()) {
                    callPeerJabberImpl.hangup(false, null, null);
                }
            }
        }
        callid = this.chatRoomConferenceCalls;
        synchronized (callid) {
            tmpConferenceCalls = new ArrayList<CallJabberImpl>(this.chatRoomConferenceCalls);
            this.chatRoomConferenceCalls.clear();
        }
        for (CallJabberImpl call : tmpConferenceCalls) {
            for (CallPeerJabberImpl callPeerJabberImpl : call.getCallPeerList()) {
                callPeerJabberImpl.hangup(false, null, null);
            }
        }
        this.clearCachedConferenceDescriptionList();
        XMPPConnection connection = this.provider.getConnection();
        try {
            if (connection != null) {
                this.multiUserChat.leave();
            }
        }
        catch (Throwable e) {
            logger.warn((Object)"Error occured while leaving, maybe just disconnected before leaving", e);
        }
        Iterator<ChatRoomMemberJabberImpl> iterator = this.members;
        synchronized (iterator) {
            membersCopy = new Hashtable<String, ChatRoomMemberJabberImpl>(this.members);
            this.members.clear();
        }
        for (ChatRoomMember chatRoomMember : membersCopy.values()) {
            this.fireMemberPresenceEvent(chatRoomMember, "MemberLeft", "Local user has left the chat room.");
        }
        if (connection != null) {
            connection.removePacketListener((PacketListener)this.invitationRejectionListeners);
            if (this.presenceListener != null) {
                connection.removePacketListener((PacketListener)this.presenceListener);
                this.presenceListener = null;
            }
        }
        this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)this, "LocalUserLeft", reason, alternateAddress);
    }

    public void sendMessage(net.java.sip.communicator.service.protocol.Message message) throws OperationFailedException {
        try {
            this.assertConnected();
            Message msg = new Message();
            msg.setBody(message.getContent());
            MessageEventManager.addNotificationsRequests((Message)msg, (boolean)true, (boolean)false, (boolean)false, (boolean)true);
            this.multiUserChat.sendMessage(message.getContent());
        }
        catch (XMPPException ex) {
            logger.error((Object)("Failed to send message " + message), (Throwable)ex);
            throw new OperationFailedException("Failed to send message " + message, 1, (Throwable)ex);
        }
    }

    public void setSubject(String subject) throws OperationFailedException {
        try {
            this.multiUserChat.changeSubject(subject);
        }
        catch (XMPPException ex) {
            logger.error((Object)("Failed to change subject for chat room" + this.getName()), (Throwable)ex);
            throw new OperationFailedException("Failed to changed subject for chat room" + this.getName(), 403, (Throwable)ex);
        }
    }

    public ProtocolProviderService getParentProvider() {
        return this.provider;
    }

    public ChatRoomMemberRole getUserRole() {
        if (this.role == null) {
            Occupant o = this.multiUserChat.getOccupant(this.multiUserChat.getRoom() + "/" + this.multiUserChat.getNickname());
            if (o == null) {
                return ChatRoomMemberRole.GUEST;
            }
            this.role = ChatRoomJabberImpl.smackRoleToScRole(o.getRole(), o.getAffiliation());
        }
        return this.role;
    }

    public void setLocalUserRole(ChatRoomMemberRole role) {
        this.setLocalUserRole(role, false);
    }

    public void setLocalUserRole(ChatRoomMemberRole role, boolean isInitial) {
        this.fireLocalUserRoleEvent(this.getUserRole(), role, isInitial);
        this.role = role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            if (!this.localUserRoleListeners.contains(listener)) {
                this.localUserRoleListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removelocalUserRoleListener(ChatRoomLocalUserRoleListener listener) {
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            this.localUserRoleListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberRoleListener(ChatRoomMemberRoleListener listener) {
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            if (!this.memberRoleListeners.contains(listener)) {
                this.memberRoleListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMemberRoleListener(ChatRoomMemberRoleListener listener) {
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            this.memberRoleListeners.remove(listener);
        }
    }

    public Iterator<ChatRoomMember> getBanList() throws OperationFailedException {
        return this.banList.values().iterator();
    }

    public void setUserNickname(String nickname) throws OperationFailedException {
        try {
            this.multiUserChat.changeNickname(nickname);
            int atIndex = nickname.lastIndexOf("@");
            this.nickname = atIndex <= 0 ? nickname : nickname.substring(0, atIndex);
        }
        catch (XMPPException e) {
            logger.error((Object)("Failed to change nickname for chat room: " + this.getName()));
            throw new OperationFailedException("The " + nickname + "already exists in this chat room.", 10);
        }
    }

    public void banParticipant(ChatRoomMember chatRoomMember, String reason) throws OperationFailedException {
        try {
            this.multiUserChat.banUser(((ChatRoomMemberJabberImpl)chatRoomMember).getJabberID(), reason);
        }
        catch (XMPPException e) {
            logger.error((Object)"Failed to ban participant.", (Throwable)e);
            if (e.getXMPPError().getCode() == 405) {
                throw new OperationFailedException("Kicking an admin user or a chat room owner is a forbidden operation.", 403);
            }
            throw new OperationFailedException("An error occured while trying to kick the participant.", 1);
        }
    }

    public void kickParticipant(ChatRoomMember member, String reason) throws OperationFailedException {
        try {
            this.multiUserChat.kickParticipant(member.getName(), reason);
        }
        catch (XMPPException e) {
            logger.error((Object)"Failed to kick participant.", (Throwable)e);
            if (e.getXMPPError().getCode() == 405) {
                throw new OperationFailedException("Kicking an admin user or a chat room owner is a forbidden operation.", 403);
            }
            if (e.getXMPPError().getCode() == 403) {
                throw new OperationFailedException("The user that intended to kick another participant does not have enough privileges to do that.", 12);
            }
            throw new OperationFailedException("An error occured while trying to kick the participant.", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMemberPresenceEvent(ChatRoomMember member, String eventID, String eventReason) {
        ChatRoomMemberPresenceChangeEvent evt = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, member, eventID, eventReason);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Iterator<ChatRoomMemberPresenceListener> listeners = null;
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPresenceListener>(this.memberListeners).iterator();
        }
        while (listeners.hasNext()) {
            ChatRoomMemberPresenceListener listener = listeners.next();
            listener.memberPresenceChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMemberPresenceEvent(ChatRoomMember member, ChatRoomMember actor, String eventID, String eventReason) {
        ArrayList<ChatRoomMemberPresenceListener> listeners;
        ChatRoomMemberPresenceChangeEvent evt = new ChatRoomMemberPresenceChangeEvent((ChatRoom)this, member, actor, eventID, eventReason);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomMemberPresenceListener> vector = this.memberListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPresenceListener>(this.memberListeners);
        }
        for (ChatRoomMemberPresenceListener listener : listeners) {
            listener.memberPresenceChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMemberRoleEvent(ChatRoomMember member, ChatRoomMemberRole previousRole, ChatRoomMemberRole newRole) {
        ArrayList<ChatRoomMemberRoleListener> listeners;
        member.setRole(newRole);
        ChatRoomMemberRoleChangeEvent evt = new ChatRoomMemberRoleChangeEvent((ChatRoom)this, member, previousRole, newRole);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomMemberRoleListener> vector = this.memberRoleListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberRoleListener>(this.memberRoleListeners);
        }
        for (ChatRoomMemberRoleListener listener : listeners) {
            listener.memberRoleChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMessageEvent(EventObject evt) {
        ArrayList<ChatRoomMessageListener> listeners;
        Vector<ChatRoomMessageListener> vector = this.messageListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMessageListener>(this.messageListeners);
        }
        for (ChatRoomMessageListener listener : listeners) {
            try {
                if (evt instanceof ChatRoomMessageDeliveredEvent) {
                    listener.messageDelivered((ChatRoomMessageDeliveredEvent)evt);
                    continue;
                }
                if (evt instanceof ChatRoomMessageReceivedEvent) {
                    listener.messageReceived((ChatRoomMessageReceivedEvent)evt);
                    continue;
                }
                if (!(evt instanceof ChatRoomMessageDeliveryFailedEvent)) continue;
                listener.messageDeliveryFailed((ChatRoomMessageDeliveryFailedEvent)evt);
            }
            catch (Throwable e) {
                logger.error((Object)("Error delivering multi chat message for " + listener), e);
            }
        }
    }

    public ConferenceDescription publishConference(ConferenceDescription cd, String name) {
        if (this.publishedConference != null) {
            cd = this.publishedConference;
            cd.setAvailable(false);
        } else {
            String displayName = name == null ? JabberActivator.getResources().getI18NString("service.gui.CHAT_CONFERENCE_ITEM_LABEL", new String[]{this.nickname}) : name;
            cd.setDisplayName(displayName);
        }
        ConferenceDescriptionPacketExtension ext = new ConferenceDescriptionPacketExtension(cd);
        if (this.lastPresenceSent == null) {
            logger.warn((Object)"Could not publish conference, lastPresenceSent is null.");
            this.publishedConference = null;
            this.publishedConferenceExt = null;
            return null;
        }
        ChatRoomJabberImpl.setPacketExtension((Packet)this.lastPresenceSent, ext, "http://jitsi.org/protocol/condesc");
        this.provider.getConnection().sendPacket((Packet)this.lastPresenceSent);
        this.publishedConference = cd == null || !cd.isAvailable() ? null : cd;
        this.publishedConferenceExt = this.publishedConference == null ? null : ext;
        this.fireConferencePublishedEvent((ChatRoomMember)this.members.get(this.nickname), cd, 0);
        return cd;
    }

    private static void setPacketExtension(Packet packet, PacketExtension extension, String namespace) {
        PacketExtension pe;
        if (StringUtils.isNullOrEmpty((String)namespace)) {
            return;
        }
        while (null != (pe = packet.getExtension(namespace))) {
            packet.removeExtension(pe);
        }
        if (extension != null) {
            packet.addExtension(extension);
        }
    }

    public void publishPresenceStatus(String newStatus) {
        if (this.lastPresenceSent != null) {
            this.lastPresenceSent.setStatus(newStatus);
            this.provider.getConnection().sendPacket((Packet)this.lastPresenceSent);
        }
    }

    public void sendPresenceExtension(PacketExtension extension) {
        if (this.lastPresenceSent != null) {
            ChatRoomJabberImpl.setPacketExtension((Packet)this.lastPresenceSent, extension, extension.getNamespace());
            this.provider.getConnection().sendPacket((Packet)this.lastPresenceSent);
        }
    }

    public List<String> getMembersWhiteList() {
        ArrayList<String> res = new ArrayList<String>();
        try {
            for (Affiliate a : this.multiUserChat.getMembers()) {
                res.add(a.getJid());
            }
        }
        catch (XMPPException e) {
            logger.error((Object)"Cannot obtain members list", (Throwable)e);
        }
        return res;
    }

    public void setMembersWhiteList(List<String> members) {
        try {
            List<String> membersToRemove = this.getMembersWhiteList();
            membersToRemove.removeAll(members);
            if (membersToRemove.size() > 0) {
                this.multiUserChat.revokeMembership(membersToRemove);
            }
            if (members.size() > 0) {
                this.multiUserChat.grantMembership(members);
            }
        }
        catch (XMPPException e) {
            logger.error((Object)"Cannot modify members list", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalUserRoleEvent(ChatRoomMemberRole previousRole, ChatRoomMemberRole newRole, boolean isInitial) {
        ArrayList<ChatRoomLocalUserRoleListener> listeners;
        ChatRoomLocalUserRoleChangeEvent evt = new ChatRoomLocalUserRoleChangeEvent((ChatRoom)this, previousRole, newRole, isInitial);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will dispatch the following ChatRoom event: " + evt));
        }
        Vector<ChatRoomLocalUserRoleListener> vector = this.localUserRoleListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomLocalUserRoleListener>(this.localUserRoleListeners);
        }
        for (ChatRoomLocalUserRoleListener listener : listeners) {
            listener.localUserRoleChanged(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangeEvent(PropertyChangeEvent evt) {
        ArrayList<ChatRoomPropertyChangeListener> listeners;
        Vector<ChatRoomPropertyChangeListener> vector = this.propertyChangeListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomPropertyChangeListener>(this.propertyChangeListeners);
        }
        for (ChatRoomPropertyChangeListener listener : listeners) {
            if (evt instanceof ChatRoomPropertyChangeEvent) {
                listener.chatRoomPropertyChanged((ChatRoomPropertyChangeEvent)evt);
                continue;
            }
            if (!(evt instanceof ChatRoomPropertyChangeFailedEvent)) continue;
            listener.chatRoomPropertyChangeFailed((ChatRoomPropertyChangeFailedEvent)evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireMemberPropertyChangeEvent(ChatRoomMemberPropertyChangeEvent evt) {
        ArrayList<ChatRoomMemberPropertyChangeListener> listeners;
        Vector<ChatRoomMemberPropertyChangeListener> vector = this.memberPropChangeListeners;
        synchronized (vector) {
            listeners = new ArrayList<ChatRoomMemberPropertyChangeListener>(this.memberPropChangeListeners);
        }
        for (ChatRoomMemberPropertyChangeListener listener : listeners) {
            listener.chatRoomPropertyChanged(evt);
        }
    }

    private void assertConnected() throws IllegalStateException {
        if (this.provider == null) {
            throw new IllegalStateException("The provider must be non-null and signed on the service before being able to communicate.");
        }
        if (!this.provider.isRegistered()) {
            throw new IllegalStateException("The provider must be signed on the service before being able to communicate.");
        }
    }

    public ChatRoomConfigurationForm getConfigurationForm() throws OperationFailedException {
        Form smackConfigForm = null;
        try {
            smackConfigForm = this.multiUserChat.getConfigurationForm();
            this.configForm = new ChatRoomConfigurationFormJabberImpl(this.multiUserChat, smackConfigForm);
        }
        catch (XMPPException e) {
            if (e.getXMPPError().getCode() == 403) {
                throw new OperationFailedException("Failed to obtain smack multi user chat config form.User doesn't have enough privileges to see the form.", 12, (Throwable)e);
            }
            throw new OperationFailedException("Failed to obtain smack multi user chat config form.", 1, (Throwable)e);
        }
        return this.configForm;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isPersistent() {
        boolean persistent = false;
        String roomName = this.multiUserChat.getRoom();
        try {
            DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor((Connection)this.provider.getConnection()).discoverInfo(roomName);
            if (info != null) {
                persistent = info.containsFeature("muc_persistent");
            }
        }
        catch (Exception ex) {
            logger.warn((Object)("could not get persistent state for room :" + roomName + "\n"), (Throwable)ex);
        }
        return persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChatRoomMemberJabberImpl findMemberForNickName(String jabberID) {
        Hashtable<String, ChatRoomMemberJabberImpl> hashtable = this.members;
        synchronized (hashtable) {
            return this.members.get(jabberID);
        }
    }

    public void grantAdmin(String jid) {
        try {
            this.multiUserChat.grantAdmin(jid);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs granting administrator privileges to a user.", (Throwable)ex);
        }
    }

    public void grantMembership(String jid) {
        try {
            this.multiUserChat.grantMembership(jid);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs granting membership to a user", (Throwable)ex);
        }
    }

    public void grantModerator(String nickname) {
        try {
            this.multiUserChat.grantModerator(nickname);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs granting moderator privileges to a user", (Throwable)ex);
        }
    }

    public void grantOwnership(String jid) {
        try {
            this.multiUserChat.grantOwnership(jid);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs granting ownership privileges to a user", (Throwable)ex);
        }
    }

    public void grantVoice(String nickname) {
        try {
            this.multiUserChat.grantVoice(nickname);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs granting voice to a visitor", (Throwable)ex);
        }
    }

    public void revokeAdmin(String jid) {
        try {
            this.multiUserChat.revokeAdmin(jid);
        }
        catch (XMPPException ex) {
            logger.error((Object)"n error occurs revoking administrator privileges to a user", (Throwable)ex);
        }
    }

    public void revokeMembership(String jid) {
        try {
            this.multiUserChat.revokeMembership(jid);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs revoking membership to a user", (Throwable)ex);
        }
    }

    public void revokeModerator(String nickname) {
        try {
            this.multiUserChat.revokeModerator(nickname);
        }
        catch (XMPPException ex) {
            logger.error((Object)"n error occurs revoking moderator privileges from a user", (Throwable)ex);
        }
    }

    public void revokeOwnership(String jid) {
        try {
            this.multiUserChat.revokeOwnership(jid);
        }
        catch (XMPPException ex) {
            logger.error((Object)"An error occurs revoking ownership privileges from a user", (Throwable)ex);
        }
    }

    public void revokeVoice(String nickname) {
        try {
            this.multiUserChat.revokeVoice(nickname);
        }
        catch (XMPPException ex) {
            logger.info((Object)"An error occurs revoking voice from a participant", (Throwable)ex);
        }
    }

    static String getNickName(String participantAddress) {
        if (participantAddress == null) {
            return null;
        }
        int atIndex = participantAddress.lastIndexOf("@");
        if (atIndex <= 0) {
            return participantAddress;
        }
        return participantAddress.substring(0, atIndex);
    }

    MultiUserChat getMultiUserChat() {
        return this.multiUserChat;
    }

    public void updatePrivateContactPresenceStatus(String nickname) {
        OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        ContactJabberImpl sourceContact = (ContactJabberImpl)presenceOpSet.findContactByID(this.getName() + "/" + nickname);
        this.updatePrivateContactPresenceStatus((Contact)sourceContact);
    }

    public void updatePrivateContactPresenceStatus(Contact contact) {
        OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)this.provider.getOperationSet(OperationSetPersistentPresence.class);
        if (contact == null) {
            return;
        }
        PresenceStatus oldContactStatus = contact.getPresenceStatus();
        String nickname = org.jivesoftware.smack.util.StringUtils.parseResource((String)contact.getAddress());
        boolean isOffline = !this.members.containsKey(nickname);
        JabberStatusEnum.JabberPresenceStatus offlineStatus = this.provider.getJabberStatusEnum().getStatus(isOffline ? "Offline" : "Available");
        ((ContactJabberImpl)contact).updatePresenceStatus((PresenceStatus)offlineStatus);
        presenceOpSet.fireContactPresenceStatusChangeEvent(contact, contact.getParentContactGroup(), oldContactStatus, (PresenceStatus)offlineStatus);
    }

    private class PresenceInterceptor
    implements PacketInterceptor {
        private PresenceInterceptor() {
        }

        public void interceptPacket(Packet packet) {
            if (packet instanceof Presence) {
                ChatRoomJabberImpl.setPacketExtension(packet, ChatRoomJabberImpl.this.publishedConferenceExt, "http://jitsi.org/protocol/condesc");
                ChatRoomJabberImpl.this.lastPresenceSent = (Presence)packet;
            }
        }
    }

    private class InvitationRejectionListeners
    implements PacketListener {
        private InvitationRejectionListeners() {
        }

        public void processPacket(Packet packet) {
            MUCUser mucUser = ChatRoomJabberImpl.this.getMUCUserExtension(packet);
            if (mucUser != null && mucUser.getDecline() != null && ((Message)packet).getType() != Message.Type.error) {
                Contact c;
                int messageReceivedEventType = 3;
                ChatRoomMemberJabberImpl member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, ChatRoomJabberImpl.this.getName(), ChatRoomJabberImpl.this.getName());
                String from = mucUser.getDecline().getFrom();
                OperationSetPersistentPresenceJabberImpl presenceOpSet = (OperationSetPersistentPresenceJabberImpl)ChatRoomJabberImpl.this.provider.getOperationSet(OperationSetPersistentPresence.class);
                if (presenceOpSet != null && (c = presenceOpSet.findContactByID(org.jivesoftware.smack.util.StringUtils.parseBareAddress((String)from))) != null && !from.contains(c.getDisplayName())) {
                    from = c.getDisplayName() + " (" + from + ")";
                }
                String msgBody = JabberActivator.getResources().getI18NString("service.gui.INVITATION_REJECTED", new String[]{from, mucUser.getDecline().getReason()});
                ChatRoomMessageReceivedEvent msgReceivedEvt = new ChatRoomMessageReceivedEvent((ChatRoom)ChatRoomJabberImpl.this, (ChatRoomMember)member, new Date(), ChatRoomJabberImpl.this.createMessage(msgBody), messageReceivedEventType);
                ChatRoomJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
            }
        }
    }

    private class PresenceListener
    implements PacketListener {
        private ChatRoom chatRoom;

        public PresenceListener(ChatRoom chatRoom) {
            this.chatRoom = chatRoom;
        }

        public void processPacket(Packet packet) {
            if (packet == null || !(packet instanceof Presence) || packet.getError() != null) {
                logger.warn((Object)("Unable to handle packet: " + packet));
                return;
            }
            Presence presence = (Presence)packet;
            String ourOccupantJid = ChatRoomJabberImpl.this.multiUserChat.getRoom() + "/" + ChatRoomJabberImpl.this.multiUserChat.getNickname();
            if (ourOccupantJid.equals(presence.getFrom())) {
                this.processOwnPresence(presence);
            } else {
                this.processOtherPresence(presence);
            }
        }

        private void processOwnPresence(Presence presence) {
            MUCUser mucUser = ChatRoomJabberImpl.this.getMUCUserExtension((Packet)presence);
            if (mucUser != null) {
                String affiliation = mucUser.getItem().getAffiliation();
                String role = mucUser.getItem().getRole();
                if (mucUser.getStatus() != null && "201".equals(mucUser.getStatus().getCode())) {
                    try {
                        ChatRoomJabberImpl.this.multiUserChat.sendConfigurationForm(new Form("submit"));
                    }
                    catch (XMPPException e) {
                        logger.error((Object)"Failed to send config form.", (Throwable)e);
                    }
                    ChatRoomJabberImpl.this.opSetMuc.addSmackInvitationRejectionListener(ChatRoomJabberImpl.this.multiUserChat, this.chatRoom);
                    if (affiliation.equalsIgnoreCase(ChatRoomMemberRole.OWNER.getRoleName().toLowerCase())) {
                        ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.OWNER, true);
                    } else {
                        ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MODERATOR, true);
                    }
                } else {
                    ChatRoomMemberRole jitsiRole = ChatRoomJabberImpl.smackRoleToScRole(role, affiliation);
                    if (jitsiRole == ChatRoomMemberRole.MODERATOR || jitsiRole == ChatRoomMemberRole.OWNER || jitsiRole == ChatRoomMemberRole.ADMINISTRATOR) {
                        ChatRoomJabberImpl.this.setLocalUserRole(jitsiRole, true);
                    }
                    if (!presence.isAvailable() && "none".equalsIgnoreCase(affiliation) && "none".equalsIgnoreCase(role)) {
                        MUCUser.Destroy destroy = mucUser.getDestroy();
                        if (destroy == null) {
                            ChatRoomJabberImpl.this.leave();
                        } else {
                            ChatRoomJabberImpl.this.leave(destroy.getReason(), destroy.getJid());
                        }
                    }
                }
            }
        }

        private void processOtherPresence(Presence presence) {
            PacketExtension ext = presence.getExtension("http://jitsi.org/protocol/condesc");
            if (presence.isAvailable() && ext != null) {
                ConferenceDescriptionPacketExtension cdExt = (ConferenceDescriptionPacketExtension)ext;
                ConferenceDescription cd = cdExt.toConferenceDescription();
                String from = presence.getFrom();
                String participantName = null;
                if (from != null) {
                    participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)from);
                }
                ChatRoomMember member = (ChatRoomMember)ChatRoomJabberImpl.this.members.get(participantName);
                if (!ChatRoomJabberImpl.this.processConferenceDescription(cd, participantName)) {
                    return;
                }
                if (member != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Received " + cd + " from " + participantName + "in " + ChatRoomJabberImpl.this.multiUserChat.getRoom()));
                    }
                    ChatRoomJabberImpl.this.fireConferencePublishedEvent(member, cd, 1);
                } else {
                    logger.warn((Object)("Received a ConferenceDescription from an unknown member (" + participantName + ") in " + ChatRoomJabberImpl.this.multiUserChat.getRoom()));
                }
            }
        }
    }

    private class UserListener
    implements UserStatusListener {
        private UserListener() {
        }

        public void kicked(String actor, String reason) {
            ChatRoomJabberImpl.this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)ChatRoomJabberImpl.this, "LocalUserKicked", reason);
            ChatRoomJabberImpl.this.leave();
        }

        public void voiceGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void voiceRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.SILENT_MEMBER);
        }

        public void banned(String actor, String reason) {
            ChatRoomJabberImpl.this.opSetMuc.fireLocalUserPresenceEvent((ChatRoom)ChatRoomJabberImpl.this, "LocalUserDropped", reason);
            ChatRoomJabberImpl.this.leave();
        }

        public void membershipGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void membershipRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.GUEST);
        }

        public void moderatorGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MODERATOR);
        }

        public void moderatorRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void ownershipGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.OWNER);
        }

        public void ownershipRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }

        public void adminGranted() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.ADMINISTRATOR);
        }

        public void adminRevoked() {
            ChatRoomJabberImpl.this.setLocalUserRole(ChatRoomMemberRole.MEMBER);
        }
    }

    private class SmackSubjectUpdatedListener
    implements SubjectUpdatedListener {
        private SmackSubjectUpdatedListener() {
        }

        public void subjectUpdated(String subject, String from) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Subject updated to " + subject));
            }
            if (subject != null && !subject.equals(ChatRoomJabberImpl.this.oldSubject)) {
                ChatRoomPropertyChangeEvent evt = new ChatRoomPropertyChangeEvent((ChatRoom)ChatRoomJabberImpl.this, "ChatRoomSubject", (Object)ChatRoomJabberImpl.this.oldSubject, (Object)subject);
                ChatRoomJabberImpl.this.firePropertyChangeEvent((PropertyChangeEvent)evt);
            }
            ChatRoomJabberImpl.this.oldSubject = subject;
        }
    }

    private class SmackMessageListener
    implements PacketListener {
        private Date lastSeenDelayedMessage = null;
        private static final String LAST_SEEN_DELAYED_MESSAGE_PROP = "lastSeenDelayedMessage";

        private SmackMessageListener() {
        }

        public void processPacket(Packet packet) {
            Date timeStamp;
            if (!(packet instanceof Message)) {
                return;
            }
            Message msg = (Message)packet;
            DelayInformation delay = (DelayInformation)msg.getExtension("x", "jabber:x:delay");
            if (delay != null) {
                timeStamp = delay.getStamp();
                if (this.lastSeenDelayedMessage == null) {
                    String timestamp = ConfigurationUtils.getChatRoomProperty((ProtocolProviderService)ChatRoomJabberImpl.this.provider, (String)ChatRoomJabberImpl.this.getIdentifier(), (String)LAST_SEEN_DELAYED_MESSAGE_PROP);
                    try {
                        this.lastSeenDelayedMessage = new Date(Long.parseLong(timestamp));
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (this.lastSeenDelayedMessage != null && !timeStamp.after(this.lastSeenDelayedMessage)) {
                    return;
                }
                ConfigurationUtils.updateChatRoomProperty((ProtocolProviderService)ChatRoomJabberImpl.this.provider, (String)ChatRoomJabberImpl.this.getIdentifier(), (String)LAST_SEEN_DELAYED_MESSAGE_PROP, (String)String.valueOf(timeStamp.getTime()));
                this.lastSeenDelayedMessage = timeStamp;
            } else {
                timeStamp = new Date();
            }
            String msgBody = msg.getBody();
            if (msgBody == null) {
                return;
            }
            int messageReceivedEventType = 1;
            String msgFrom = msg.getFrom();
            ChatRoomMemberJabberImpl member = null;
            String fromUserName = org.jivesoftware.smack.util.StringUtils.parseResource((String)msgFrom);
            if (msgFrom.equals(ChatRoomJabberImpl.this.getName())) {
                messageReceivedEventType = 3;
                member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, ChatRoomJabberImpl.this.getName(), ChatRoomJabberImpl.this.getName());
            } else {
                member = ChatRoomJabberImpl.this.smackParticipantToScMember(msgFrom);
            }
            if (member == null) {
                member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, fromUserName, msgFrom);
            }
            if (logger.isDebugEnabled() && logger.isDebugEnabled()) {
                logger.debug((Object)("Received from " + fromUserName + " the message " + msg.toXML()));
            }
            net.java.sip.communicator.service.protocol.Message newMessage = ChatRoomJabberImpl.this.createMessage(msgBody);
            if (ChatRoomJabberImpl.this.getUserNickname().equals(fromUserName)) {
                ChatRoomMessageDeliveredEvent msgDeliveredEvt = new ChatRoomMessageDeliveredEvent((ChatRoom)ChatRoomJabberImpl.this, timeStamp, newMessage, 1);
                if (delay != null) {
                    msgDeliveredEvt.setHistoryMessage(true);
                }
                ChatRoomJabberImpl.this.fireMessageEvent((EventObject)msgDeliveredEvt);
                return;
            }
            if (msg.getType() == Message.Type.error) {
                MessageEvent msgEvent;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Message error received from " + fromUserName));
                }
                XMPPError error = packet.getError();
                int errorCode = error.getCode();
                int errorResultCode = 1;
                String errorReason = error.getMessage();
                if (errorCode == 503 && (msgEvent = (MessageEvent)packet.getExtension("x", "jabber:x:event")) != null && msgEvent.isOffline()) {
                    errorResultCode = 5;
                }
                ChatRoomMessageDeliveryFailedEvent evt = new ChatRoomMessageDeliveryFailedEvent((ChatRoom)ChatRoomJabberImpl.this, (ChatRoomMember)member, errorResultCode, errorReason, new Date(), newMessage);
                ChatRoomJabberImpl.this.fireMessageEvent((EventObject)evt);
                return;
            }
            ChatRoomMessageReceivedEvent msgReceivedEvt = new ChatRoomMessageReceivedEvent((ChatRoom)ChatRoomJabberImpl.this, (ChatRoomMember)member, timeStamp, newMessage, messageReceivedEventType);
            if (delay != null) {
                msgReceivedEvt.setHistoryMessage(true);
            }
            if (messageReceivedEventType == 1 && newMessage.getContent().contains(ChatRoomJabberImpl.this.getUserNickname() + ":")) {
                msgReceivedEvt.setImportantMessage(true);
            }
            ChatRoomJabberImpl.this.fireMessageEvent((EventObject)msgReceivedEvt);
        }
    }

    private class MemberListener
    implements ParticipantStatusListener {
        private MemberListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void banned(String participant, String actor, String reason) {
            ChatRoomMemberJabberImpl member;
            if (logger.isInfoEnabled()) {
                logger.info((Object)(participant + " has been banned from " + ChatRoomJabberImpl.this.getName() + " chat room."));
            }
            if ((member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant)) == null) {
                return;
            }
            String participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)participant);
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomJabberImpl.this.members.remove(participantName);
            }
            ChatRoomJabberImpl.this.banList.put(participant, member);
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.OUTCAST);
        }

        public void adminGranted(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.ADMINISTRATOR);
        }

        public void adminRevoked(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void joined(String participant) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(participant + " has joined the " + ChatRoomJabberImpl.this.getName() + " chat room."));
            }
            String participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)participant);
            if (ChatRoomJabberImpl.this.nickname.equals(participantName) || ChatRoomJabberImpl.this.members.containsKey(participantName)) {
                return;
            }
            if (ChatRoomJabberImpl.this.members.contains(participantName)) {
                return;
            }
            Occupant occupant = ChatRoomJabberImpl.this.multiUserChat.getOccupant(participant);
            ChatRoomMemberJabberImpl member = new ChatRoomMemberJabberImpl(ChatRoomJabberImpl.this, StringEscapeUtils.unescapeXml((String)occupant.getNick()), occupant.getJid());
            ChatRoomJabberImpl.this.members.put(participantName, member);
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, "MemberJoined", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void left(String participant) {
            ChatRoomMemberJabberImpl member;
            if (logger.isInfoEnabled()) {
                logger.info((Object)(participant + " has left the " + ChatRoomJabberImpl.this.getName() + " chat room."));
            }
            if ((member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant)) == null) {
                return;
            }
            String participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)participant);
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomJabberImpl.this.members.remove(participantName);
            }
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, "MemberLeft", null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nicknameChanged(String participant, String newNickname) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            if (ChatRoomJabberImpl.this.nickname.equals(ChatRoomJabberImpl.getNickName(member.getName()))) {
                ChatRoomJabberImpl.this.nickname = ChatRoomJabberImpl.getNickName(newNickname);
            }
            member.setName(newNickname);
            String participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)participant);
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomMemberJabberImpl mem = (ChatRoomMemberJabberImpl)ChatRoomJabberImpl.this.members.remove(participantName);
                ChatRoomJabberImpl.this.members.put(newNickname, mem);
            }
            ChatRoomMemberPropertyChangeEvent evt = new ChatRoomMemberPropertyChangeEvent((ChatRoomMember)member, (ChatRoom)ChatRoomJabberImpl.this, "MemberNickname", (Object)participantName, (Object)newNickname);
            ChatRoomJabberImpl.this.fireMemberPropertyChangeEvent(evt);
        }

        public void ownershipRevoked(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void kicked(String participant, String actor, String reason) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            ChatRoomMemberJabberImpl actorMember = ChatRoomJabberImpl.this.smackParticipantToScMember(actor);
            if (member == null) {
                return;
            }
            String participantName = org.jivesoftware.smack.util.StringUtils.parseResource((String)participant);
            Hashtable hashtable = ChatRoomJabberImpl.this.members;
            synchronized (hashtable) {
                ChatRoomJabberImpl.this.members.remove(participantName);
            }
            ChatRoomJabberImpl.this.fireMemberPresenceEvent((ChatRoomMember)member, (ChatRoomMember)actorMember, "MemberKicked", reason);
        }

        public void moderatorGranted(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MODERATOR);
        }

        public void voiceRevoked(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.SILENT_MEMBER);
        }

        public void membershipGranted(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void moderatorRevoked(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void voiceGranted(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.MEMBER);
        }

        public void membershipRevoked(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.GUEST);
        }

        public void ownershipGranted(String participant) {
            ChatRoomMemberJabberImpl member = ChatRoomJabberImpl.this.smackParticipantToScMember(participant);
            if (member == null) {
                return;
            }
            ChatRoomJabberImpl.this.fireMemberRoleEvent((ChatRoomMember)member, member.getCurrentRole(), ChatRoomMemberRole.OWNER);
        }
    }
}

