/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import net.sf.cindy.Dispatcher;
import net.sf.cindy.EventGenerator;
import net.sf.cindy.Message;
import net.sf.cindy.MessageRecognizer;
import net.sf.cindy.SessionListener;
import net.sf.cindy.SessionStatistic;
import net.sf.cindy.impl.AutoCloseEventGenerator;
import net.sf.cindy.impl.ByteArrayMessageRecognizer;
import net.sf.cindy.impl.Constants;
import net.sf.cindy.impl.SimpleDispatcher;
import net.sf.cindy.impl.SimpleSessionStatistic;
import net.sf.cindy.spi.DispatcherSpi;
import net.sf.cindy.spi.EventGeneratorSpi;
import net.sf.cindy.spi.SessionSpi;
import net.sf.cindy.spi.SessionStatisticSpi;
import net.sf.cindy.util.ByteBufferUtils;
import net.sf.cindy.util.CopyOnWriteCollection;
import net.sf.cindy.util.queue.Queue;
import net.sf.cindy.util.queue.QueueFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractSession
implements SessionSpi {
    private static final Log log = LogFactory.getLog((Class)AbstractSession.class);
    public static final EventGenerator DEFAULT_EVENT_GENERATOR = new AutoCloseEventGenerator();
    private static int sessionId;
    private final int id = sessionId++;
    protected ByteBuffer readBuffer = ByteBufferUtils.allocate(Constants.BUFFER_CAPACITY, Constants.USE_DIRECT_BUFFER);
    protected final Queue writeQueue = QueueFactory.createQueue();
    private SessionStatisticSpi statistic = new SimpleSessionStatistic(this);
    private EventGeneratorSpi eventGenerator = (EventGeneratorSpi)DEFAULT_EVENT_GENERATOR;
    private DispatcherSpi dispatcher = new SimpleDispatcher();
    private MessageRecognizer messageRecognizer = new ByteArrayMessageRecognizer();
    private Object attachment;
    private boolean enableStatistic = false;
    private final Collection sessionListeners = new CopyOnWriteCollection();
    private int sessionTimeout = Constants.SESSION_TIMEOUT;
    private boolean logException = Constants.LOG_EXCEPTION;
    private int bufferCapacityLimit = Constants.BUFFER_CAPACITY_LIMIT;

    public final int getId() {
        return this.id;
    }

    public final boolean getEnableStatistic() {
        return this.enableStatistic;
    }

    public final void setEnableStatistic(boolean bl) {
        this.enableStatistic = bl;
    }

    public final SessionStatistic getStatistic() {
        if (this.enableStatistic) {
            return this.statistic;
        }
        return null;
    }

    public final void setStatistic(SessionStatistic sessionStatistic) {
        if (sessionStatistic != null) {
            if (!(sessionStatistic instanceof SessionStatisticSpi)) {
                throw new IllegalArgumentException("session statistic must implement SessionStatisticSpi interface");
            }
            if (this.isStarted()) {
                throw new IllegalStateException("can't set session statistic when session have already started");
            }
            this.statistic = (SessionStatisticSpi)sessionStatistic;
        }
    }

    public final EventGenerator getEventGenerator() {
        return this.eventGenerator;
    }

    public final void setEventGenerator(EventGenerator eventGenerator) {
        if (eventGenerator != null) {
            if (!(eventGenerator instanceof EventGeneratorSpi)) {
                throw new IllegalArgumentException("event generator must implement EventGeneratorSpi interface");
            }
            if (this.isStarted()) {
                throw new IllegalStateException("can't set event generator when session have already started");
            }
            this.eventGenerator = (EventGeneratorSpi)eventGenerator;
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        if (dispatcher != null) {
            if (!(dispatcher instanceof DispatcherSpi)) {
                throw new IllegalArgumentException("dispatcher must implement DispatcherSpi interface");
            }
            this.dispatcher = (DispatcherSpi)dispatcher;
        }
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final Object getAttachment() {
        return this.attachment;
    }

    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    public final int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public final void setSessionTimeout(int n) {
        if (n < 0) {
            n = 0;
        }
        this.sessionTimeout = n;
    }

    public final MessageRecognizer getMessageRecognizer() {
        return this.messageRecognizer;
    }

    public final void setMessageRecognizer(MessageRecognizer messageRecognizer) {
        if (messageRecognizer != null) {
            this.messageRecognizer = messageRecognizer;
        }
    }

    public final boolean isLogException() {
        return this.logException;
    }

    public final void setLogException(boolean bl) {
        this.logException = bl;
    }

    public final int getBufferCapacityLimit() {
        return this.bufferCapacityLimit;
    }

    public final void setBufferCapacityLimit(int n) {
        if (n > this.readBuffer.capacity()) {
            this.bufferCapacityLimit = n;
        }
    }

    public final void addSessionListener(SessionListener sessionListener) {
        if (sessionListener != null) {
            this.sessionListeners.add(sessionListener);
        }
    }

    public final void removeSessionListener(SessionListener sessionListener) {
        if (sessionListener != null) {
            this.sessionListeners.remove(sessionListener);
        }
    }

    public final void start() throws IllegalStateException {
        this.start(false);
    }

    public final void close() {
        this.close(false);
    }

    public final boolean isAvailable() {
        return this.isStarted() && !this.isClosing();
    }

    public int getWriteQueueSize() {
        return this.writeQueue.size();
    }

    public void onEvent(Object object, Object object2) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("session " + this.getId() + " on event: [Event] " + object + " [Attachment] " + object2));
        }
    }

    protected final Iterator getSessionListeners() {
        return this.sessionListeners.iterator();
    }

    private void dispatch(Runnable runnable) {
        this.dispatcher.dispatch(this, runnable);
    }

    public void dispatchException(final Throwable throwable) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " caught exception " + throwable));
        }
        if (this.isLogException()) {
            log.error((Object)throwable, throwable);
        }
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.exceptionCaught(AbstractSession.this, throwable);
                }
            }
        });
    }

    protected void dispatchSessionEstablished() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " established"));
        }
        this.statistic.start();
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.sessionEstablished(AbstractSession.this);
                }
            }
        });
    }

    protected void dispatchSessionClosed() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " closed"));
        }
        this.statistic.stop();
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.sessionClosed(AbstractSession.this);
                }
            }
        });
    }

    protected void dispatchSessionIdle() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " idle"));
        }
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.sessionIdle(AbstractSession.this);
                }
            }
        });
    }

    protected void dispatchSessionTimeout() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " timeout"));
        }
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.sessionTimeout(AbstractSession.this);
                }
            }
        });
    }

    protected void dispatchMessageReceived(final Message message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " received message " + message));
        }
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.messageReceived(AbstractSession.this, message);
                }
            }
        });
    }

    protected void dispatchMessageSent(final Message message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("session " + sessionId + " sent message " + message));
        }
        this.dispatch(new DispatchObject(){

            protected void doRun() throws Exception {
                Iterator iterator = AbstractSession.this.sessionListeners.iterator();
                while (iterator.hasNext()) {
                    SessionListener sessionListener = (SessionListener)iterator.next();
                    sessionListener.messageSent(AbstractSession.this, message);
                }
            }
        });
    }

    protected Message recognizeMessage(ByteBuffer byteBuffer) {
        try {
            Message message;
            if (log.isTraceEnabled()) {
                log.trace((Object)("session " + sessionId + " recognize message"));
            }
            if ((message = this.messageRecognizer.recognize(this, byteBuffer.asReadOnlyBuffer())) != null) {
                boolean bl = message.readFromBuffer(byteBuffer);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("session " + sessionId + " recognized message " + message.getClass().getName() + (bl ? " " : " not ") + "completed"));
                }
                if (bl) {
                    return message;
                }
            }
        }
        catch (Exception exception) {
            this.dispatchException(exception);
        }
        return null;
    }

    protected static class WriteLock {
        private boolean success;

        protected WriteLock() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean bl) {
            this.success = bl;
        }
    }

    private abstract class DispatchObject
    implements Runnable {
        private DispatchObject() {
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Exception exception) {
                AbstractSession.this.dispatchException(exception);
            }
        }

        protected abstract void doRun() throws Exception;
    }
}

