/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.dim;

import java.util.logging.Logger;
import net.kano.joscar.rv.RvSession;
import net.kano.joscar.rvcmd.ConnectionRequestRvCmd;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.RendezvousSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.AttachmentSaver;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimConnection;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimController;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimRequestMaker;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.DirectimTools;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.MutableSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.dim.SizeBasedAttachmentSaver;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.AbstractIncomingRvSessionHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.IncomingRvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.NextStateControllerInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionState;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvSessionConnectionInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.ConnectedController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.StateController;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.ConnectionCompleteEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.events.RvConnectionEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StateInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.state.StreamInfo;
import net.kano.joustsim.oscar.proxy.AimProxyInfo;
import org.jetbrains.annotations.Nullable;

public class IncomingDirectimConnectionImpl
extends IncomingRvConnectionImpl
implements DirectimConnection {
    private static final Logger LOGGER = Logger.getLogger(IncomingDirectimConnectionImpl.class.getName());
    private AttachmentSaver attachmentSaver = new SizeBasedAttachmentSaver();

    public IncomingDirectimConnectionImpl(AimProxyInfo proxy, Screenname screenname, RvSessionConnectionInfo rvsessioninfo) {
        super(proxy, screenname, rvsessioninfo);
    }

    public IncomingDirectimConnectionImpl(AimProxyInfo proxy, Screenname screenname, RvSession session) {
        this(proxy, screenname, new MutableSessionConnectionInfo(session));
        DirectimRequestMaker requestMaker = new DirectimRequestMaker(this);
        ((MutableSessionConnectionInfo)this.getRvSessionInfo()).setMaker(requestMaker);
    }

    protected ConnectedController createConnectedController(StateInfo endState) {
        return new DirectimController();
    }

    protected boolean isConnectedController(StateController controller) {
        return controller instanceof DirectimController;
    }

    protected NextStateControllerInfo getNextControllerFromSuccess(StateController oldController, StateInfo oldStateInfo) {
        if (oldController instanceof DirectimController) {
            LOGGER.fine("Changing from success of receive controller to completed");
            return new NextStateControllerInfo(RvConnectionState.FINISHED, (RvConnectionEvent)new ConnectionCompleteEvent());
        }
        if (oldStateInfo instanceof StreamInfo) {
            throw new IllegalStateException("stream info?? for " + oldController + " - " + oldStateInfo);
        }
        throw new IllegalStateException("Trying to change from success state; unknown previous controller/state " + oldController + "/" + oldStateInfo);
    }

    protected NextStateControllerInfo getNextControllerFromUnknownError(StateController oldController, StateInfo oldState, RvConnectionEvent event) {
        if (oldController instanceof DirectimController) {
            return new NextStateControllerInfo(RvConnectionState.FAILED, event);
        }
        throw new IllegalStateException("Trying to change from error state; unknown previous controller/state " + oldController + "/" + oldState);
    }

    protected RendezvousSessionHandler createSessionHandler() {
        return new AbstractIncomingRvSessionHandler(this){

            protected void handleFirstRequest(ConnectionRequestRvCmd reqCmd) {
            }
        };
    }

    @Nullable
    public DirectimController getDirectimController() {
        return DirectimTools.getDirectimStateController(this);
    }

    public AttachmentSaver getAttachmentSaver() {
        return this.attachmentSaver;
    }

    public void setAttachmentSaver(AttachmentSaver attachmentSaver) {
        this.attachmentSaver = attachmentSaver;
    }
}

