/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;
import net.kano.joscar.snaccmd.icbm.RvCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public abstract class AbstractRvCmd
extends RvCommand {
    private static final int TYPE_SERVICE_DATA = 10001;
    private final ByteBlock serviceData;
    private final MutableTlvChain rvTlvs;

    protected AbstractRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        ByteBlock block = icbm.getRvData();
        if (block != null) {
            ImmutableTlvChain chain = TlvTools.readChain(block);
            Tlv serviceDataTlv = chain.getLastTlv(10001);
            this.serviceData = serviceDataTlv == null ? null : serviceDataTlv.getData();
            MutableTlvChain extras = TlvTools.getMutableCopy(chain);
            extras.removeTlvs(new int[]{10001});
            this.rvTlvs = extras;
        } else {
            this.serviceData = null;
            this.rvTlvs = TlvTools.createMutableChain();
        }
    }

    protected AbstractRvCmd(int rvStatus, CapabilityBlock cap) {
        super(rvStatus, cap);
        this.serviceData = null;
        this.rvTlvs = null;
    }

    protected final ByteBlock getServiceData() {
        return this.serviceData;
    }

    protected final TlvChain getRvTlvs() {
        return this.rvTlvs;
    }

    final MutableTlvChain getMutableTlvs() {
        return this.rvTlvs;
    }

    public final void writeRvData(OutputStream out) throws IOException {
        DefensiveTools.checkNull((Object)out, (String)"out");
        this.writeHeaderRvTlvs(out);
        this.writeRvTlvs(out);
        if (this.hasServiceData()) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.writeServiceData(bout);
            ByteBlock serviceBlock = ByteBlock.wrap((byte[])bout.toByteArray());
            new Tlv(10001, (Writable)serviceBlock).write(out);
        }
    }

    protected abstract void writeHeaderRvTlvs(OutputStream var1) throws IOException;

    protected abstract void writeRvTlvs(OutputStream var1) throws IOException;

    protected boolean hasServiceData() {
        return true;
    }

    protected void writeServiceData(OutputStream out) throws IOException {
    }
}

