/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.protocol.outgoing;

import net.sf.jml.MsnClientId;
import net.sf.jml.MsnObject;
import net.sf.jml.MsnProtocol;
import net.sf.jml.MsnUserStatus;
import net.sf.jml.protocol.MsnOutgoingMessage;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringUtils;

public class OutgoingCHG
extends MsnOutgoingMessage {
    private boolean firstSend;
    private MsnObject msnObj;

    public OutgoingCHG(MsnProtocol msnProtocol) {
        super(msnProtocol);
        this.setCommand("CHG");
    }

    public boolean isFirstSend() {
        return this.firstSend;
    }

    public MsnObject getMsnObj() {
        return this.msnObj;
    }

    public void setFirstSend(boolean bl) {
        this.firstSend = bl;
    }

    public void setStatus(MsnUserStatus msnUserStatus) {
        if (msnUserStatus == null) {
            throw new NullPointerException();
        }
        if (msnUserStatus == MsnUserStatus.OFFLINE) {
            throw new IllegalArgumentException(msnUserStatus.toString());
        }
        this.setParam(0, msnUserStatus.getStatus());
    }

    public void setDisplayPicture(MsnObject msnObject) {
        if (msnObject == null) {
            return;
        }
        this.setParam(2, StringUtils.urlEncode(msnObject.toString()));
    }

    public void setClientId(MsnClientId msnClientId) {
        this.setParam(1, String.valueOf(msnClientId.getId()));
    }

    public MsnUserStatus getStatus() {
        return MsnUserStatus.parseStr(this.getParam(0));
    }

    public MsnClientId getClientId() {
        return MsnClientId.parseInt(NumberUtils.stringToInt(this.getParam(1)));
    }
}

