/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.LogWriter;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.message.Request;

public abstract class SIPMessageStack {
    protected LogWriter logWriter;
    protected ServerLog serverLog;
    protected boolean tcpFlag;
    protected boolean udpFlag;
    protected boolean tlsFlag;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String badMessageLog;
    protected boolean debugFlag;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected String savedStackAddress;
    protected InetAddress savedStackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    public static final int DEFAULT_PORT = 5060;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection messageProcessors = new ArrayList();
    protected String stunServerAddress;
    protected int stunServerPort;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public void logBadMessage(String message) {
        if (this.badMessageLog != null) {
            this.logWriter.logMessage(message, this.badMessageLog);
        }
    }

    public void logMessage(String message) {
        this.logWriter.logMessage(message);
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public ServerLog getServerLog() {
        return this.serverLog;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void logStackTrace() {
        this.logWriter.logStackTrace();
    }

    public String getBadMessageLog() {
        return this.badMessageLog;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public Iterator getNextHop(SIPRequest sipRequest) {
        return this.router.getNextHops((Request)sipRequest);
    }

    public SIPMessageStack(StackMessageFactory messageFactory, String stackAddress, String stackName) throws UnknownHostException {
        this();
        this.sipMessageFactory = messageFactory;
        if (stackAddress == null) {
            throw new UnknownHostException("stack Address not set");
        }
        this.stackInetAddress = InetAddress.getByName(stackAddress);
    }

    public void setStackMessageFactory(StackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public String getStackName() {
        return this.stackName;
    }

    protected void setHostAddress(String stackAddress) throws UnknownHostException {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
        this.stackInetAddress = InetAddress.getByName(stackAddress);
    }

    protected void setRealHostAddress(String stackAddress) throws UnknownHostException {
        this.savedStackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
        this.savedStackInetAddress = InetAddress.getByName(stackAddress);
    }

    protected InetAddress getRealIPAddress() {
        return this.savedStackInetAddress;
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    public Hop getNextHop() {
        return this.router.getOutboundProxy();
    }

    public int getPort(String transport) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator it = this.messageProcessors.iterator();
            while (it.hasNext()) {
                MessageProcessor mp = (MessageProcessor)it.next();
                if (!mp.getTransport().equalsIgnoreCase(transport)) continue;
                return mp.getPort();
            }
            throw new IllegalArgumentException("Transport not supported " + transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportEnabled(String transport) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator it = this.messageProcessors.iterator();
            while (it.hasNext()) {
                MessageProcessor mp = (MessageProcessor)it.next();
                if (!mp.getTransport().equalsIgnoreCase(transport)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransportEnabled(String transport, int port) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator it = this.messageProcessors.iterator();
            while (it.hasNext()) {
                MessageProcessor mp = (MessageProcessor)it.next();
                if (!mp.getTransport().equalsIgnoreCase(transport) || mp.getPort() != port) continue;
                return true;
            }
            return false;
        }
    }

    protected void reInit() {
        if (LogWriter.needsLogging) {
            this.logWriter.logMessage("Re-initializing !");
        }
        this.messageProcessors = new ArrayList();
        this.ioHandler = new IOHandler(this);
    }

    public SIPMessageStack() {
        this.ioHandler = new IOHandler(this);
        this.logWriter = new LogWriter();
        this.serverLog = new ServerLog(this);
    }

    protected void setDebugLogFileName(String logFileName) {
        this.logWriter.setLogFileName(logFileName);
    }

    protected ServerRequestInterface newSIPServerRequest(SIPRequest siprequest, MessageChannel msgchan) {
        return this.sipMessageFactory.newSIPServerRequest(siprequest, msgchan);
    }

    protected ServerResponseInterface newSIPServerResponse(SIPResponse sipresponse, MessageChannel msgchan) {
        return this.sipMessageFactory.newSIPServerResponse(sipresponse, msgchan);
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter() {
        return this.router;
    }

    public Hop getDefaultRoute() {
        return this.router.getOutboundProxy();
    }

    public Route getRouteHeader(Hop hop) {
        HostPort hostPort = new HostPort();
        Host h = new Host(hop.getHost());
        hostPort.setHost(h);
        hostPort.setPort(hop.getPort());
        SipUri uri = new SipUri();
        uri.setHostPort(hostPort);
        uri.setScheme("sip");
        try {
            uri.setTransportParam(hop.getTransport());
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        AddressImpl address = new AddressImpl();
        address.setURI(uri);
        Route route = new Route();
        route.setAddress(address);
        return route;
    }

    public Route getDefaultRouteHeader() {
        if (this.router.getOutboundProxy() != null) {
            Hop hop = this.router.getOutboundProxy();
            return this.getRouteHeader(hop);
        }
        return null;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        this.toExit = true;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.messageProcessors;
        synchronized (object) {
            MessageProcessor[] processorList = this.getMessageProcessors();
            for (int processorIndex = 0; processorIndex < processorList.length; ++processorIndex) {
                this.removeMessageProcessor(processorList[processorIndex]);
            }
            this.ioHandler.closeAll();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            newMessageProcessor.start();
            this.messageProcessors.add(newMessageProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            if (this.messageProcessors.remove(oldMessageProcessor)) {
                oldMessageProcessor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessor[] getMessageProcessors() {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            return this.messageProcessors.toArray(new MessageProcessor[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProcessor getMessageProcessor(String transport) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            Iterator it = this.messageProcessors.iterator();
            while (it.hasNext()) {
                MessageProcessor mp = (MessageProcessor)it.next();
                if (!mp.getTransport().equalsIgnoreCase(transport)) continue;
                return mp;
            }
            return null;
        }
    }

    public MessageProcessor createMessageProcessor(int port, String transport) throws IOException {
        if (transport.equalsIgnoreCase("udp")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(this, port);
            this.addMessageProcessor(udpMessageProcessor);
            this.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tcp")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(this, port);
            this.addMessageProcessor(tcpMessageProcessor);
            this.tcpFlag = true;
            return tcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tls")) {
            TLSMessageProcessor tlsMessageProcessor = new TLSMessageProcessor(this, port);
            this.addMessageProcessor(tlsMessageProcessor);
            this.tlsFlag = true;
            return tlsMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(StackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createMessageChannel(int sourcePort, Hop nextHop) throws UnknownHostException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Iterator processorIterator = this.messageProcessors.iterator();
        while (processorIterator.hasNext() && newChannel == null) {
            MessageProcessor nextProcessor = (MessageProcessor)processorIterator.next();
            if (!nextHop.getTransport().equalsIgnoreCase(nextProcessor.getTransport()) || sourcePort != nextProcessor.getPort()) continue;
            try {
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (UnknownHostException ex) {
                if (LogWriter.needsLogging) {
                    this.logWriter.logException(ex);
                }
                throw ex;
            }
            catch (IOException e) {
                if (!LogWriter.needsLogging) continue;
                this.logWriter.logException(e);
            }
        }
        return newChannel;
    }
}

