/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.logging.Logger;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.MiscTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationEventInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationException;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationListener;
import net.kano.joustsim.oscar.oscar.service.icbm.ConversationNotOpenException;
import net.kano.joustsim.oscar.oscar.service.icbm.Message;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.MessageSentEvent;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingInfo;
import net.kano.joustsim.oscar.oscar.service.icbm.TypingListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Conversation {
    private static final Logger LOGGER = Logger.getLogger(Conversation.class.getName());
    private final Screenname buddy;
    private final CopyOnWriteArrayList<ConversationListener> listeners = new CopyOnWriteArrayList();
    private boolean open = false;
    private boolean closed = false;

    public Conversation(Screenname buddy) {
        this.buddy = buddy;
    }

    public void addConversationListener(ConversationListener l) {
        DefensiveTools.checkNull((Object)l, (String)"l");
        this.listeners.addIfAbsent((Object)l);
    }

    public void removeConversationListener(ConversationListener l) {
        this.listeners.remove((Object)l);
    }

    public final Screenname getBuddy() {
        return this.buddy;
    }

    protected void initialize() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setAlwaysOpen() {
        Conversation conversation = this;
        synchronized (conversation) {
            if (this.open || this.closed) {
                return false;
            }
            this.open = true;
        }
        this.opened();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        Conversation conversation = this;
        synchronized (conversation) {
            if (this.open || this.closed) {
                return false;
            }
            this.open = true;
        }
        this.fireOpenEvent();
        this.opened();
        return true;
    }

    private void fireOpenEvent() {
        assert (!Thread.holdsLock(this));
        for (ConversationListener l : this.listeners) {
            l.conversationOpened(this);
        }
    }

    public boolean close() {
        if (!this.closeWithoutEvents()) {
            return false;
        }
        this.finishClosing();
        return true;
    }

    private void finishClosing() {
        this.fireClosedEvent();
        this.closed();
    }

    private synchronized boolean closeWithoutEvents() {
        if (this.closed) {
            return false;
        }
        this.closed = true;
        return true;
    }

    private void fireClosedEvent() {
        assert (!Thread.holdsLock(this));
        for (ConversationListener l : this.listeners) {
            l.conversationClosed(this);
        }
    }

    protected void opened() {
    }

    protected void closed() {
    }

    public synchronized boolean isOpen() {
        return this.open;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    protected void fireIncomingEvent(ConversationEventInfo event) {
        assert (!Thread.holdsLock(this));
        DefensiveTools.checkNull((Object)event, (String)"event");
        LOGGER.fine(MiscTools.getClassName((Object)this) + ": firing incoming " + "event: " + event);
        if (event instanceof MessageInfo) {
            MessageInfo messageInfo = (MessageInfo)event;
            for (ConversationListener l : this.listeners) {
                l.gotMessage(this, messageInfo);
            }
        } else {
            for (ConversationListener l : this.listeners) {
                l.gotOtherEvent(this, event);
            }
        }
    }

    protected void fireOutgoingEvent(ConversationEventInfo event) {
        assert (!Thread.holdsLock(this));
        DefensiveTools.checkNull((Object)event, (String)"event");
        LOGGER.fine(MiscTools.getClassName((Object)this) + ": firing outgoing " + "event: " + event);
        if (event instanceof MessageInfo) {
            MessageInfo messageInfo = (MessageInfo)event;
            for (ConversationListener l : this.listeners) {
                l.sentMessage(this, messageInfo);
            }
        } else {
            for (ConversationListener l : this.listeners) {
                l.sentOtherEvent(this, event);
            }
        }
    }

    protected void fireCanSendChangedEvent(boolean canSend) {
        assert (!Thread.holdsLock(this));
        for (ConversationListener listener : this.listeners) {
            listener.canSendMessageChanged(this, canSend);
        }
    }

    protected synchronized void checkOpen() throws ConversationNotOpenException {
        if (!this.open) {
            throw new ConversationNotOpenException(this);
        }
    }

    public boolean canSendMessage() {
        return true;
    }

    public abstract void sendMessage(Message var1) throws ConversationException;

    protected CopyOnWriteArrayList<ConversationListener> getListeners() {
        return this.listeners;
    }

    protected void handleIncomingEvent(ConversationEventInfo event) {
        this.fireIncomingEvent(event);
        if (event instanceof TypingInfo) {
            TypingInfo typingInfo = (TypingInfo)event;
            for (ConversationListener listener : this.getListeners()) {
                if (!(listener instanceof TypingListener)) continue;
                ((TypingListener)listener).gotTypingState(this, typingInfo);
            }
        }
    }

    protected void fireMessageSentEvent(Message msg, Screenname mysn) {
        MessageSentEvent event = new MessageSentEvent(msg, mysn, this.getBuddy());
        for (ConversationListener l : this.getListeners()) {
            l.gotOtherEvent(this, event);
        }
    }
}

