/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.impl.operationservice.impl.Invocation;

final class PartitionInvocation
extends Invocation {
    final boolean failOnIndeterminateOperationState;

    PartitionInvocation(Invocation.Context context, Operation op, Runnable doneCallback, int tryCount, long tryPauseMillis, long callTimeoutMillis, boolean deserialize, boolean failOnIndeterminateOperationState) {
        super(context, op, doneCallback, tryCount, tryPauseMillis, callTimeoutMillis, deserialize);
        this.failOnIndeterminateOperationState = failOnIndeterminateOperationState && !(op instanceof ReadonlyOperation);
    }

    PartitionInvocation(Invocation.Context context, Operation op, int tryCount, long tryPauseMillis, long callTimeoutMillis, boolean deserialize, boolean failOnIndeterminateOperationState) {
        this(context, op, null, tryCount, tryPauseMillis, callTimeoutMillis, deserialize, failOnIndeterminateOperationState);
    }

    @Override
    public Address getTarget() {
        InternalPartition partition = this.context.partitionService.getPartition(this.op.getPartitionId());
        return partition.getReplicaAddress(this.op.getReplicaIndex());
    }

    @Override
    protected boolean shouldFailOnIndeterminateOperationState() {
        return this.failOnIndeterminateOperationState;
    }

    @Override
    ExceptionAction onException(Throwable t) {
        if (this.shouldFailOnIndeterminateOperationState() && t instanceof MemberLeftException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        ExceptionAction action = this.op.onInvocationException(t);
        return action != null ? action : ExceptionAction.THROW_EXCEPTION;
    }
}

