/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.xml.relax.dom;

import jp.gr.xml.relax.dom.DOMVisitorException;
import jp.gr.xml.relax.dom.IDOMVisitor;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class UDOMVisitor {
    public static void traverse(Node node, IDOMVisitor visitor) throws DOMVisitorException {
        boolean doContinue;
        switch (node.getNodeType()) {
            case 1: {
                doContinue = visitor.enter((Element)node);
                break;
            }
            case 2: {
                doContinue = visitor.enter((Attr)node);
                break;
            }
            case 3: {
                doContinue = visitor.enter((Text)node);
                break;
            }
            case 4: {
                doContinue = visitor.enter((CDATASection)node);
                break;
            }
            case 5: {
                doContinue = visitor.enter((EntityReference)node);
                break;
            }
            case 6: {
                doContinue = visitor.enter((Entity)node);
                break;
            }
            case 7: {
                doContinue = visitor.enter((ProcessingInstruction)node);
                break;
            }
            case 8: {
                doContinue = visitor.enter((Comment)node);
                break;
            }
            case 9: {
                doContinue = visitor.enter((Document)node);
                break;
            }
            case 10: {
                doContinue = visitor.enter((DocumentType)node);
                break;
            }
            case 11: {
                doContinue = visitor.enter((DocumentFragment)node);
                break;
            }
            case 12: {
                doContinue = visitor.enter((Notation)node);
                break;
            }
            default: {
                doContinue = visitor.enter(node);
            }
        }
        if (doContinue) {
            UDOMVisitor.traverseChildren(node, visitor);
            switch (node.getNodeType()) {
                case 1: {
                    visitor.leave((Element)node);
                    break;
                }
                case 2: {
                    visitor.leave((Attr)node);
                    break;
                }
                case 3: {
                    visitor.leave((Text)node);
                    break;
                }
                case 4: {
                    visitor.leave((CDATASection)node);
                    break;
                }
                case 5: {
                    visitor.leave((EntityReference)node);
                    break;
                }
                case 6: {
                    visitor.leave((Entity)node);
                    break;
                }
                case 7: {
                    visitor.leave((ProcessingInstruction)node);
                    break;
                }
                case 8: {
                    visitor.leave((Comment)node);
                    break;
                }
                case 9: {
                    visitor.leave((Document)node);
                    break;
                }
                case 10: {
                    visitor.leave((DocumentType)node);
                    break;
                }
                case 11: {
                    visitor.leave((DocumentFragment)node);
                    break;
                }
                case 12: {
                    visitor.leave((Notation)node);
                    break;
                }
                default: {
                    visitor.leave(node);
                }
            }
        }
    }

    public static void traverseChildren(Node node, IDOMVisitor visitor) {
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        int i = 0;
        while (i < size) {
            UDOMVisitor.traverse(children.item(i), visitor);
            ++i;
        }
    }
}

