/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.AlertInfo;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.ContentType;
import gov.nist.javax.sip.header.ErrorInfo;
import gov.nist.javax.sip.header.ErrorInfoList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.InReplyTo;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.Priority;
import gov.nist.javax.sip.header.ProxyAuthenticate;
import gov.nist.javax.sip.header.ProxyAuthorization;
import gov.nist.javax.sip.header.ProxyRequire;
import gov.nist.javax.sip.header.ProxyRequireList;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.RetryAfter;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPETag;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.SIPHeaderList;
import gov.nist.javax.sip.header.SIPIfMatch;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Subject;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Unsupported;
import gov.nist.javax.sip.header.UserAgent;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.header.ViaList;
import gov.nist.javax.sip.header.WWWAuthenticate;
import gov.nist.javax.sip.header.Warning;
import gov.nist.javax.sip.message.HeaderIterator;
import gov.nist.javax.sip.message.ListMap;
import gov.nist.javax.sip.message.MessageObject;
import gov.nist.javax.sip.message.SIPDuplicateHeaderException;
import gov.nist.javax.sip.parser.HeaderParser;
import gov.nist.javax.sip.parser.ParserFactory;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentDispositionHeader;
import javax.sip.header.ContentEncodingHeader;
import javax.sip.header.ContentLanguageHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;

public abstract class SIPMessage
extends MessageObject
implements Message {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected LinkedList unrecognizedHeaders = new LinkedList();
    protected LinkedList headers = new LinkedList();
    protected From fromHeader;
    protected To toHeader;
    protected CSeq cSeqHeader;
    protected CallID callIdHeader;
    protected ContentLength contentLengthHeader;
    protected MaxForwards maxForwardsHeader;
    protected int size;
    private String messageContent;
    private byte[] messageContentBytes;
    private Object messageContentObject;
    private Hashtable nameTable = new Hashtable();

    public static boolean isRequestHeader(SIPHeader sIPHeader) {
        return sIPHeader instanceof AlertInfo || sIPHeader instanceof InReplyTo || sIPHeader instanceof Authorization || sIPHeader instanceof MaxForwards || sIPHeader instanceof UserAgent || sIPHeader instanceof Priority || sIPHeader instanceof ProxyAuthorization || sIPHeader instanceof ProxyRequire || sIPHeader instanceof ProxyRequireList || sIPHeader instanceof Route || sIPHeader instanceof RouteList || sIPHeader instanceof Subject || sIPHeader instanceof SIPIfMatch;
    }

    public static boolean isResponseHeader(SIPHeader sIPHeader) {
        return sIPHeader instanceof ErrorInfo || sIPHeader instanceof ProxyAuthenticate || sIPHeader instanceof Server || sIPHeader instanceof Unsupported || sIPHeader instanceof RetryAfter || sIPHeader instanceof Warning || sIPHeader instanceof WWWAuthenticate || sIPHeader instanceof SIPETag || sIPHeader instanceof RSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList getMessageAsEncodedStrings() {
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList linkedList2 = this.headers;
        synchronized (linkedList2) {
            ListIterator listIterator = this.headers.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)listIterator.next();
                if (sIPHeader instanceof SIPHeaderList) {
                    SIPHeaderList sIPHeaderList = (SIPHeaderList)sIPHeader;
                    linkedList.addAll(sIPHeaderList.getHeadersAsEncodedStrings());
                    continue;
                }
                linkedList.add(sIPHeader.encode());
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String encodeSIPHeaders() {
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList linkedList = this.headers;
        synchronized (linkedList) {
            ListIterator listIterator = this.headers.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)listIterator.next();
                if (sIPHeader instanceof ContentLength) continue;
                stringBuffer.append(sIPHeader.encode());
            }
        }
        return stringBuffer.append(this.contentLengthHeader.encode()).append("\r\n").toString();
    }

    public abstract String encodeMessage();

    public abstract String getDialogId(boolean var1);

    public boolean match(Object object) {
        if (object == null) {
            return true;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage sIPMessage = (SIPMessage)object;
        ListIterator listIterator = sIPMessage.getHeaders();
        while (listIterator.hasNext()) {
            Object object2;
            Object object3;
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            LinkedList linkedList = this.getHeaderList(sIPHeader.getHeaderName());
            if (linkedList == null || linkedList.size() == 0) {
                return false;
            }
            if (sIPHeader instanceof SIPHeaderList) {
                object3 = ((SIPHeaderList)sIPHeader).listIterator();
                while (object3.hasNext()) {
                    object2 = (SIPHeader)object3.next();
                    ListIterator listIterator2 = linkedList.listIterator();
                    boolean bl = false;
                    while (listIterator2.hasNext()) {
                        SIPHeader sIPHeader2 = (SIPHeader)listIterator2.next();
                        if (!sIPHeader2.match(object2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    return false;
                }
                continue;
            }
            object3 = sIPHeader;
            object2 = linkedList.listIterator();
            boolean bl = false;
            while (object2.hasNext()) {
                SIPHeader sIPHeader3 = (SIPHeader)object2.next();
                if (!sIPHeader3.match(object3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public void merge(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad class " + object.getClass());
        }
        SIPMessage sIPMessage = (SIPMessage)object;
        Object[] objectArray = sIPMessage.headers.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            SIPHeader sIPHeader = (SIPHeader)objectArray[i];
            String string = sIPHeader.getHeaderName();
            LinkedList linkedList = this.getHeaderList(string);
            if (linkedList == null) {
                this.attachHeader(sIPHeader);
                continue;
            }
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader2 = (SIPHeader)listIterator.next();
                sIPHeader2.merge(sIPHeader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.headers;
        synchronized (object) {
            ListIterator listIterator = this.headers.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)listIterator.next();
                if (sIPHeader instanceof ContentLength) continue;
                stringBuffer.append(sIPHeader.encode());
            }
        }
        stringBuffer.append(this.contentLengthHeader.encode()).append("\r\n");
        if (this.messageContentObject != null) {
            object = this.getContent().toString();
            stringBuffer.append((String)object);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            object = null;
            try {
                object = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = "";
            }
            stringBuffer.append((String)object);
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeAsBytes() {
        Object object;
        Object object2;
        StringBuffer stringBuffer = new StringBuffer();
        Object object3 = this.headers;
        synchronized (object3) {
            object2 = this.headers.listIterator();
            while (object2.hasNext()) {
                object = (SIPHeader)object2.next();
                if (object instanceof ContentLength) continue;
                stringBuffer.append(((SIPHeader)object).encode());
            }
        }
        stringBuffer.append(this.contentLengthHeader.encode()).append("\r\n");
        object3 = null;
        object2 = this.getRawContent();
        if (object2 != null) {
            object = null;
            try {
                object = stringBuffer.toString().getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                InternalErrorHandler.handleException(unsupportedEncodingException);
            }
            object3 = new byte[((Object)object).length + ((Object)object2).length];
            System.arraycopy(object, 0, object3, 0, ((Object)object).length);
            System.arraycopy(object2, 0, object3, ((Object)object).length, ((Object)object2).length);
        } else {
            try {
                object3 = stringBuffer.toString().getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                InternalErrorHandler.handleException(unsupportedEncodingException);
            }
        }
        return object3;
    }

    public Object clone() {
        SIPMessage sIPMessage = (SIPMessage)super.clone();
        sIPMessage.nameTable = new Hashtable();
        sIPMessage.fromHeader = null;
        sIPMessage.toHeader = null;
        sIPMessage.cSeqHeader = null;
        sIPMessage.callIdHeader = null;
        sIPMessage.contentLengthHeader = null;
        sIPMessage.maxForwardsHeader = null;
        if (this.headers != null) {
            sIPMessage.headers = new LinkedList();
            Iterator iterator = this.headers.iterator();
            while (iterator.hasNext()) {
                SIPHeader sIPHeader = (SIPHeader)iterator.next();
                sIPMessage.attachHeader((SIPHeader)sIPHeader.clone());
            }
        }
        if (this.messageContentBytes != null) {
            sIPMessage.messageContentBytes = (byte[])this.messageContentBytes.clone();
        }
        if (this.messageContentObject != null) {
            sIPMessage.messageContentObject = SIPMessage.makeClone(this.messageContentObject);
        }
        return sIPMessage;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        this.sprint("SIPMessage:");
        this.sprint("{");
        try {
            Field[] fieldArray = this.getClass().getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                Class<?> clazz = field.getType();
                String string = field.getName();
                if (field.get(this) == null || !Class.forName("gov.nist.javax.sip.header.SIPHeader").isAssignableFrom(clazz) || string.compareTo("headers") == 0) continue;
                this.sprint(string + "=");
                this.sprint(((SIPHeader)field.get(this)).debugDump());
            }
        }
        catch (Exception exception) {
            InternalErrorHandler.handleException(exception);
        }
        this.sprint("List of headers : ");
        this.sprint(this.headers.toString());
        this.sprint("messageContent = ");
        this.sprint("{");
        this.sprint(this.messageContent);
        this.sprint("}");
        if (this.getContent() != null) {
            this.sprint(this.getContent().toString());
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public SIPMessage() {
        try {
            this.attachHeader(new ContentLength(0), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void attachHeader(SIPHeader sIPHeader) {
        if (sIPHeader == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList sIPHeaderList;
            if (sIPHeader instanceof SIPHeaderList && (sIPHeaderList = (SIPHeaderList)sIPHeader).isEmpty()) {
                return;
            }
            this.attachHeader(sIPHeader, false, false);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            // empty catch block
        }
    }

    public void setHeader(Header header) {
        SIPHeader sIPHeader = (SIPHeader)header;
        if (sIPHeader == null) {
            throw new IllegalArgumentException("null header!");
        }
        try {
            SIPHeaderList sIPHeaderList;
            if (sIPHeader instanceof SIPHeaderList && (sIPHeaderList = (SIPHeaderList)sIPHeader).isEmpty()) {
                return;
            }
            this.removeHeader(sIPHeader.getHeaderName());
            this.attachHeader(sIPHeader, true, false);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            InternalErrorHandler.handleException(sIPDuplicateHeaderException);
        }
    }

    public void setHeaders(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            try {
                this.attachHeader(sIPHeader, false);
            }
            catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {}
        }
    }

    public void attachHeader(SIPHeader sIPHeader, boolean bl) throws SIPDuplicateHeaderException {
        this.attachHeader(sIPHeader, bl, false);
    }

    public void attachHeader(SIPHeader sIPHeader, boolean bl, boolean bl2) throws SIPDuplicateHeaderException {
        Object object;
        SIPHeader sIPHeader2;
        SIPHeader sIPHeader3;
        if (sIPHeader == null) {
            throw new NullPointerException("null header");
        }
        if (ListMap.hasList(sIPHeader) && !SIPHeaderList.class.isAssignableFrom(sIPHeader.getClass())) {
            sIPHeader3 = ListMap.getList(sIPHeader);
            ((SIPHeaderList)sIPHeader3).add(sIPHeader);
            sIPHeader2 = sIPHeader3;
        } else {
            sIPHeader2 = sIPHeader;
        }
        if (bl) {
            this.nameTable.remove(sIPHeader.getName().toLowerCase());
        } else if (this.nameTable.containsKey(sIPHeader.getName().toLowerCase()) && !(sIPHeader2 instanceof SIPHeaderList)) {
            if (sIPHeader2 instanceof ContentLength) {
                try {
                    sIPHeader3 = (ContentLength)sIPHeader;
                    this.contentLengthHeader.setContentLength(((ContentLength)sIPHeader3).getContentLength());
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
            return;
        }
        sIPHeader3 = (SIPHeader)this.getHeader(sIPHeader.getName());
        if (sIPHeader3 != null) {
            object = this.headers.listIterator();
            while (object.hasNext()) {
                SIPHeader sIPHeader4 = (SIPHeader)object.next();
                if (!sIPHeader4.equals(sIPHeader3)) continue;
                object.remove();
            }
        }
        if (this.getHeader(sIPHeader.getName()) == null) {
            this.nameTable.put(sIPHeader.getName().toLowerCase(), sIPHeader2);
            this.headers.add(sIPHeader2);
        } else if (sIPHeader2 instanceof SIPHeaderList) {
            object = (SIPHeaderList)this.nameTable.get(sIPHeader.getName().toLowerCase());
            if (object != null) {
                ((SIPHeaderList)object).concatenate((SIPHeaderList)sIPHeader2, bl2);
            } else {
                this.nameTable.put(sIPHeader2.getName().toLowerCase(), sIPHeader2);
            }
        } else {
            this.nameTable.put(sIPHeader2.getName().toLowerCase(), sIPHeader2);
        }
        if (sIPHeader2 instanceof From) {
            this.fromHeader = (From)sIPHeader2;
        } else if (sIPHeader2 instanceof ContentLength) {
            this.contentLengthHeader = (ContentLength)sIPHeader2;
        } else if (sIPHeader2 instanceof To) {
            this.toHeader = (To)sIPHeader2;
        } else if (sIPHeader2 instanceof CSeq) {
            this.cSeqHeader = (CSeq)sIPHeader2;
        } else if (sIPHeader2 instanceof CallID) {
            this.callIdHeader = (CallID)sIPHeader2;
        } else if (sIPHeader2 instanceof MaxForwards) {
            this.maxForwardsHeader = (MaxForwards)sIPHeader2;
        }
    }

    public void removeHeader(String string, boolean bl) {
        SIPHeader sIPHeader = (SIPHeader)this.nameTable.get(string.toLowerCase());
        if (sIPHeader == null) {
            return;
        }
        if (sIPHeader instanceof SIPHeaderList) {
            SIPHeaderList sIPHeaderList = (SIPHeaderList)sIPHeader;
            if (bl) {
                sIPHeaderList.removeFirst();
            } else {
                sIPHeaderList.removeLast();
            }
            if (sIPHeaderList.isEmpty()) {
                ListIterator listIterator = this.headers.listIterator();
                while (listIterator.hasNext()) {
                    SIPHeader sIPHeader2 = (SIPHeader)listIterator.next();
                    if (!sIPHeader2.getName().equalsIgnoreCase(string)) continue;
                    listIterator.remove();
                }
                this.nameTable.remove(string.toLowerCase());
            }
        } else {
            this.nameTable.remove(string.toLowerCase());
            if (sIPHeader instanceof From) {
                this.fromHeader = null;
            } else if (sIPHeader instanceof To) {
                this.toHeader = null;
            } else if (sIPHeader instanceof CSeq) {
                this.cSeqHeader = null;
            } else if (sIPHeader instanceof CallID) {
                this.callIdHeader = null;
            } else if (sIPHeader instanceof MaxForwards) {
                this.maxForwardsHeader = null;
            } else if (sIPHeader instanceof ContentLength) {
                this.contentLengthHeader = null;
            }
            ListIterator listIterator = this.headers.listIterator();
            while (listIterator.hasNext()) {
                SIPHeader sIPHeader3 = (SIPHeader)listIterator.next();
                if (!sIPHeader3.getName().equalsIgnoreCase(string)) continue;
                listIterator.remove();
            }
        }
    }

    public void removeHeader(String string) {
        if (string == null) {
            throw new NullPointerException("null arg");
        }
        SIPHeader sIPHeader = (SIPHeader)this.nameTable.get(string.toLowerCase());
        if (sIPHeader == null) {
            return;
        }
        this.nameTable.remove(string.toLowerCase());
        if (sIPHeader instanceof From) {
            this.fromHeader = null;
        } else if (sIPHeader instanceof To) {
            this.toHeader = null;
        } else if (sIPHeader instanceof CSeq) {
            this.cSeqHeader = null;
        } else if (sIPHeader instanceof CallID) {
            this.callIdHeader = null;
        } else if (sIPHeader instanceof MaxForwards) {
            this.maxForwardsHeader = null;
        } else if (sIPHeader instanceof ContentLength) {
            this.contentLengthHeader = null;
        }
        ListIterator listIterator = this.headers.listIterator();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader2 = (SIPHeader)listIterator.next();
            if (!sIPHeader2.getName().equalsIgnoreCase(string)) continue;
            listIterator.remove();
        }
    }

    public String getTransactionId() {
        Via via = null;
        if (!this.getViaHeaders().isEmpty()) {
            via = (Via)this.getViaHeaders().getFirst();
        }
        if (via.getBranch() != null && via.getBranch().toUpperCase().startsWith("z9hG4bK".toUpperCase())) {
            if (this.getCSeq().getMethod().equals("CANCEL")) {
                return (via.getBranch() + ":" + this.getCSeq().getMethod()).toLowerCase();
            }
            return via.getBranch().toLowerCase();
        }
        StringBuffer stringBuffer = new StringBuffer();
        From from = (From)this.getFrom();
        To to = (To)this.getTo();
        if (from.hasTag()) {
            stringBuffer.append(from.getTag()).append(":");
        }
        String string = this.callIdHeader.getCallId();
        stringBuffer.append(string).append(":");
        stringBuffer.append(this.cSeqHeader.getSequenceNumber()).append(":").append(this.cSeqHeader.getMethod());
        if (via != null) {
            stringBuffer.append(":").append(via.getSentBy().encode());
            if (!via.getSentBy().hasPort()) {
                stringBuffer.append(":").append(5060);
            }
        }
        if (this.getCSeq().getMethod().equals("CANCEL")) {
            stringBuffer.append("CANCEL");
        }
        return stringBuffer.toString().toLowerCase();
    }

    public int hashCode() {
        if (this.callIdHeader == null) {
            throw new RuntimeException("Invalid message! Cannot compute hashcode! call-id header is missing !");
        }
        return this.callIdHeader.getCallId().hashCode();
    }

    public boolean hasContent() {
        return this.messageContent != null || this.messageContentBytes != null;
    }

    public ListIterator getHeaders() {
        return this.headers.listIterator();
    }

    public Header getHeader(String string) {
        if (string == null) {
            throw new NullPointerException("bad name");
        }
        SIPHeader sIPHeader = (SIPHeader)this.nameTable.get(string.toLowerCase());
        if (sIPHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sIPHeader).getFirst();
        }
        return sIPHeader;
    }

    public ContentType getContentTypeHeader() {
        return (ContentType)this.getHeader("Content-Type");
    }

    public FromHeader getFrom() {
        return this.fromHeader;
    }

    public ErrorInfoList getErrorInfoHeaders() {
        return (ErrorInfoList)this.getSIPHeaderList("Error-Info");
    }

    public ContactList getContactHeaders() {
        return (ContactList)this.getSIPHeaderList("Contact");
    }

    public Contact getContactHeader() {
        ContactList contactList = this.getContactHeaders();
        if (contactList != null) {
            return (Contact)contactList.getFirst();
        }
        return null;
    }

    public ViaList getViaHeaders() {
        return (ViaList)this.getSIPHeaderList("Via");
    }

    public void setVia(List list) {
        ViaList viaList = new ViaList();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Via via = (Via)listIterator.next();
            viaList.add(via);
        }
        this.setHeader(viaList);
    }

    public void setHeader(SIPHeaderList sIPHeaderList) {
        this.setHeader((Header)sIPHeaderList);
    }

    public Via getTopmostVia() {
        if (this.getViaHeaders() == null) {
            return null;
        }
        return (Via)this.getViaHeaders().getFirst();
    }

    public CSeqHeader getCSeq() {
        return this.cSeqHeader;
    }

    public Authorization getAuthorization() {
        return (Authorization)this.getHeader("Authorization");
    }

    public MaxForwardsHeader getMaxForwards() {
        return this.maxForwardsHeader;
    }

    public void setMaxForwards(MaxForwardsHeader maxForwardsHeader) {
        this.setHeader((Header)maxForwardsHeader);
    }

    public RouteList getRouteHeaders() {
        return (RouteList)this.getSIPHeaderList("Route");
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    public void setCallId(CallIdHeader callIdHeader) {
        this.setHeader((Header)callIdHeader);
    }

    public void setCallId(String string) throws ParseException {
        if (this.callIdHeader == null) {
            this.setHeader(new CallID());
        }
        this.callIdHeader.setCallId(string);
    }

    public RecordRouteList getRecordRouteHeaders() {
        return (RecordRouteList)this.getSIPHeaderList("Record-Route");
    }

    public ToHeader getTo() {
        return this.toHeader;
    }

    public void setTo(ToHeader toHeader) {
        this.setHeader((Header)toHeader);
    }

    public void setFrom(FromHeader fromHeader) {
        this.setHeader((Header)fromHeader);
    }

    public ContentLengthHeader getContentLength() {
        return this.contentLengthHeader;
    }

    public String getMessageContent() throws UnsupportedEncodingException {
        if (this.messageContent == null && this.messageContentBytes == null) {
            return null;
        }
        if (this.messageContent == null) {
            String string;
            ContentType contentType = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
            this.messageContent = contentType != null ? ((string = contentType.getCharset()) != null ? new String(this.messageContentBytes, string) : new String(this.messageContentBytes, DEFAULT_ENCODING)) : new String(this.messageContentBytes, DEFAULT_ENCODING);
        }
        return this.messageContent;
    }

    public byte[] getRawContent() {
        try {
            if (this.messageContent == null && this.messageContentBytes == null && this.messageContentObject == null) {
                return null;
            }
            if (this.messageContentObject != null) {
                String string;
                String string2 = this.messageContentObject.toString();
                ContentType contentType = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
                byte[] byArray = contentType != null ? ((string = contentType.getCharset()) != null ? string2.getBytes(string) : string2.getBytes(DEFAULT_ENCODING)) : string2.getBytes(DEFAULT_ENCODING);
                return byArray;
            }
            if (this.messageContent != null) {
                String string;
                ContentType contentType = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
                byte[] byArray = contentType != null ? ((string = contentType.getCharset()) != null ? this.messageContent.getBytes(string) : this.messageContent.getBytes(DEFAULT_ENCODING)) : this.messageContent.getBytes(DEFAULT_ENCODING);
                return byArray;
            }
            return this.messageContentBytes;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            InternalErrorHandler.handleException(unsupportedEncodingException);
            return null;
        }
    }

    public void setMessageContent(String string, String string2, String string3) {
        if (string3 == null) {
            throw new IllegalArgumentException("messgeContent is null");
        }
        ContentType contentType = new ContentType(string, string2);
        this.setHeader(contentType);
        this.messageContent = string3;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        this.computeContentLength(string3);
    }

    public void setContent(Object object, ContentTypeHeader contentTypeHeader) throws ParseException {
        if (object == null) {
            throw new NullPointerException("null content");
        }
        this.setHeader((Header)contentTypeHeader);
        if (object instanceof String) {
            this.messageContent = (String)object;
        } else if (object instanceof byte[]) {
            this.messageContentBytes = (byte[])object;
        } else {
            this.messageContentObject = object;
        }
        this.computeContentLength(object);
    }

    public Object getContent() {
        if (this.messageContentObject != null) {
            return this.messageContentObject;
        }
        if (this.messageContentBytes != null) {
            return this.messageContentBytes;
        }
        if (this.messageContent != null) {
            return this.messageContent;
        }
        return null;
    }

    public void setMessageContent(String string, String string2, byte[] byArray) {
        ContentType contentType = new ContentType(string, string2);
        this.setHeader(contentType);
        this.setMessageContent(byArray);
        this.computeContentLength(byArray);
    }

    public void setMessageContent(String string) {
        this.computeContentLength(string);
        this.messageContent = string;
        this.messageContentBytes = null;
        this.messageContentObject = null;
    }

    public void setMessageContent(byte[] byArray) {
        this.computeContentLength(byArray);
        this.messageContentBytes = byArray;
        this.messageContent = null;
        this.messageContentObject = null;
    }

    private void computeContentLength(Object object) {
        int n = 0;
        if (object != null) {
            if (object instanceof String) {
                String string = null;
                ContentType contentType = (ContentType)this.nameTable.get("Content-Type".toLowerCase());
                if (contentType != null) {
                    string = contentType.getCharset();
                }
                if (string == null) {
                    string = DEFAULT_ENCODING;
                }
                try {
                    n = ((String)object).getBytes(string).length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    InternalErrorHandler.handleException(unsupportedEncodingException);
                }
            } else {
                n = object instanceof byte[] ? ((byte[])object).length : object.toString().length();
            }
        }
        try {
            this.contentLengthHeader.setContentLength(n);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void removeContent() {
        this.messageContent = null;
        this.messageContentBytes = null;
        this.messageContentObject = null;
        try {
            this.contentLengthHeader.setContentLength(0);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public ListIterator getHeaders(String string) {
        if (string == null) {
            throw new NullPointerException("null headerName");
        }
        SIPHeader sIPHeader = (SIPHeader)this.nameTable.get(string.toLowerCase());
        if (sIPHeader == null) {
            return new LinkedList().listIterator();
        }
        if (sIPHeader instanceof SIPHeaderList) {
            return ((SIPHeaderList)sIPHeader).listIterator();
        }
        return new HeaderIterator(this, sIPHeader);
    }

    private SIPHeaderList getSIPHeaderList(String string) {
        return (SIPHeaderList)this.nameTable.get(string.toLowerCase());
    }

    private LinkedList getHeaderList(String string) {
        SIPHeader sIPHeader = (SIPHeader)this.nameTable.get(string.toLowerCase());
        if (sIPHeader == null) {
            return null;
        }
        if (sIPHeader instanceof SIPHeaderList) {
            return (LinkedList)((SIPHeaderList)sIPHeader).getHeaderList();
        }
        LinkedList<SIPHeader> linkedList = new LinkedList<SIPHeader>();
        linkedList.add(sIPHeader);
        return linkedList;
    }

    public boolean hasHeader(String string) {
        return this.nameTable.containsKey(string.toLowerCase());
    }

    public boolean hasFromTag() {
        return this.fromHeader != null && this.fromHeader.getTag() != null;
    }

    public boolean hasToTag() {
        return this.toHeader != null && this.toHeader.getTag() != null;
    }

    public String getFromTag() {
        return this.fromHeader == null ? null : this.fromHeader.getTag();
    }

    public void setFromTag(String string) {
        try {
            this.fromHeader.setTag(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setToTag(String string) {
        try {
            this.toHeader.setTag(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getToTag() {
        return this.toHeader == null ? null : this.toHeader.getTag();
    }

    public abstract String getFirstLine();

    public void addHeader(Header header) {
        SIPHeader sIPHeader = (SIPHeader)header;
        try {
            if (header instanceof ViaHeader) {
                this.attachHeader(sIPHeader, false, true);
            } else {
                this.attachHeader(sIPHeader, false, false);
            }
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            try {
                if (header instanceof ContentLength) {
                    ContentLength contentLength = (ContentLength)header;
                    this.contentLengthHeader.setContentLength(contentLength.getContentLength());
                }
            }
            catch (InvalidArgumentException invalidArgumentException) {
                // empty catch block
            }
        }
    }

    public void addUnparsed(String string) {
        this.unrecognizedHeaders.add(string);
    }

    public void addHeader(String string) {
        String string2 = string.trim() + "\n";
        try {
            HeaderParser headerParser = ParserFactory.createParser(string);
            SIPHeader sIPHeader = headerParser.parse();
            this.attachHeader(sIPHeader, false);
        }
        catch (ParseException parseException) {
            this.unrecognizedHeaders.add(string2);
        }
    }

    public ListIterator getUnrecognizedHeaders() {
        return this.unrecognizedHeaders.listIterator();
    }

    public ListIterator getHeaderNames() {
        ListIterator listIterator = this.headers.listIterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (listIterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)listIterator.next();
            String string = sIPHeader.getName();
            linkedList.add(string);
        }
        return linkedList.listIterator();
    }

    public boolean equals(Object object) {
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        SIPMessage sIPMessage = (SIPMessage)object;
        Collection collection = this.nameTable.values();
        Iterator iterator = collection.iterator();
        if (this.nameTable.size() != sIPMessage.nameTable.size()) {
            return false;
        }
        while (iterator.hasNext()) {
            SIPHeader sIPHeader = (SIPHeader)iterator.next();
            SIPHeader sIPHeader2 = (SIPHeader)sIPMessage.nameTable.get(sIPHeader.getName().toLowerCase());
            if (sIPHeader2 == null) {
                return false;
            }
            if (sIPHeader2.equals(sIPHeader)) continue;
            return false;
        }
        return true;
    }

    public ContentDispositionHeader getContentDisposition() {
        return (ContentDispositionHeader)this.getHeader("Content-Disposition");
    }

    public ContentEncodingHeader getContentEncoding() {
        return (ContentEncodingHeader)this.getHeader("Content-Encoding");
    }

    public ContentLanguageHeader getContentLanguage() {
        return (ContentLanguageHeader)this.getHeader("Content-Language");
    }

    public ExpiresHeader getExpires() {
        return (ExpiresHeader)this.getHeader("Expires");
    }

    public void setExpires(ExpiresHeader expiresHeader) {
        this.setHeader((Header)expiresHeader);
    }

    public void setContentDisposition(ContentDispositionHeader contentDispositionHeader) {
        this.setHeader((Header)contentDispositionHeader);
    }

    public void setContentEncoding(ContentEncodingHeader contentEncodingHeader) {
        this.setHeader((Header)contentEncodingHeader);
    }

    public void setContentLanguage(ContentLanguageHeader contentLanguageHeader) {
        this.setHeader((Header)contentLanguageHeader);
    }

    public void setContentLength(ContentLengthHeader contentLengthHeader) {
        try {
            this.contentLengthHeader.setContentLength(contentLengthHeader.getContentLength());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public void addLast(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, false);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    public void addFirst(Header header) throws SipException, NullPointerException {
        if (header == null) {
            throw new NullPointerException("null arg!");
        }
        try {
            this.attachHeader((SIPHeader)header, false, true);
        }
        catch (SIPDuplicateHeaderException sIPDuplicateHeaderException) {
            throw new SipException("Cannot add header - header already exists");
        }
    }

    public void removeFirst(String string) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(string, true);
    }

    public void removeLast(String string) {
        if (string == null) {
            throw new NullPointerException("Null argument Provided!");
        }
        this.removeHeader(string, false);
    }

    public void setCSeq(CSeqHeader cSeqHeader) {
        this.setHeader((Header)cSeqHeader);
    }

    public abstract void setSIPVersion(String var1) throws ParseException;

    public abstract String getSIPVersion();

    public abstract String toString();
}

