/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.protocol;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.media.Format;
import javax.media.Manager;
import javax.media.NoProcessorException;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.TrackControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullBufferDataSource;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushBufferDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceStream;
import org.jitsi.impl.neomedia.ProcessorUtility;
import org.jitsi.impl.neomedia.control.ControlsAdapter;

public class TranscodingDataSource
extends DataSource {
    private final DataSource inputDataSource;
    private DataSource outputDataSource;
    private final Format outputFormat;
    private Processor transcodingProcessor;

    public TranscodingDataSource(DataSource inputDataSource, Format outputFormat) {
        super(inputDataSource.getLocator());
        this.inputDataSource = inputDataSource;
        this.outputFormat = outputFormat;
    }

    @Override
    public synchronized void connect() throws IOException {
        Processor processor;
        if (this.outputDataSource != null) {
            return;
        }
        this.inputDataSource.connect();
        try {
            processor = Manager.createProcessor(this.inputDataSource);
        }
        catch (NoProcessorException npex) {
            IOException ioex = new IOException();
            ioex.initCause(npex);
            throw ioex;
        }
        ProcessorUtility processorUtility = new ProcessorUtility();
        if (!processorUtility.waitForState(processor, 180)) {
            throw new IOException("Couldn't configure transcoding processor.");
        }
        TrackControl[] trackControls = processor.getTrackControls();
        if (trackControls != null) {
            block2: for (TrackControl trackControl : trackControls) {
                Format[] supportedTrackFormats;
                Format trackFormat = trackControl.getFormat();
                if (!(trackFormat instanceof AudioFormat) || trackFormat.matches(this.outputFormat) || (supportedTrackFormats = trackControl.getSupportedFormats()) == null) continue;
                for (Format supportedTrackFormat : supportedTrackFormats) {
                    Format intersectionFormat;
                    if (!supportedTrackFormat.matches(this.outputFormat) || (intersectionFormat = supportedTrackFormat.intersects(this.outputFormat)) == null) continue;
                    trackControl.setFormat(intersectionFormat);
                    continue block2;
                }
            }
        }
        if (!processorUtility.waitForState(processor, 300)) {
            throw new IOException("Couldn't realize transcoding processor.");
        }
        DataSource outputDataSource = processor.getDataOutput();
        outputDataSource.connect();
        this.transcodingProcessor = processor;
        this.outputDataSource = outputDataSource;
    }

    @Override
    public synchronized void disconnect() {
        if (this.outputDataSource == null) {
            return;
        }
        try {
            this.stop();
        }
        catch (IOException ioex) {
            throw new UndeclaredThrowableException(ioex);
        }
        this.outputDataSource.disconnect();
        this.transcodingProcessor.deallocate();
        this.transcodingProcessor.close();
        this.transcodingProcessor = null;
        this.outputDataSource = null;
    }

    @Override
    public synchronized String getContentType() {
        return this.outputDataSource == null ? null : this.outputDataSource.getContentType();
    }

    @Override
    public synchronized Object getControl(String controlType) {
        return this.outputDataSource.getControl(controlType);
    }

    @Override
    public synchronized Object[] getControls() {
        return this.outputDataSource == null ? ControlsAdapter.EMPTY_CONTROLS : this.outputDataSource.getControls();
    }

    @Override
    public synchronized Time getDuration() {
        return this.outputDataSource == null ? DURATION_UNKNOWN : this.outputDataSource.getDuration();
    }

    public synchronized SourceStream[] getStreams() {
        if (this.outputDataSource instanceof PushBufferDataSource) {
            return ((PushBufferDataSource)this.outputDataSource).getStreams();
        }
        if (this.outputDataSource instanceof PullBufferDataSource) {
            return ((PullBufferDataSource)this.outputDataSource).getStreams();
        }
        if (this.outputDataSource instanceof PushDataSource) {
            return ((PushDataSource)this.outputDataSource).getStreams();
        }
        if (this.outputDataSource instanceof PullDataSource) {
            return ((PullDataSource)this.outputDataSource).getStreams();
        }
        return new SourceStream[0];
    }

    @Override
    public synchronized void start() throws IOException {
        this.outputDataSource.start();
        this.transcodingProcessor.start();
    }

    @Override
    public synchronized void stop() throws IOException {
        if (this.outputDataSource != null) {
            this.transcodingProcessor.stop();
            this.outputDataSource.stop();
        }
    }

    public Processor getTranscodingProcessor() {
        return this.transcodingProcessor;
    }
}

