/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.tlv;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.tlv.AbstractTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMutableTlvChain
extends AbstractTlvChain
implements MutableTlvChain {
    private final List<Tlv> tlvList = new LinkedList<Tlv>();
    private final Map<Integer, List<Tlv>> tlvMap = new HashMap<Integer, List<Tlv>>();

    protected DefaultMutableTlvChain() {
    }

    protected DefaultMutableTlvChain(TlvChain tlvChain) {
        this.copy(tlvChain);
    }

    @Override
    public final synchronized void addTlv(Tlv tlv) {
        this.addTlvImpl(tlv);
    }

    @Override
    public final synchronized void replaceTlv(Tlv tlv) {
        DefensiveTools.checkNull(tlv, "tlv");
        int n = tlv.getType();
        List<Tlv> list = this.getTlvMap().get(n);
        int n2 = -1;
        if (list == null) {
            list = new LinkedList<Tlv>();
            this.getTlvMap().put(n, list);
        } else if (!list.isEmpty()) {
            int n3 = 0;
            Iterator<Tlv> iterator = this.getTlvList().iterator();
            while (iterator.hasNext()) {
                Tlv tlv2 = iterator.next();
                if (tlv2.getType() == n) {
                    if (n2 == -1) {
                        n2 = n3;
                    }
                    iterator.remove();
                }
                ++n3;
            }
            list.clear();
        }
        if (n2 == -1) {
            n2 = this.getTlvList().size();
        }
        list.add(tlv);
        this.getTlvList().add(n2, tlv);
    }

    @Override
    public final synchronized void removeTlv(Tlv tlv) {
        DefensiveTools.checkNull(tlv, "tlv");
        int n = tlv.getType();
        List<Tlv> list = this.getTlvMap().get(n);
        if (list != null) {
            while (list.remove(tlv)) {
            }
        }
        while (this.getTlvList().remove(tlv)) {
        }
    }

    @Override
    public final synchronized void removeTlvs(int n) {
        DefensiveTools.checkRange(n, "type", 0);
        List<Tlv> list = this.getTlvMap().remove(n);
        if (list != null) {
            this.getTlvList().removeAll(list);
        }
    }

    @Override
    public final synchronized void removeTlvs(int ... nArray) {
        int[] nArray2;
        DefensiveTools.checkNull(nArray, "types");
        for (int n : nArray2 = (int[])nArray.clone()) {
            DefensiveTools.checkRange(n, "types[] elements", 0);
        }
        for (int n : nArray2) {
            this.removeTlvs(n);
        }
    }

    @Override
    public final synchronized void addAll(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "other");
        List<Tlv> list = tlvChain instanceof AbstractTlvChain ? ((AbstractTlvChain)tlvChain).getTlvList() : tlvChain.getTlvs();
        for (Tlv tlv : list) {
            this.addTlvImpl(tlv);
        }
    }

    @Override
    public final synchronized void replaceAll(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "other");
        List<Tlv> list = tlvChain instanceof AbstractTlvChain ? ((AbstractTlvChain)tlvChain).getTlvList() : tlvChain.getTlvs();
        for (Tlv tlv : list) {
            this.replaceTlv(tlv);
        }
    }

    @Override
    protected synchronized List<Tlv> getTlvList() {
        return this.tlvList;
    }

    @Override
    protected synchronized Map<Integer, List<Tlv>> getTlvMap() {
        return this.tlvMap;
    }
}

