/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.rooms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.Writable;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.ExchangeInfo;
import net.kano.joscar.snaccmd.FullRoomInfo;
import net.kano.joscar.snaccmd.rooms.RoomCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoomResponse
extends RoomCommand {
    private static final int TYPE_MAX_ROOMS = 2;
    private static final int TYPE_EXCHANGE_INFO = 3;
    private static final int TYPE_ROOM_INFO = 4;
    private final int maxRooms;
    private final List<ExchangeInfo> exchangeInfos;
    private final FullRoomInfo roomInfo;

    protected RoomResponse(SnacPacket snacPacket) {
        super(9);
        DefensiveTools.checkNull(snacPacket, "packet");
        ByteBlock byteBlock = snacPacket.getData();
        ImmutableTlvChain immutableTlvChain = TlvTools.readChain(byteBlock);
        Tlv tlv = immutableTlvChain.getLastTlv(2);
        this.maxRooms = tlv == null ? -1 : (int)BinaryTools.getUByte(tlv.getData(), 0);
        LinkedList<ExchangeInfo> linkedList = new LinkedList<ExchangeInfo>();
        for (Writable writable : immutableTlvChain.getTlvs(3)) {
            ByteBlock byteBlock2 = writable.getData();
            ExchangeInfo exchangeInfo = ExchangeInfo.readExchangeInfo(byteBlock2);
            if (exchangeInfo == null) continue;
            linkedList.add(exchangeInfo);
        }
        this.exchangeInfos = linkedList.isEmpty() ? null : linkedList;
        Tlv tlv2 = immutableTlvChain.getLastTlv(4);
        if (tlv2 == null) {
            this.roomInfo = null;
        } else {
            Writable writable;
            writable = tlv2.getData();
            this.roomInfo = FullRoomInfo.readRoomInfo((ByteBlock)writable);
        }
    }

    public RoomResponse(FullRoomInfo fullRoomInfo) {
        this(-1, null, fullRoomInfo);
    }

    public RoomResponse(int n, Collection<ExchangeInfo> collection) {
        this(n, collection, null);
    }

    public RoomResponse(int n, Collection<ExchangeInfo> collection, FullRoomInfo fullRoomInfo) {
        super(9);
        DefensiveTools.checkRange(n, "maxRooms", -1);
        this.maxRooms = n;
        this.exchangeInfos = DefensiveTools.getUnmodifiableCopy(collection);
        this.roomInfo = fullRoomInfo;
    }

    public final int getMaxRooms() {
        return this.maxRooms;
    }

    public final List<ExchangeInfo> getExchangeInfos() {
        return this.exchangeInfos;
    }

    public final FullRoomInfo getRoomInfo() {
        return this.roomInfo;
    }

    @Override
    public void writeData(OutputStream outputStream) throws IOException {
        if (this.maxRooms != -1) {
            Tlv.getUShortInstance(2, this.maxRooms).write(outputStream);
        }
        if (this.exchangeInfos != null) {
            for (int i = 0; i < this.exchangeInfos.size(); ++i) {
                new Tlv(3, ByteBlock.createByteBlock(this.exchangeInfos.get(i))).write(outputStream);
            }
        }
        if (this.roomInfo != null) {
            new Tlv(4, ByteBlock.createByteBlock(this.roomInfo)).write(outputStream);
        }
    }

    public String toString() {
        return "RoomResponse: maxRooms=" + this.maxRooms + ", exchangeInfos=" + (this.exchangeInfos == null ? -1 : this.exchangeInfos.size()) + ", roomInfo=" + this.roomInfo;
    }
}

