/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm.ft;

import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.ConnectionType;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.Initiator;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionImpl;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.RvConnectionSettings;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.TimeoutHandler;
import net.kano.joustsim.oscar.oscar.service.icbm.ft.controllers.TimeoutableController;
import org.jetbrains.annotations.Nullable;

public class TimerTimeoutHandler
implements TimeoutHandler {
    private final Timer timer = new Timer(true);
    private final RvConnectionImpl conn;
    private Map<TimeoutableController, TimerInfo> tasks = new IdentityHashMap<TimeoutableController, TimerInfo>();

    public TimerTimeoutHandler(RvConnectionImpl conn) {
        this.conn = conn;
    }

    public void startTimeout(TimeoutableController controller) {
        ConnectionType type = controller.getTimeoutType();
        RvConnectionSettings settings = this.conn.getSettings();
        Initiator initiator = this.conn.getRvSessionInfo().getInitiator();
        long timeout = type == null ? settings.getDefaultPerConnectionTimeout(initiator) : settings.getPerConnectionTimeout(initiator, type);
        TimerInfo task = new TimerInfo(controller, timeout);
        this.storeTimer(controller, task);
        task.start();
    }

    private synchronized void storeTimer(TimeoutableController controller, TimerInfo task) {
        this.tasks.put(controller, task);
    }

    @Nullable
    private synchronized TimerInfo getTimer(TimeoutableController c) {
        return this.tasks.get(c);
    }

    public void pauseTimeout(TimeoutableController controller) {
        TimerInfo task = this.getTimer(controller);
        if (task != null) {
            task.pause();
        }
    }

    public void unpauseTimeout(TimeoutableController controller) {
        TimerInfo task = this.getTimer(controller);
        if (task != null) {
            task.unpause();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.timer.cancel();
    }

    private class TimerInfo {
        private long started = -1L;
        private final TimeoutableController controller;
        private final long timeout;
        private long pausedSince = -1L;
        private long pausedTotal = 0L;
        private TimerTask lastTask = null;

        public TimerInfo(TimeoutableController controller, long timeout) {
            this.controller = controller;
            this.timeout = timeout;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Date date;
            this.started = System.currentTimeMillis();
            assert (!Thread.holdsLock(this));
            TimerTask task = this.makeTask();
            TimerInfo timerInfo = this;
            synchronized (timerInfo) {
                this.lastTask = task;
                date = this.getNextDate();
            }
            TimerTimeoutHandler.this.timer.schedule(task, date);
        }

        private synchronized Date getNextDate() {
            return new Date(this.started + this.timeout + this.pausedTotal);
        }

        private TimerTask makeTask() {
            return new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    TimerInfo timerInfo = TimerInfo.this;
                    synchronized (timerInfo) {
                        if (this != TimerInfo.this.lastTask) {
                            return;
                        }
                    }
                    TimerInfo.this.controller.cancelIfNotFruitful(TimerInfo.this.timeout);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pause() {
            TimerTask lastTask;
            TimerInfo timerInfo = this;
            synchronized (timerInfo) {
                if (this.pausedSince != -1L) {
                    return;
                }
                lastTask = this.lastTask;
                this.lastTask = null;
                this.pausedSince = System.currentTimeMillis();
            }
            if (lastTask != null) {
                lastTask.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void unpause() {
            Date date;
            TimerTask task = this.makeTask();
            TimerInfo timerInfo = this;
            synchronized (timerInfo) {
                if (this.pausedSince == -1L) {
                    return;
                }
                this.pausedTotal += System.currentTimeMillis() - this.pausedSince;
                this.pausedSince = -1L;
                date = this.getNextDate();
            }
            TimerTimeoutHandler.this.timer.schedule(task, date);
        }
    }
}

