/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.beans.PropertyChangeEvent;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.BuddyInfo;
import net.kano.joustsim.oscar.BuddyInfoManager;
import net.kano.joustsim.oscar.GlobalBuddyInfoListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconRequestListener;
import net.kano.joustsim.oscar.oscar.service.icon.IconService;
import net.kano.joustsim.oscar.oscar.service.icon.IconServiceArbiter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuddyIconTracker {
    private static final Logger LOGGER = Logger.getLogger(BuddyIconTracker.class.getName());
    private AimConnection conn;
    private Map<ExtraInfoData, ByteBlock> cache = new HashMap<ExtraInfoData, ByteBlock>();
    private boolean enabled = true;
    private IconRequestListener iconRequestListener = new IconRequestListener(){

        public void buddyIconCleared(IconService service, Screenname screenname, ExtraInfoData data) {
            if (!BuddyIconTracker.this.isEnabled()) {
                return;
            }
            LOGGER.fine("Buddy icon cleared for " + screenname + ": " + data);
            BuddyIconTracker.this.storeBuddyIconData(screenname, data, null);
        }

        public void buddyIconUpdated(IconService service, Screenname screenname, ExtraInfoData hash, ByteBlock iconData) {
            if (!BuddyIconTracker.this.isEnabled()) {
                return;
            }
            BuddyIconTracker.this.storeInCache(hash, iconData);
            BuddyInfo buddyInfo = BuddyIconTracker.this.conn.getBuddyInfoManager().getBuddyInfo(screenname);
            LOGGER.fine("Storing buddy icon for " + screenname);
            if (!buddyInfo.setIconDataIfHashMatches(hash, iconData)) {
                LOGGER.info("Buddy icon data for " + screenname + " set too " + "late - hash " + hash + " no longer matches");
            }
        }
    };

    public BuddyIconTracker(AimConnection aconn) {
        this.conn = aconn;
        BuddyInfoManager mgr = this.conn.getBuddyInfoManager();
        mgr.addGlobalBuddyInfoListener(new GlobalBuddyInfoListener(){

            public void newBuddyInfo(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
                if (!BuddyIconTracker.this.isEnabled()) {
                    return;
                }
                BuddyIconTracker.this.handleNewIconHashForBuddy(buddy, info.getIconHash());
            }

            public void buddyInfoChanged(BuddyInfoManager manager, Screenname buddy, BuddyInfo info, PropertyChangeEvent event) {
                if (!BuddyIconTracker.this.isEnabled()) {
                    return;
                }
                if (event.getPropertyName().equals("iconHash")) {
                    ExtraInfoData newHash = (ExtraInfoData)event.getNewValue();
                    BuddyIconTracker.this.handleNewIconHashForBuddy(buddy, newHash);
                }
            }

            public void receivedStatusUpdate(BuddyInfoManager manager, Screenname buddy, BuddyInfo info) {
            }
        });
    }

    private void handleNewIconHashForBuddy(Screenname buddy, ExtraInfoData newHash) {
        LOGGER.fine("Got new icon hash for " + buddy + ": " + newHash);
        if (newHash != null) {
            ByteBlock iconData = this.getIconDataForHash(newHash);
            if (iconData == null) {
                IconServiceArbiter iconArbiter = this.conn.getExternalServiceManager().getIconServiceArbiter();
                if (iconArbiter != null) {
                    LOGGER.info("Requesting buddy icon for " + buddy);
                    iconArbiter.addIconRequestListener(this.iconRequestListener);
                    iconArbiter.requestIcon(buddy, newHash);
                } else {
                    LOGGER.warning("icon arbiter is null!");
                }
            } else {
                LOGGER.finer("Icon data was already cached for " + buddy);
                this.storeBuddyIconData(buddy, newHash, iconData);
            }
        } else {
            this.storeBuddyIconData(buddy, newHash, null);
        }
    }

    private void storeBuddyIconData(Screenname buddy, ExtraInfoData iconInfo, ByteBlock iconData) {
        this.conn.getBuddyInfoManager().getBuddyInfo(buddy).setIconDataIfHashMatches(iconInfo, iconData);
    }

    @Nullable
    public synchronized ByteBlock getIconDataForHash(ExtraInfoData hash) {
        return this.cache.get(hash);
    }

    private synchronized void storeInCache(ExtraInfoData hash, @NotNull ByteBlock iconData) {
        LOGGER.fine("Cached icon data for " + hash);
        this.cache.put(hash, ByteBlock.wrap((byte[])iconData.toByteArray()));
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.cache.clear();
        }
    }

    @Nullable
    public ByteBlock getBuddyIconData(Screenname screenname) {
        BuddyInfo buddyInfo = this.conn.getBuddyInfoManager().getBuddyInfo(screenname);
        if (buddyInfo == null) {
            return null;
        }
        ExtraInfoData hash = buddyInfo.getIconHash();
        if (hash == null) {
            return null;
        }
        return this.getIconDataForHash(hash);
    }

    private static ByteBlock getIconHash(ByteBlock iconData) {
        ByteBlock hash;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            hash = ByteBlock.wrap((byte[])digest.digest(iconData.toByteArray()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        return hash;
    }

    public ExtraInfoData addToCache(Screenname screenname, ByteBlock iconData) {
        DefensiveTools.checkNull((Object)iconData, (String)"iconData");
        ExtraInfoData iconInfo = new ExtraInfoData(1, BuddyIconTracker.getIconHash(iconData));
        this.storeInCache(iconInfo, iconData);
        return iconInfo;
    }
}

