/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.java.sip.communicator.impl.protocol.jabber.extensions.whiteboard.WhiteboardObjectJabberImpl;
import net.java.sip.communicator.service.protocol.WhiteboardPoint;
import net.java.sip.communicator.service.protocol.whiteboardobjects.WhiteboardObjectText;
import net.java.sip.communicator.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WhiteboardObjectTextJabberImpl
extends WhiteboardObjectJabberImpl
implements WhiteboardObjectText {
    private static final Logger logger = Logger.getLogger(WhiteboardObjectTextJabberImpl.class);
    private int fontSize;
    private String fontName;
    private String text;
    private WhiteboardPoint whiteboardPoint;

    public WhiteboardObjectTextJabberImpl() {
        this.fontSize = 0;
        this.fontName = "Dialog";
        this.text = "";
        this.setWhiteboardPoint(new WhiteboardPoint(0.0, 0.0));
        this.setFontName(this.fontName);
        this.setFontSize(this.fontSize);
        this.setText(this.text);
    }

    public WhiteboardObjectTextJabberImpl(String xml) {
        block7: {
            this.fontSize = 0;
            this.fontName = "Dialog";
            this.text = "";
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
                Document doc = builder.parse(in);
                Element e = doc.getDocumentElement();
                String elementName = e.getNodeName();
                if (elementName.equals("text")) {
                    String id = e.getAttribute("id");
                    double x = Double.parseDouble(e.getAttribute("x"));
                    double y = Double.parseDouble(e.getAttribute("y"));
                    String fill = e.getAttribute("fill");
                    String fontFamily = e.getAttribute("font-family");
                    int fontSize = Integer.parseInt(e.getAttribute("font-size"));
                    String text = e.getTextContent();
                    this.setID(id);
                    this.setWhiteboardPoint(new WhiteboardPoint(x, y));
                    this.setFontName(fontFamily);
                    this.setFontSize(fontSize);
                    this.setText(text);
                    this.setColor(Color.decode(fill).getRGB());
                }
            }
            catch (ParserConfigurationException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (IOException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Problem WhiteboardObject : " + xml));
                }
            }
            catch (Exception ex) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)("Problem WhiteboardObject : " + xml));
            }
        }
    }

    public WhiteboardPoint getWhiteboardPoint() {
        return this.whiteboardPoint;
    }

    public void setWhiteboardPoint(WhiteboardPoint whiteboardPoint) {
        this.whiteboardPoint = whiteboardPoint;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Override
    public String toXML() {
        String s = "<text id=\"#i\" x=\"#x\" y=\"#y\" fill=\"#fi\" font-family=\"#ff\" font-size=\"#fs\">#t</text>";
        s = s.replaceAll("#i", this.getID());
        s = s.replaceAll("#fi", this.colorToHex(this.getColor()));
        WhiteboardPoint p = this.getWhiteboardPoint();
        s = s.replaceAll("#x", "" + p.getX());
        s = s.replaceAll("#y", "" + p.getY());
        s = s.replaceAll("#ff", this.getFontName());
        s = s.replaceAll("#fs", "" + this.getFontSize());
        s = s.replaceAll("#t", this.getText());
        return s;
    }
}

