/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.common.support;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.IdleStatus;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFuture;
import org.apache.mina.common.IoFutureListener;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.TrafficMask;
import org.apache.mina.common.WriteFuture;
import org.apache.mina.common.support.DefaultCloseFuture;
import org.apache.mina.common.support.DefaultWriteFuture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseIoSession
implements IoSession {
    private static final IoFutureListener SCHEDULED_COUNTER_RESETTER = new IoFutureListener(){

        public void operationComplete(IoFuture future) {
            BaseIoSession s = (BaseIoSession)future.getSession();
            s.scheduledWriteBytes.set(0);
            s.scheduledWriteRequests.set(0);
        }
    };
    private final Object lock = new Object();
    private final Map<String, Object> attributes = Collections.synchronizedMap(new HashMap(8));
    private final long creationTime;
    private final CloseFuture closeFuture = new DefaultCloseFuture(this);
    private final AtomicBoolean scheduledForFlush = new AtomicBoolean();
    private final AtomicInteger scheduledWriteBytes = new AtomicInteger();
    private final AtomicInteger scheduledWriteRequests = new AtomicInteger();
    private volatile boolean closing;
    private int idleTimeForRead;
    private int idleTimeForWrite;
    private int idleTimeForBoth;
    private int writeTimeout;
    private TrafficMask trafficMask = TrafficMask.ALL;
    private long readBytes;
    private long writtenBytes;
    private long readMessages;
    private long writtenMessages;
    private long lastReadTime;
    private long lastWriteTime;
    private int idleCountForBoth;
    private int idleCountForRead;
    private int idleCountForWrite;
    private long lastIdleTimeForBoth;
    private long lastIdleTimeForRead = this.lastIdleTimeForWrite = System.currentTimeMillis();
    private long lastIdleTimeForWrite;

    protected BaseIoSession() {
        this.lastIdleTimeForBoth = this.lastIdleTimeForWrite;
        this.lastWriteTime = this.lastIdleTimeForWrite;
        this.lastReadTime = this.lastIdleTimeForWrite;
        this.creationTime = this.lastIdleTimeForWrite;
        this.closeFuture.addListener(SCHEDULED_COUNTER_RESETTER);
    }

    @Override
    public boolean isConnected() {
        return !this.closeFuture.isClosed();
    }

    @Override
    public boolean isClosing() {
        return this.closing || this.closeFuture.isClosed();
    }

    @Override
    public CloseFuture getCloseFuture() {
        return this.closeFuture;
    }

    public boolean isScheduledForFlush() {
        return this.scheduledForFlush.get();
    }

    public boolean setScheduledForFlush(boolean flag) {
        if (flag) {
            return this.scheduledForFlush.compareAndSet(false, true);
        }
        this.scheduledForFlush.set(false);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloseFuture close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosing()) {
                return this.closeFuture;
            }
            this.closing = true;
        }
        this.close0();
        return this.closeFuture;
    }

    protected void close0() {
        this.closeFuture.setClosed();
    }

    @Override
    public WriteFuture write(Object message) {
        return this.write(message, null);
    }

    public WriteFuture write(Object message, SocketAddress remoteAddress) {
        if (this.isClosing()) {
            return DefaultWriteFuture.newNotWrittenFuture(this);
        }
        DefaultWriteFuture future = new DefaultWriteFuture(this);
        this.write0(new IoFilter.WriteRequest(message, future, remoteAddress));
        return future;
    }

    protected void write0(IoFilter.WriteRequest writeRequest) {
        writeRequest.getFuture().setWritten(false);
    }

    @Override
    public Object getAttachment() {
        return this.getAttribute("");
    }

    @Override
    public Object setAttachment(Object attachment) {
        return this.setAttribute("", attachment);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Object setAttribute(String key, Object value) {
        if (value == null) {
            return this.removeAttribute(key);
        }
        return this.attributes.put(key, value);
    }

    @Override
    public Object setAttribute(String key) {
        return this.setAttribute(key, Boolean.TRUE);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public boolean containsAttribute(String key) {
        return this.getAttribute(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAttributeKeys() {
        Map<String, Object> map = this.attributes;
        synchronized (map) {
            return new HashSet<String>(this.attributes.keySet());
        }
    }

    @Override
    public int getIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public long getIdleTimeInMillis(IdleStatus status) {
        return (long)this.getIdleTime(status) * 1000L;
    }

    @Override
    public void setIdleTime(IdleStatus status, int idleTime) {
        if (idleTime < 0) {
            throw new IllegalArgumentException("Illegal idle time: " + idleTime);
        }
        if (status == IdleStatus.BOTH_IDLE) {
            this.idleTimeForBoth = idleTime;
        } else if (status == IdleStatus.READER_IDLE) {
            this.idleTimeForRead = idleTime;
        } else if (status == IdleStatus.WRITER_IDLE) {
            this.idleTimeForWrite = idleTime;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }

    @Override
    public int getWriteTimeout() {
        return this.writeTimeout;
    }

    @Override
    public long getWriteTimeoutInMillis() {
        return (long)this.writeTimeout * 1000L;
    }

    @Override
    public void setWriteTimeout(int writeTimeout) {
        if (writeTimeout < 0) {
            throw new IllegalArgumentException("Illegal write timeout: " + writeTimeout);
        }
        this.writeTimeout = writeTimeout;
    }

    @Override
    public TrafficMask getTrafficMask() {
        return this.trafficMask;
    }

    @Override
    public void setTrafficMask(TrafficMask trafficMask) {
        if (trafficMask == null) {
            throw new NullPointerException("trafficMask");
        }
        if (this.trafficMask == trafficMask) {
            return;
        }
        this.trafficMask = trafficMask;
        this.updateTrafficMask();
    }

    @Override
    public void suspendRead() {
        this.setTrafficMask(this.getTrafficMask().and(TrafficMask.READ.not()));
    }

    @Override
    public void suspendWrite() {
        this.setTrafficMask(this.getTrafficMask().and(TrafficMask.WRITE.not()));
    }

    @Override
    public void resumeRead() {
        this.setTrafficMask(this.getTrafficMask().or(TrafficMask.READ));
    }

    @Override
    public void resumeWrite() {
        this.setTrafficMask(this.getTrafficMask().or(TrafficMask.WRITE));
    }

    protected abstract void updateTrafficMask();

    @Override
    public long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public long getWrittenBytes() {
        return this.writtenBytes;
    }

    @Override
    public long getWrittenWriteRequests() {
        return this.writtenMessages;
    }

    @Override
    public long getReadMessages() {
        return this.readMessages;
    }

    @Override
    public long getWrittenMessages() {
        return this.writtenMessages;
    }

    @Override
    public int getScheduledWriteBytes() {
        return this.scheduledWriteBytes.get();
    }

    @Override
    public int getScheduledWriteRequests() {
        return this.scheduledWriteRequests.get();
    }

    public void increaseReadBytes(int increment) {
        if (increment > 0) {
            this.readBytes += (long)increment;
            this.lastReadTime = System.currentTimeMillis();
            this.idleCountForBoth = 0;
            this.idleCountForRead = 0;
        }
    }

    public void increaseWrittenBytes(int increment) {
        if (increment > 0) {
            this.writtenBytes += (long)increment;
            this.lastWriteTime = System.currentTimeMillis();
            this.idleCountForBoth = 0;
            this.idleCountForWrite = 0;
            this.scheduledWriteBytes.addAndGet(-increment);
        }
    }

    public void increaseReadMessages() {
        ++this.readMessages;
        this.lastReadTime = System.currentTimeMillis();
    }

    public void increaseWrittenMessages() {
        ++this.writtenMessages;
        this.lastWriteTime = System.currentTimeMillis();
        this.scheduledWriteRequests.decrementAndGet();
    }

    public void increaseScheduledWriteBytes(int increment) {
        this.scheduledWriteBytes.addAndGet(increment);
    }

    public void increaseScheduledWriteRequests() {
        this.scheduledWriteRequests.incrementAndGet();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    @Override
    public long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public boolean isIdle(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth > 0;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead > 0;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite > 0;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public int getIdleCount(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.idleCountForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.idleCountForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.idleCountForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    @Override
    public long getLastIdleTime(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            return this.lastIdleTimeForBoth;
        }
        if (status == IdleStatus.READER_IDLE) {
            return this.lastIdleTimeForRead;
        }
        if (status == IdleStatus.WRITER_IDLE) {
            return this.lastIdleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + status);
    }

    public void increaseIdleCount(IdleStatus status) {
        if (status == IdleStatus.BOTH_IDLE) {
            ++this.idleCountForBoth;
            this.lastIdleTimeForBoth = System.currentTimeMillis();
        } else if (status == IdleStatus.READER_IDLE) {
            ++this.idleCountForRead;
            this.lastIdleTimeForRead = System.currentTimeMillis();
        } else if (status == IdleStatus.WRITER_IDLE) {
            ++this.idleCountForWrite;
            this.lastIdleTimeForWrite = System.currentTimeMillis();
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + status);
        }
    }

    public String toString() {
        return "(" + this.getTransportType() + ", R: " + this.getRemoteAddress() + ", L: " + this.getLocalAddress() + ", S: " + this.getServiceAddress() + ')';
    }
}

