/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.collection.CollectionDataSerializerHook;
import com.hazelcast.collection.CollectionOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CollectionClearBackupOperation
extends CollectionOperation
implements BackupOperation {
    Set<Long> itemIdSet;

    public CollectionClearBackupOperation() {
    }

    public CollectionClearBackupOperation(String name, Set<Long> itemIdSet) {
        super(name);
        this.itemIdSet = itemIdSet;
    }

    @Override
    public int getId() {
        return CollectionDataSerializerHook.COLLECTION_CLEAR_BACKUP;
    }

    @Override
    public void beforeRun() throws Exception {
    }

    @Override
    public void run() throws Exception {
        this.getOrCreateContainer().clearBackup(this.itemIdSet);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.itemIdSet.size());
        for (Long itemId : this.itemIdSet) {
            out.writeLong(itemId);
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.itemIdSet = new HashSet<Long>(size);
        for (int i = 0; i < size; ++i) {
            this.itemIdSet.add(in.readLong());
        }
    }
}

