/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core;

import java.io.IOException;
import org.jrobin.core.Archive;
import org.jrobin.core.Header;
import org.jrobin.core.RrdAllocator;
import org.jrobin.core.RrdBackend;
import org.jrobin.core.RrdDouble;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdLong;
import org.jrobin.core.RrdUpdater;
import org.jrobin.core.Util;
import org.jrobin.core.XmlWriter;

public class ArcState
implements RrdUpdater {
    private Archive parentArc;
    private RrdDouble accumValue;
    private RrdLong nanSteps;

    ArcState(Archive archive, boolean bl) throws IOException {
        this.parentArc = archive;
        this.accumValue = new RrdDouble(this);
        this.nanSteps = new RrdLong(this);
        if (bl) {
            Header header = archive.getParentDb().getHeader();
            long l = header.getStep();
            long l2 = header.getLastUpdateTime();
            long l3 = archive.getArcStep();
            long l4 = (Util.normalize(l2, l) - Util.normalize(l2, l3)) / l;
            this.accumValue.set(Double.NaN);
            this.nanSteps.set(l4);
        }
    }

    String dump() throws IOException {
        return "accumValue:" + this.accumValue.get() + " nanSteps:" + this.nanSteps.get() + "\n";
    }

    void setNanSteps(long l) throws IOException {
        this.nanSteps.set(l);
    }

    public long getNanSteps() throws IOException {
        return this.nanSteps.get();
    }

    void setAccumValue(double d) throws IOException {
        this.accumValue.set(d);
    }

    public double getAccumValue() throws IOException {
        return this.accumValue.get();
    }

    public Archive getParent() {
        return this.parentArc;
    }

    void appendXml(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startTag("ds");
        xmlWriter.writeTag("value", this.accumValue.get());
        xmlWriter.writeTag("unknown_datapoints", this.nanSteps.get());
        xmlWriter.closeTag();
    }

    public void copyStateTo(RrdUpdater rrdUpdater) throws IOException, RrdException {
        if (!(rrdUpdater instanceof ArcState)) {
            throw new RrdException("Cannot copy ArcState object to " + rrdUpdater.getClass().getName());
        }
        ArcState arcState = (ArcState)rrdUpdater;
        arcState.accumValue.set(this.accumValue.get());
        arcState.nanSteps.set(this.nanSteps.get());
    }

    public RrdBackend getRrdBackend() {
        return this.parentArc.getRrdBackend();
    }

    public RrdAllocator getRrdAllocator() {
        return this.parentArc.getRrdAllocator();
    }
}

