/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CachePartitionSegment;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractOperation;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CacheReplicationOperation
extends AbstractOperation {
    Map<String, Map<Data, CacheRecord>> data = new HashMap<String, Map<Data, CacheRecord>>();
    List<CacheConfig> configs;

    public CacheReplicationOperation() {
        this.configs = new ArrayList<CacheConfig>();
    }

    public CacheReplicationOperation(CachePartitionSegment segment, int replicaIndex) {
        Iterator<ICacheRecordStore> iter = segment.cacheIterator();
        while (iter.hasNext()) {
            ICacheRecordStore next = iter.next();
            CacheConfig cacheConfig = next.getConfig();
            if (cacheConfig.getAsyncBackupCount() + cacheConfig.getBackupCount() < replicaIndex) continue;
            this.data.put(next.getName(), next.getReadOnlyRecords());
        }
        this.configs = new ArrayList<CacheConfig>();
        for (CacheConfig cacheConfig : segment.getCacheConfigs()) {
            this.configs.add(cacheConfig);
        }
    }

    @Override
    public void beforeRun() throws Exception {
        CacheService service = (CacheService)this.getService();
        for (CacheConfig config : this.configs) {
            service.createCacheConfigIfAbsent(config, true);
        }
    }

    @Override
    public void run() throws Exception {
        CacheService service = (CacheService)this.getService();
        for (Map.Entry<String, Map<Data, CacheRecord>> entry : this.data.entrySet()) {
            ICacheRecordStore cache = service.getOrCreateCache(entry.getKey(), this.getPartitionId());
            Map<Data, CacheRecord> map = entry.getValue();
            Iterator<Map.Entry<Data, CacheRecord>> iter = map.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<Data, CacheRecord> next = iter.next();
                Data key = next.getKey();
                CacheRecord record = next.getValue();
                iter.remove();
                cache.setRecord(key, record);
            }
        }
        this.data.clear();
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        int confSize = this.configs.size();
        out.writeInt(confSize);
        if (confSize > 0) {
            for (CacheConfig config : this.configs) {
                out.writeObject(config);
            }
        }
        int count = this.data.size();
        out.writeInt(count);
        if (count > 0) {
            long now = Clock.currentTimeMillis();
            for (Map.Entry<String, Map<Data, CacheRecord>> entry : this.data.entrySet()) {
                Map<Data, CacheRecord> cacheMap = entry.getValue();
                int subCount = cacheMap.size();
                out.writeInt(subCount);
                if (subCount <= 0) continue;
                out.writeUTF(entry.getKey());
                for (Map.Entry<Data, CacheRecord> e : cacheMap.entrySet()) {
                    Data key = e.getKey();
                    CacheRecord record = e.getValue();
                    long expirationTime = record.getExpirationTime();
                    if (expirationTime <= now) continue;
                    key.writeData(out);
                    out.writeObject(record);
                }
                new Data().writeData(out);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        int count;
        super.readInternal(in);
        int confSize = in.readInt();
        if (confSize > 0) {
            this.configs = new ArrayList<CacheConfig>();
            for (int i = 0; i < confSize; ++i) {
                CacheConfig config = (CacheConfig)in.readObject();
                this.configs.add(config);
            }
        }
        if ((count = in.readInt()) > 0) {
            block1: for (int i = 0; i < count; ++i) {
                int subCount = in.readInt();
                if (subCount <= 0) continue;
                String name = in.readUTF();
                HashMap<Data, CacheRecord> m = new HashMap<Data, CacheRecord>(subCount);
                this.data.put(name, m);
                for (int j = 0; j < subCount; ++j) {
                    Data key = new Data();
                    key.readData(in);
                    if (key.bufferSize() == 0) continue block1;
                    CacheRecord record = (CacheRecord)in.readObject();
                    m.put(key, record);
                }
            }
        }
    }

    public boolean isEmpty() {
        return !(this.configs != null && !this.configs.isEmpty() || this.data != null && !this.data.isEmpty());
    }
}

