/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.CacheStatistics;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class CacheStatisticsImpl
implements DataSerializable,
CacheStatistics {
    private static final float FLOAT_HUNDRED = 100.0f;
    private static final long NANOSECONDS_IN_A_MICROSECOND = 1000L;
    private final AtomicLong removals = new AtomicLong();
    private final AtomicLong expiries = new AtomicLong();
    private final AtomicLong puts = new AtomicLong();
    private final AtomicLong hits = new AtomicLong();
    private final AtomicLong misses = new AtomicLong();
    private final AtomicLong evictions = new AtomicLong();
    private final AtomicLong putTimeTakenNanos = new AtomicLong();
    private final AtomicLong getCacheTimeTakenNanos = new AtomicLong();
    private final AtomicLong removeTimeTakenNanos = new AtomicLong();

    @Override
    public long getCacheRemovals() {
        return this.removals.get();
    }

    public long getCacheExpiries() {
        return this.expiries.get();
    }

    @Override
    public long getCacheGets() {
        return this.getCacheHits() + this.getCacheMisses();
    }

    @Override
    public long getCachePuts() {
        return this.puts.get();
    }

    @Override
    public long getCacheHits() {
        return this.hits.get();
    }

    @Override
    public long getCacheMisses() {
        return this.misses.get();
    }

    @Override
    public long getCacheEvictions() {
        return this.evictions.get();
    }

    public long getCachePutTimeTakenNanos() {
        return this.putTimeTakenNanos.get();
    }

    public long getCacheGetTimeTakenNanos() {
        return this.getCacheTimeTakenNanos.get();
    }

    public long getCacheRemoveTimeTakenNanos() {
        return this.removeTimeTakenNanos.get();
    }

    @Override
    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        long cacheGets = this.getCacheGets();
        if (cacheHits == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return (float)cacheHits / (float)cacheGets * 100.0f;
    }

    @Override
    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        long cacheGets = this.getCacheGets();
        if (cacheMisses == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return (float)cacheMisses / (float)cacheGets * 100.0f;
    }

    @Override
    public float getAverageGetTime() {
        long cacheGetTimeTakenNanos = this.getCacheGetTimeTakenNanos();
        long cacheGets = this.getCacheGets();
        if (cacheGetTimeTakenNanos == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)cacheGetTimeTakenNanos / (float)cacheGets / 1000.0f;
    }

    @Override
    public float getAveragePutTime() {
        long cachePutTimeTakenNanos = this.getCachePutTimeTakenNanos();
        long cacheGets = this.getCacheGets();
        if (cachePutTimeTakenNanos == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)cachePutTimeTakenNanos / (float)cacheGets / 1000.0f;
    }

    @Override
    public float getAverageRemoveTime() {
        long cacheRemoveTimeTakenNanos = this.getCacheRemoveTimeTakenNanos();
        long cacheGets = this.getCacheGets();
        if (cacheRemoveTimeTakenNanos == 0L || cacheGets == 0L) {
            return 0.0f;
        }
        return 1.0f * (float)cacheRemoveTimeTakenNanos / (float)cacheGets / 1000.0f;
    }

    public void clear() {
        this.puts.set(0L);
        this.misses.set(0L);
        this.removals.set(0L);
        this.expiries.set(0L);
        this.hits.set(0L);
        this.evictions.set(0L);
        this.getCacheTimeTakenNanos.set(0L);
        this.putTimeTakenNanos.set(0L);
        this.removeTimeTakenNanos.set(0L);
    }

    public void increaseCacheRemovals(long number) {
        this.removals.getAndAdd(number);
    }

    public void increaseCacheExpiries(long number) {
        this.expiries.getAndAdd(number);
    }

    public void increaseCachePuts(long number) {
        this.puts.getAndAdd(number);
    }

    public void increaseCacheHits(long number) {
        this.hits.getAndAdd(number);
    }

    public void increaseCacheMisses(long number) {
        this.misses.getAndAdd(number);
    }

    public void increaseCacheEvictions(long number) {
        this.evictions.getAndAdd(number);
    }

    public void addGetTimeNano(long duration) {
        if (this.getCacheTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.getCacheTimeTakenNanos.addAndGet(duration);
        } else {
            this.clear();
            this.getCacheTimeTakenNanos.set(duration);
        }
    }

    public void addPutTimeNano(long duration) {
        if (this.putTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.putTimeTakenNanos.addAndGet(duration);
        } else {
            this.clear();
            this.putTimeTakenNanos.set(duration);
        }
    }

    public void addRemoveTimeNano(long duration) {
        if (this.removeTimeTakenNanos.get() <= Long.MAX_VALUE - duration) {
            this.removeTimeTakenNanos.addAndGet(duration);
        } else {
            this.clear();
            this.removeTimeTakenNanos.set(duration);
        }
    }

    public CacheStatisticsImpl accumulate(CacheStatisticsImpl other) {
        this.puts.addAndGet(other.getCachePuts());
        this.removals.addAndGet(other.getCacheRemovals());
        this.expiries.addAndGet(other.getCacheExpiries());
        this.evictions.addAndGet(other.getCacheEvictions());
        this.hits.addAndGet(other.getCacheHits());
        this.misses.addAndGet(other.getCacheMisses());
        this.putTimeTakenNanos.addAndGet(other.getCachePutTimeTakenNanos());
        this.getCacheTimeTakenNanos.addAndGet(other.getCacheGetTimeTakenNanos());
        this.removeTimeTakenNanos.addAndGet(other.getCacheRemoveTimeTakenNanos());
        return this;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.puts.get());
        out.writeLong(this.removals.get());
        out.writeLong(this.expiries.get());
        out.writeLong(this.evictions.get());
        out.writeLong(this.hits.get());
        out.writeLong(this.misses.get());
        out.writeLong(this.putTimeTakenNanos.get());
        out.writeLong(this.getCacheTimeTakenNanos.get());
        out.writeLong(this.removeTimeTakenNanos.get());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.puts.set(in.readLong());
        this.removals.set(in.readLong());
        this.expiries.set(in.readLong());
        this.evictions.set(in.readLong());
        this.hits.set(in.readLong());
        this.misses.set(in.readLong());
        this.putTimeTakenNanos.set(in.readLong());
        this.getCacheTimeTakenNanos.set(in.readLong());
        this.removeTimeTakenNanos.set(in.readLong());
    }
}

