/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.StreamPumper;

public class PumpStreamHandler
implements ExecuteStreamHandler {
    private Thread outputThread;
    private Thread errorThread;
    private Thread inputThread;
    private OutputStream out;
    private OutputStream err;
    private InputStream input;

    public void setProcessOutputStream(InputStream inputStream) {
        this.createProcessOutputPump(inputStream, this.out);
    }

    public void setProcessErrorStream(InputStream inputStream) {
        if (this.err != null) {
            this.createProcessErrorPump(inputStream, this.err);
        }
    }

    public void setProcessInputStream(OutputStream outputStream) {
        if (this.input != null) {
            this.inputThread = this.createPump(this.input, outputStream, true);
        } else {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void start() {
        this.outputThread.start();
        this.errorThread.start();
        if (this.inputThread != null) {
            this.inputThread.start();
        }
    }

    public void stop() {
        try {
            this.outputThread.join();
        }
        catch (InterruptedException interruptedException) {}
        try {
            this.errorThread.join();
        }
        catch (InterruptedException interruptedException) {}
        if (this.inputThread != null) {
            try {
                this.inputThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.err.flush();
        }
        catch (IOException iOException) {}
        try {
            this.out.flush();
        }
        catch (IOException iOException) {}
    }

    protected OutputStream getErr() {
        return this.err;
    }

    protected OutputStream getOut() {
        return this.out;
    }

    protected void createProcessOutputPump(InputStream inputStream, OutputStream outputStream) {
        this.outputThread = this.createPump(inputStream, outputStream);
    }

    protected void createProcessErrorPump(InputStream inputStream, OutputStream outputStream) {
        this.errorThread = this.createPump(inputStream, outputStream);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream) {
        return this.createPump(inputStream, outputStream, false);
    }

    protected Thread createPump(InputStream inputStream, OutputStream outputStream, boolean bl) {
        Thread thread = new Thread(new StreamPumper(inputStream, outputStream, bl));
        thread.setDaemon(true);
        return thread;
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2, InputStream inputStream) {
        this.out = outputStream;
        this.err = outputStream2;
        this.input = inputStream;
    }

    public PumpStreamHandler(OutputStream outputStream, OutputStream outputStream2) {
        this(outputStream, outputStream2, null);
    }

    public PumpStreamHandler(OutputStream outputStream) {
        this(outputStream, outputStream);
    }

    public PumpStreamHandler() {
        this(System.out, System.err);
    }
}

