/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.baseparser;

import java.io.IOException;
import org.xml.sax.SAXException;
import weblogic.utils.UnsyncStringBuffer;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.Element;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.Token;

public class Attribute
extends Element {
    UnsyncStringBuffer value;
    boolean isXMLNS;
    boolean declaresDefaultNameSpace;
    private int type = 11;

    public void init() {
        super.init();
        this.value = new UnsyncStringBuffer();
        this.isXMLNS = false;
        this.declaresDefaultNameSpace = false;
    }

    /*
     * Unable to fully structure code
     */
    public void parse(BaseParser var1_1) throws IOException, ScannerException, ParseException {
        this.init();
        switch (var1_1.currentToken.tokenType) {
            case 18: {
                this.prefix = var1_1.currentToken.text;
                if (this.isNameSpace(this.prefix)) {
                    this.isXMLNS = true;
                }
                var1_1.accept();
                this.name = var1_1.currentToken.text;
                var1_1.accept(0);
                ** GOTO lbl35
            }
            case 0: {
                this.name = var1_1.currentToken.text;
                if (this.isNameSpace(this.name)) {
                    this.declaresDefaultNameSpace = true;
                }
                var1_1.accept();
                if (true) ** GOTO lbl35
            }
            default: {
                throw new ParseException("Expected a NAME", var1_1.getLine(), var1_1.currentToken);
            }
        }
        do {
            if (var1_1.compare(15)) {
                this.value.append(var1_1.currentToken.text);
            } else if (var1_1.compare(14)) {
                this.value.append(this.normalizeReferenceSpace(var1_1.currentToken.text));
            } else if (var1_1.compare(19)) {
                this.value.append(" ");
            } else {
                this.value.append(var1_1.currentToken.textArray, var1_1.currentToken.start, var1_1.currentToken.length);
            }
            var1_1.accept();
lbl35:
            // 3 sources

        } while (var1_1.compare(13) || var1_1.compare(14) || var1_1.compare(15) || var1_1.compare(19));
        try {
            if (this.isXMLNS) {
                var1_1.putNamespaceURI(this.name, this.value.toString());
            }
            if (this.declaresDefaultNameSpace) {
                var1_1.setDefaultNameSpace(this.value.toString());
            }
        }
        catch (SAXException var2_2) {
            throw new ParseException(var2_2.getMessage());
        }
    }

    private String normalizeReferenceSpace(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            cArray2[n] = cArray[n] == '\t' || cArray[n] == '\r' || cArray[n] == '\n' ? 32 : cArray[n];
            ++n;
        }
        return new String(cArray2);
    }

    public String normalizeSpace(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n && cArray[n3] == ' ') {
            ++n3;
        }
        while (n3 < n) {
            boolean bl = false;
            while (n3 < n && cArray[n3] == ' ') {
                ++n3;
                bl = true;
            }
            if (bl) {
                cArray2[n2] = 32;
            } else {
                cArray2[n2] = cArray[n3];
                ++n3;
            }
            ++n2;
        }
        if (n2 > 0) {
            while (cArray2[n2 - 1] == ' ') {
                --n2;
            }
        }
        return new String(cArray2, 0, n2);
    }

    boolean isNameSpace(String string) {
        if (string == null) {
            return false;
        }
        if (string.equals("")) {
            return false;
        }
        return string.equals("xmlns");
    }

    public boolean isNameSpaceDeclaration() {
        return this.isXMLNS;
    }

    public boolean declaresDefaultNameSpace() {
        return this.declaresDefaultNameSpace;
    }

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public void setValue(String string) {
        this.value.setLength(0);
        this.value.append(string);
    }

    public String getValue() {
        return this.value.toString();
    }

    protected boolean setNameSpace(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        if (!this.isXMLNS && !this.declaresDefaultNameSpace) {
            return super.setNameSpace(baseParser);
        }
        return false;
    }

    public String toString() {
        return " " + this.getName() + "[" + Token.getString(this.type) + "]=" + "\"" + this.value + "\"";
    }
}

