/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ratelim;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.ratelim.QueueRunner;
import net.kano.joscar.ratelim.RateClassMonitor;
import net.kano.joscar.ratelim.RateLimitingEventQueue;
import net.kano.joscar.ratelim.RateLimitingQueueMgr;
import net.kano.joscar.ratelim.RateListener;
import net.kano.joscar.ratelim.RateMonitor;
import net.kano.joscar.ratelim.RateQueue;
import net.kano.joscar.snac.ClientSnacProcessor;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacRequest;
import net.kano.joscar.snaccmd.conn.RateClassInfo;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConnectionQueueMgr {
    private final RateLimitingQueueMgr queueMgr;
    private final RateMonitor monitor;
    private final ClientSnacProcessor snacProcessor;
    private boolean paused = false;
    private final Map<RateClassMonitor, RateQueue> queues = new IdentityHashMap<RateClassMonitor, RateQueue>();
    private RateListener rateListener = new RateListener(){

        public void detached(RateMonitor rateMonitor, ClientSnacProcessor processor) {
            rateMonitor.removeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset(RateMonitor rateMonitor) {
            ConnectionQueueMgr connectionQueueMgr = ConnectionQueueMgr.this;
            synchronized (connectionQueueMgr) {
                ConnectionQueueMgr.this.clearQueues();
            }
        }

        public void gotRateClasses(RateMonitor monitor) {
            ConnectionQueueMgr.this.updateRateClasses();
        }

        public void rateClassUpdated(RateMonitor monitor, RateClassMonitor classMonitor, RateClassInfo rateInfo) {
            ConnectionQueueMgr.this.queueMgr.getRunner().update();
        }

        public void rateClassLimited(RateMonitor rateMonitor, RateClassMonitor rateClassMonitor, boolean limited) {
            ConnectionQueueMgr.this.queueMgr.getRunner().update();
        }
    };

    ConnectionQueueMgr(RateLimitingQueueMgr queueMgr, ClientSnacProcessor processor) {
        DefensiveTools.checkNull((Object)queueMgr, (String)"queueMgr");
        DefensiveTools.checkNull((Object)processor, (String)"processor");
        this.queueMgr = queueMgr;
        this.monitor = new RateMonitor(processor);
        this.snacProcessor = processor;
        this.monitor.addListener(this.rateListener);
    }

    public RateLimitingQueueMgr getParentQueueMgr() {
        return this.queueMgr;
    }

    public RateMonitor getRateMonitor() {
        return this.monitor;
    }

    public ClientSnacProcessor getSnacProcessor() {
        return this.snacProcessor;
    }

    private synchronized RateQueue getRateQueue(RateClassMonitor classMonitor) {
        DefensiveTools.checkNull((Object)classMonitor, (String)"classMonitor");
        return this.queues.get(classMonitor);
    }

    @Nullable
    public synchronized RateQueue getRateQueue(CmdType type) {
        DefensiveTools.checkNull((Object)type, (String)"type");
        RateClassMonitor cm = this.monitor.getMonitor(type);
        if (cm == null) {
            return null;
        }
        return this.getRateQueue(cm);
    }

    void queueSnac(SnacRequest request) {
        DefensiveTools.checkNull((Object)request, (String)"request");
        CmdType type = CmdType.ofCmd(request.getCommand());
        RateQueue queue = this.getRateQueue(type);
        if (queue == null) {
            this.queueMgr.sendSnac(this.snacProcessor, request);
        } else {
            queue.enqueue(request);
            this.queueMgr.getRunner().update();
        }
    }

    synchronized void clearQueue() {
        for (RateQueue queue : this.queues.values()) {
            queue.clear();
        }
        this.paused = false;
    }

    synchronized void pause() {
        assert (!this.paused);
        this.paused = true;
    }

    synchronized void unpause() {
        assert (this.paused);
        this.paused = false;
        this.queueMgr.getRunner().update();
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    private synchronized void updateRateClasses() {
        List<RateClassMonitor> monitors = this.monitor.getMonitors();
        Collection<RateQueue> queueArray = this.clearQueues();
        LinkedList reqs = new LinkedList();
        for (RateQueue queue : queueArray) {
            queue.dequeueAll(reqs);
        }
        for (RateClassMonitor monitor : monitors) {
            this.queues.put(monitor, new RateQueue(this, monitor));
        }
        for (SnacRequest req : reqs) {
            this.queueSnac(req);
        }
        QueueRunner<RateLimitingEventQueue> runner = this.queueMgr.getRunner();
        runner.getQueue().addQueues(this.queues.values());
    }

    private synchronized Collection<RateQueue> clearQueues() {
        Collection<RateQueue> vals = this.queues.values();
        this.queueMgr.getRunner().getQueue().removeQueues(vals);
        this.queues.clear();
        return DefensiveTools.getUnmodifiableCopy(vals);
    }

    synchronized void detach() {
        this.clearQueue();
        this.clearQueues();
        this.monitor.detach();
    }

    public String toString() {
        return "ConnectionQueueMgr: paused=" + this.paused + ", queues=" + this.queues.keySet();
    }
}

