/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.InstallerUtil;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.util.ButtonUtil;
import com.install4j.runtime.util.DisplayTextArea;
import com.install4j.runtime.util.FileResourceBundle;
import com.install4j.runtime.util.KeyboardUtil;
import com.install4j.runtime.wizard.WizardBase;
import com.install4j.runtime.wizard.WizardScreen;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class BaseScreen
extends WizardScreen
implements ActionListener {
    private static final Icon ICON_TOP = GUIHelper.loadIcon("install4j.png");
    protected static final Insets BORDER_PANEL_INSETS = new Insets(3, 3, 3, 3);
    protected static final int HORIZONTAL_BUTTON_SPACER = 5;
    private static final Icon ICON_WIZARD = GUIHelper.loadIcon("wizard.png");
    protected JButton btnPrevious;
    protected JButton btnForward;
    protected JButton btnCancel;
    protected List revalidationComponents;
    protected FileResourceBundle messages;
    protected static final Color DEFAULT_BANNER_BACKGROUND = new Color(28, 30, 144);

    public BaseScreen(WizardBase wizardBase) {
        super(wizardBase);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        WizardBase wizardBase = this.getWizardBase();
        Object object = actionEvent.getSource();
        if (object == this.btnPrevious) {
            wizardBase.previousScreen();
        } else if (object == this.btnForward) {
            if (this.checkCompleted()) {
                wizardBase.nextScreen();
            }
        } else if (object == this.btnCancel) {
            this.cancel();
        }
    }

    protected void initScreen() {
        this.messages = Messages.getMessages();
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    protected void setupControls() {
        this.revalidationComponents = new ArrayList();
        this.btnPrevious = new JButton("< " + this.messages.getString("ButtonBack"));
        this.btnForward = new JButton(this.messages.getString("ButtonNext") + " >");
        this.btnCancel = new JButton(this.messages.getString("ButtonCancel"));
    }

    protected void setupComponent() {
        JComponent jComponent;
        Object object;
        JPanel jPanel;
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        if (this.isBannerPainted()) {
            jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(true);
            jPanel.setBackground(this.getBannerBackground());
            object = this.getBannerIcon();
            jComponent = new JLabel((Icon)object);
            jPanel.add((Component)jComponent, "North");
            jPanel2.add((Component)jPanel, "West");
            jPanel.setPreferredSize(new Dimension(object.getIconWidth(), 0));
            this.add((Component)jPanel, "West");
        } else {
            this.add((Component)this.createTitlePanel(), "North");
        }
        jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 5));
        object = new GridBagConstraints();
        ((GridBagConstraints)object).gridy = 0;
        ((GridBagConstraints)object).gridx = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        this.add((Component)jPanel, "Center");
        ((GridBagConstraints)object).gridwidth = this.getMaxGridWidth();
        ((GridBagConstraints)object).fill = 2;
        ((GridBagConstraints)object).anchor = 18;
        if (this.isBannerPainted()) {
            ((GridBagConstraints)object).insets = new Insets(5, 0, 0, 5);
            jPanel.setBackground(Color.white);
            jPanel.setOpaque(true);
        } else {
            ((GridBagConstraints)object).insets = new Insets(5, 15, 0, 20);
        }
        if (this.isBannerPainted()) {
            jPanel.add((Component)this.createTitleLabel(4, true, this.getTitle()), object);
            ++((GridBagConstraints)object).gridy;
            jPanel.add((Component)this.createSeparator(), object);
            ++((GridBagConstraints)object).gridy;
        }
        this.addScreenContent(jPanel, (GridBagConstraints)object);
        if (this.needsSpacer()) {
            ((GridBagConstraints)object).weighty = 1.0;
            ((GridBagConstraints)object).fill = 1;
            jComponent = new JPanel();
            jComponent.setBackground(jPanel.getBackground());
            jComponent.setOpaque(jPanel.isOpaque());
            jPanel.add((Component)jComponent, object);
            ++((GridBagConstraints)object).gridy;
        }
        jComponent = this.createNavigationPanel(this.createButtonBox(), true);
        this.add((Component)jComponent, "South");
    }

    protected String getApplicationName() {
        return InstallerConfig.getCurrentInstance().getApplicationName();
    }

    protected Color getBannerBackground() {
        return DEFAULT_BANNER_BACKGROUND;
    }

    protected String getBannerIconFileName() {
        return null;
    }

    protected void setupEventHandlers() {
        this.btnPrevious.addActionListener(this);
        this.btnForward.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Iterator iterator = BaseScreen.this.revalidationComponents.iterator();
                while (iterator.hasNext()) {
                    ((Component)iterator.next()).invalidate();
                }
                BaseScreen.this.validate();
            }
        });
        KeyboardUtil.addAccelerator(1, this.btnCancel, this, this, 27, 0);
        if (this.btnForward.isEnabled()) {
            KeyboardUtil.addAccelerator(1, this.btnForward, this, this, 39, 8);
        }
        if (this.btnPrevious.isEnabled()) {
            KeyboardUtil.addAccelerator(1, this.btnPrevious, this, this, 37, 8);
        }
    }

    protected boolean isBannerPainted() {
        return false;
    }

    protected int getMaxGridWidth() {
        return 1;
    }

    protected boolean needsSpacer() {
        return true;
    }

    protected Box createButtonBox() {
        Box box = ButtonUtil.createHorizontalButtonBox(new Component[]{this.btnPrevious, this.btnForward}, 0);
        Box box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalGlue());
        box2.add(box);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.btnCancel);
        return box2;
    }

    protected abstract void addScreenContent(JPanel var1, GridBagConstraints var2);

    protected abstract String getTitle();

    protected abstract String getSubTitle();

    protected boolean checkCompleted() {
        return true;
    }

    protected void addDisplayTextArea(String string, JPanel jPanel, GridBagConstraints gridBagConstraints) {
        int n = gridBagConstraints.fill;
        double d = gridBagConstraints.weightx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DisplayTextArea displayTextArea = new DisplayTextArea();
        displayTextArea.setText(string);
        jPanel.add((Component)displayTextArea, gridBagConstraints);
        this.revalidationComponents.add(displayTextArea);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = n;
        gridBagConstraints.weightx = d;
    }

    protected void addComponentWithHeader(JComponent jComponent, JComponent jComponent2, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 15;
        this.add((Component)jComponent2, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
    }

    protected JPanel createBorderPanel(String string, LayoutManager layoutManager) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), string));
        if (layoutManager != null) {
            jPanel.setLayout(layoutManager);
        }
        return jPanel;
    }

    protected Insets getBorderPanelInsets() {
        return (Insets)BORDER_PANEL_INSETS.clone();
    }

    protected void cancel() {
        this.getWizardBase().quit();
    }

    private JPanel createTitlePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(Color.white);
        jPanel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 15, 0, 15);
        DisplayTextArea displayTextArea = this.createTitleLabel(0, true, this.getTitle());
        jPanel.add((Component)displayTextArea, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 25, 0, 15);
        DisplayTextArea displayTextArea2 = this.createTitleLabel(0, false, this.getSubTitle());
        jPanel.add((Component)displayTextArea2, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)new JLabel(this.getHeaderIcon()), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.createSeparator(), gridBagConstraints);
        return jPanel;
    }

    private DisplayTextArea createTitleLabel(int n, boolean bl, String string) {
        DisplayTextArea displayTextArea = new DisplayTextArea();
        displayTextArea.setText(string);
        Font font = displayTextArea.getFont();
        if (bl) {
            Font font2 = new Font("Dialog", 1, font.getSize() + n);
            displayTextArea.setFont(font2);
        }
        this.revalidationComponents.add(displayTextArea);
        return displayTextArea;
    }

    private Icon getBannerIcon() {
        Icon icon = ICON_WIZARD;
        String string = this.getBannerIconFileName();
        if (string != null) {
            try {
                icon = new ImageIcon(InstallerUtil.getInstallerFile(string).getPath());
                if (icon.getIconWidth() <= 0) {
                    return ICON_WIZARD;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return icon;
    }

    private Icon getHeaderIcon() {
        Icon icon = ICON_TOP;
        try {
            icon = new ImageIcon(InstallerUtil.getInstallerFile("header.png").getPath());
            if (icon.getIconWidth() <= 0) {
                return ICON_TOP;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return icon;
    }
}

