/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.AntlibDefinition;
import org.apache.tools.ant.taskdefs.MacroInstance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MacroDef
extends AntlibDefinition {
    private NestedSequential nestedSequential;
    private String name;
    private List attributes;
    private Map elements;
    private String textName;
    private Text text;
    private boolean hasImplicitElement;
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$MacroInstance;

    public void setName(String string) {
        this.name = string;
    }

    public void addConfiguredText(Text text) {
        if (this.text != null) {
            throw new BuildException("Only one nested text element allowed");
        }
        if (text.getName() == null) {
            throw new BuildException("the text nested element needed a \"name\" attribute");
        }
        Iterator iterator = this.attributes.iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            if (!text.getName().equals(attribute.getName())) continue;
            throw new BuildException("the name \"" + text.getName() + "\" is already used as an attribute");
        }
        this.text = text;
        this.textName = text.getName();
    }

    public Text getText() {
        return this.text;
    }

    public NestedSequential createSequential() {
        if (this.nestedSequential != null) {
            throw new BuildException("Only one sequential allowed");
        }
        this.nestedSequential = new NestedSequential();
        return this.nestedSequential;
    }

    public UnknownElement getNestedTask() {
        UnknownElement unknownElement = new UnknownElement("sequential");
        unknownElement.setTaskName("sequential");
        unknownElement.setNamespace("");
        unknownElement.setQName("sequential");
        new RuntimeConfigurable(unknownElement, "sequential");
        int n = 0;
        while (n < this.nestedSequential.getNested().size()) {
            UnknownElement unknownElement2 = (UnknownElement)this.nestedSequential.getNested().get(n);
            unknownElement.addChild(unknownElement2);
            unknownElement.getWrapper().addChild(unknownElement2.getWrapper());
            ++n;
        }
        return unknownElement;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Map getElements() {
        return this.elements;
    }

    public static boolean isValidNameCharacter(char c) {
        boolean bl = false;
        if (Character.isLetterOrDigit(c) || c == '.' || c == '-') {
            bl = true;
        }
        return bl;
    }

    private static final boolean isValidName(String string) {
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!MacroDef.isValidNameCharacter(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void addConfiguredAttribute(Attribute attribute) {
        if (attribute.getName() == null) {
            throw new BuildException("the attribute nested element needed a \"name\" attribute");
        }
        if (attribute.getName().equals(this.textName)) {
            throw new BuildException("the attribute name \"" + attribute.getName() + "\" has already been used by the text element");
        }
        int n = 0;
        while (n < this.attributes.size()) {
            if (((Attribute)this.attributes.get(n)).getName().equals(attribute.getName())) {
                throw new BuildException("the attribute " + attribute.getName() + " has already been specified");
            }
            ++n;
        }
        this.attributes.add(attribute);
    }

    public void addConfiguredElement(TemplateElement templateElement) {
        if (templateElement.getName() == null) {
            throw new BuildException("the element nested element needed a \"name\" attribute");
        }
        if (this.elements.get(templateElement.getName()) != null) {
            throw new BuildException("the element " + templateElement.getName() + " has already been specified");
        }
        if (this.hasImplicitElement || templateElement.isImplicit() && this.elements.size() != 0) {
            throw new BuildException("Only one element allowed when using implicit elements");
        }
        this.hasImplicitElement = templateElement.isImplicit();
        this.elements.put(templateElement.getName(), templateElement);
    }

    public void execute() {
        if (this.nestedSequential == null) {
            throw new BuildException("Missing sequential element");
        }
        if (this.name == null) {
            throw new BuildException("Name not specified");
        }
        this.name = ProjectHelper.genComponentName(this.getURI(), this.name);
        MyAntTypeDefinition myAntTypeDefinition = new MyAntTypeDefinition(this);
        myAntTypeDefinition.setName(this.name);
        Class clazz = class$org$apache$tools$ant$taskdefs$MacroInstance;
        if (clazz == null) {
            clazz = class$org$apache$tools$ant$taskdefs$MacroInstance = MacroDef.class("[Lorg.apache.tools.ant.taskdefs.MacroInstance;", false);
        }
        myAntTypeDefinition.setClass(clazz);
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.getProject());
        componentHelper.addDataTypeDefinition(myAntTypeDefinition);
    }

    public boolean similar(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        MacroDef macroDef = (MacroDef)object;
        if (this.name == null) {
            boolean bl = false;
            if (macroDef.name == null) {
                bl = true;
            }
            return bl;
        }
        if (!this.name.equals(macroDef.name)) {
            return false;
        }
        if (this.text == null ? macroDef.text != null : !this.text.equals(macroDef.text)) {
            return false;
        }
        if (this.getURI() == null || this.getURI().equals("") || this.getURI().equals("antlib:org.apache.tools.ant") ? macroDef.getURI() != null && !macroDef.getURI().equals("") && !macroDef.getURI().equals("antlib:org.apache.tools.ant") : !this.getURI().equals(macroDef.getURI())) {
            return false;
        }
        if (!this.nestedSequential.similar(macroDef.nestedSequential)) {
            return false;
        }
        if (!this.attributes.equals(macroDef.attributes)) {
            return false;
        }
        return this.elements.equals(macroDef.elements);
    }

    private static final int objectHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.attributes = new ArrayList();
        this.elements = new HashMap();
        this.textName = null;
        this.text = null;
        this.hasImplicitElement = false;
    }

    public MacroDef() {
        this.this();
    }

    public static class Text {
        private String name;
        private boolean optional;
        private boolean trim;
        private String description;

        public void setName(String string) {
            if (!MacroDef.isValidName(string)) {
                throw new BuildException("Illegal name [" + string + "] for attribute");
            }
            this.name = string.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public void setOptional(boolean bl) {
            this.optional = bl;
        }

        public boolean getOptional() {
            return this.optional;
        }

        public void setTrim(boolean bl) {
            this.trim = bl;
        }

        public boolean getTrim() {
            return this.trim;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Text text = (Text)object;
            if (this.name == null ? text.name != null : !this.name.equals(text.name)) {
                return false;
            }
            if (this.optional != text.optional) {
                return false;
            }
            return this.trim == text.trim;
        }

        public int hashCode() {
            return MacroDef.objectHashCode(this.name);
        }
    }

    public static class Attribute {
        private String name;
        private String defaultValue;
        private String description;

        public void setName(String string) {
            if (!MacroDef.isValidName(string)) {
                throw new BuildException("Illegal name [" + string + "] for attribute");
            }
            this.name = string.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public void setDefault(String string) {
            this.defaultValue = string;
        }

        public String getDefault() {
            return this.defaultValue;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)object;
            if (this.name == null ? attribute.name != null : !this.name.equals(attribute.name)) {
                return false;
            }
            return !(this.defaultValue == null ? attribute.defaultValue != null : !this.defaultValue.equals(attribute.defaultValue));
        }

        public int hashCode() {
            return MacroDef.objectHashCode(this.defaultValue) + MacroDef.objectHashCode(this.name);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class NestedSequential
    implements TaskContainer {
        private List nested;

        public void addTask(Task task) {
            this.nested.add(task);
        }

        public List getNested() {
            return this.nested;
        }

        public boolean similar(NestedSequential nestedSequential) {
            if (this.nested.size() != nestedSequential.nested.size()) {
                return false;
            }
            int n = 0;
            while (n < this.nested.size()) {
                UnknownElement unknownElement;
                UnknownElement unknownElement2 = (UnknownElement)this.nested.get(n);
                if (!unknownElement2.similar(unknownElement = (UnknownElement)nestedSequential.nested.get(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        private final /* synthetic */ void this() {
            this.nested = new ArrayList();
        }

        public NestedSequential() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TemplateElement {
        private String name;
        private boolean optional;
        private boolean implicit;
        private String description;

        public void setName(String string) {
            if (!MacroDef.isValidName(string)) {
                throw new BuildException("Illegal name [" + string + "] for attribute");
            }
            this.name = string.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public void setOptional(boolean bl) {
            this.optional = bl;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setImplicit(boolean bl) {
            this.implicit = bl;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            TemplateElement templateElement = (TemplateElement)object;
            if (this.name == null ? templateElement.name != null : !this.name.equals(templateElement.name)) {
                return false;
            }
            boolean bl = false;
            if (this.optional == templateElement.optional && this.implicit == templateElement.implicit) {
                bl = true;
            }
            return bl;
        }

        public int hashCode() {
            return MacroDef.objectHashCode(this.name) + this.optional + this.implicit;
        }

        private final /* synthetic */ void this() {
            this.optional = false;
            this.implicit = false;
        }

        public TemplateElement() {
            this.this();
        }
    }

    private static class MyAntTypeDefinition
    extends AntTypeDefinition {
        private MacroDef macroDef;

        public Object create(Project project) {
            Object object = super.create(project);
            if (object == null) {
                return null;
            }
            ((MacroInstance)object).setMacroDef(this.macroDef);
            return object;
        }

        public boolean sameDefinition(AntTypeDefinition antTypeDefinition, Project project) {
            if (!super.sameDefinition(antTypeDefinition, project)) {
                return false;
            }
            MyAntTypeDefinition myAntTypeDefinition = (MyAntTypeDefinition)antTypeDefinition;
            return this.macroDef.similar(myAntTypeDefinition.macroDef);
        }

        public boolean similarDefinition(AntTypeDefinition antTypeDefinition, Project project) {
            if (!super.similarDefinition(antTypeDefinition, project)) {
                return false;
            }
            MyAntTypeDefinition myAntTypeDefinition = (MyAntTypeDefinition)antTypeDefinition;
            return this.macroDef.similar(myAntTypeDefinition.macroDef);
        }

        public MyAntTypeDefinition(MacroDef macroDef) {
            this.macroDef = macroDef;
        }
    }
}

