/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.iobalancer;

import com.hazelcast.nio.tcp.MigratableHandler;
import com.hazelcast.nio.tcp.iobalancer.LoadImbalance;
import com.hazelcast.nio.tcp.iobalancer.MigrationStrategy;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;

class MonkeyMigrationStrategy
implements MigrationStrategy {
    private final Random random = new Random();

    MonkeyMigrationStrategy() {
    }

    @Override
    public boolean imbalanceDetected(LoadImbalance imbalance) {
        Set<MigratableHandler> candidates = imbalance.getHandlersOwnerBy(imbalance.sourceSelector);
        return candidates.size() > 0;
    }

    @Override
    public MigratableHandler findHandlerToMigrate(LoadImbalance imbalance) {
        Set<MigratableHandler> candidates = imbalance.getHandlersOwnerBy(imbalance.sourceSelector);
        int handlerCount = candidates.size();
        int selected = this.random.nextInt(handlerCount);
        Iterator<MigratableHandler> iterator = candidates.iterator();
        for (int i = 0; i < selected; ++i) {
            iterator.next();
        }
        return iterator.next();
    }
}

