/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.utils;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Vector;
import sun.misc.SoftCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLocale {
    private static final ResourceCacheKey cacheKey = new ResourceCacheKey();
    private static final int INITIAL_CACHE_SIZE = 25;
    private static final float CACHE_LOAD_FACTOR = 1.0f;
    private static final int MAX_RESOURCES_SEARCHED = 3;
    private static final Hashtable<ResourceCacheKey, Thread> underConstruction = new Hashtable(3, 1.0f);
    private static final ResourceLocale NOT_FOUND = new ResourceLocale(null);
    private static SoftCache cacheList = new SoftCache(25, 1.0f);
    private static ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
    protected ResourceLocale parent = null;
    private Locale locale = null;
    private final byte[] content;

    public ResourceLocale(byte[] content) {
        this.content = content;
    }

    public final String getAsString() {
        return new String(this.getBytes());
    }

    public final byte[] getBytes() {
        byte[] bytes = this.content;
        if (bytes == null && this.parent != null) {
            bytes = this.parent.getBytes();
        }
        return bytes;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private void setLocale(String baseName, String resourceName) {
        if (baseName.length() == resourceName.length()) {
            this.locale = new Locale("", "");
        } else if (baseName.length() < resourceName.length()) {
            int pos = baseName.length();
            String temp = resourceName.substring(pos + 1);
            if ((pos = temp.indexOf(95)) == -1) {
                this.locale = new Locale(temp, "", "");
                return;
            }
            String language = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf(95)) == -1) {
                this.locale = new Locale(language, temp, "");
                return;
            }
            String country = temp.substring(0, pos);
            temp = temp.substring(pos + 1);
            this.locale = new Locale(language, country, temp);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static ClassLoader getLoader() {
        ClassLoader cl;
        Class<Object>[] stack = ResourceLocale.getClassContext();
        Class<Object> c = stack[2];
        ClassLoader classLoader = cl = c == null ? null : c.getClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    private static native Class<Object>[] getClassContext();

    protected void setParent(ResourceLocale parent) {
        this.parent = parent;
    }

    public static final ResourceLocale getResource(String baseName) {
        return ResourceLocale.getResourceLocale(baseName, Locale.getDefault(), ResourceLocale.getLoader());
    }

    public static final ResourceLocale getResource(String baseName, Locale locale) {
        return ResourceLocale.getResourceLocale(baseName, locale, ResourceLocale.getLoader());
    }

    public static ResourceLocale getResource(String baseName, Locale locale, ClassLoader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        return ResourceLocale.getResourceLocale(baseName, locale, loader);
    }

    private static ResourceLocale getResourceLocale(String baseName, Locale locale, ClassLoader loader) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        String resourceName = baseName;
        String localeSuffix = locale.toString();
        if (localeSuffix.length() > 0) {
            resourceName = resourceName + "_" + localeSuffix;
        } else if (locale.getVariant().length() > 0) {
            resourceName = resourceName + "___" + locale.getVariant();
        }
        Locale defaultLocale = Locale.getDefault();
        ResourceLocale lookup = ResourceLocale.findResourceInCache(loader, resourceName, defaultLocale);
        if (lookup == NOT_FOUND) {
            ResourceLocale.throwMissingResourceException(baseName, locale);
        } else if (lookup != null) {
            return lookup;
        }
        ResourceLocale parent = NOT_FOUND;
        try {
            boolean foundInMainBranch;
            ResourceLocale root = ResourceLocale.findResource(loader, baseName, defaultLocale, baseName, null);
            if (root == null) {
                ResourceLocale.putResourceInCache(loader, baseName, defaultLocale, NOT_FOUND);
                root = NOT_FOUND;
            }
            Vector<String> names = ResourceLocale.calculateResourceNames(baseName, locale);
            Vector<ResourceLocale> resourcesFound = new Vector<ResourceLocale>(3);
            boolean bl = foundInMainBranch = root != NOT_FOUND && names.size() == 0;
            if (!foundInMainBranch) {
                parent = root;
                for (int i = 0; i < names.size(); ++i) {
                    resourceName = names.elementAt(i);
                    lookup = ResourceLocale.findResource(loader, resourceName, defaultLocale, baseName, parent);
                    resourcesFound.addElement(lookup);
                    if (lookup == null) continue;
                    parent = lookup;
                    foundInMainBranch = true;
                }
            }
            parent = root;
            if (!foundInMainBranch) {
                Vector<String> fallbackNames = ResourceLocale.calculateResourceNames(baseName, defaultLocale);
                for (int i = 0; i < fallbackNames.size() && !names.contains(resourceName = fallbackNames.elementAt(i)); ++i) {
                    lookup = ResourceLocale.findResource(loader, resourceName, defaultLocale, baseName, parent);
                    if (lookup != null) {
                        parent = lookup;
                        continue;
                    }
                    ResourceLocale.putResourceInCache(loader, resourceName, defaultLocale, parent);
                }
            }
            parent = ResourceLocale.propagate(loader, names, resourcesFound, defaultLocale, parent);
        }
        catch (Exception e) {
            ResourceLocale.cleanUpConstructionList();
            ResourceLocale.throwMissingResourceException(baseName, locale);
        }
        catch (Error e) {
            ResourceLocale.cleanUpConstructionList();
            throw e;
        }
        if (parent == NOT_FOUND) {
            ResourceLocale.throwMissingResourceException(baseName, locale);
        }
        return parent;
    }

    private static ResourceLocale propagate(ClassLoader loader, Vector<String> names, Vector<ResourceLocale> resourcesFound, Locale defaultLocale, ResourceLocale parent) {
        for (int i = 0; i < names.size(); ++i) {
            String resourceName = names.elementAt(i);
            ResourceLocale lookup = resourcesFound.elementAt(i);
            if (lookup == null) {
                ResourceLocale.putResourceInCache(loader, resourceName, defaultLocale, parent);
                continue;
            }
            parent = lookup;
        }
        return parent;
    }

    private static void throwMissingResourceException(String baseName, Locale locale) throws MissingResourceException {
        throw new MissingResourceException("Can't find resource for base name " + baseName + ", locale " + locale, baseName + "_" + locale, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpConstructionList() {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            Collection<Thread> entries = underConstruction.values();
            Thread thisThread = Thread.currentThread();
            while (entries.remove(thisThread)) {
            }
            cacheList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceLocale findResource(ClassLoader loader, String resourceName, Locale defaultLocale, String baseName, Object parent) {
        ResourceLocale result;
        SoftCache ref;
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            boolean beingBuilt;
            ref = referenceQueue.poll();
            while (ref != null) {
                cacheList.remove((Object)((LoaderReference)ref).getCacheKey());
                ref = referenceQueue.poll();
            }
            cacheKey.setKeyValues(loader, resourceName, defaultLocale);
            result = (ResourceLocale)cacheList.get((Object)cacheKey);
            if (result != null) {
                cacheKey.clear();
                return result;
            }
            Thread builder = underConstruction.get(cacheKey);
            boolean bl = beingBuilt = builder != null && builder != Thread.currentThread();
            if (beingBuilt) {
                while (beingBuilt) {
                    cacheKey.clear();
                    try {
                        cacheList.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    cacheKey.setKeyValues(loader, resourceName, defaultLocale);
                    beingBuilt = underConstruction.containsKey(cacheKey);
                }
                result = (ResourceLocale)cacheList.get((Object)cacheKey);
                if (result != null) {
                    cacheKey.clear();
                    return result;
                }
            }
            ResourceCacheKey key = (ResourceCacheKey)cacheKey.clone();
            underConstruction.put(key, Thread.currentThread());
            cacheKey.clear();
        }
        result = ResourceLocale.loadLocale(loader, resourceName);
        if (result != null) {
            boolean constructing;
            ref = cacheList;
            synchronized (ref) {
                cacheKey.setKeyValues(loader, resourceName, defaultLocale);
                constructing = underConstruction.get(cacheKey) == Thread.currentThread();
                cacheKey.clear();
            }
            if (constructing) {
                ResourceLocale locale = result;
                if (parent != NOT_FOUND && locale.parent == null) {
                    locale.setParent((ResourceLocale)parent);
                }
                locale.setLocale(baseName, resourceName);
                ResourceLocale.putResourceInCache(loader, resourceName, defaultLocale, result);
            }
        }
        return result;
    }

    private static Vector<String> calculateResourceNames(String baseName, Locale locale) {
        String variant;
        int variantLength;
        String country;
        int countryLength;
        Vector<String> result = new Vector<String>(3);
        String language = locale.getLanguage();
        int languageLength = language.length();
        if (languageLength + (countryLength = (country = locale.getCountry()).length()) + (variantLength = (variant = locale.getVariant()).length()) == 0) {
            return result;
        }
        StringBuffer temp = new StringBuffer(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.addElement(temp.toString());
        }
        if (countryLength + variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.addElement(temp.toString());
        }
        if (variantLength == 0) {
            return result;
        }
        temp.append('_');
        temp.append(variant);
        result.addElement(temp.toString());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceLocale findResourceInCache(ClassLoader loader, String resourceName, Locale defaultLocale) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(loader, resourceName, defaultLocale);
            ResourceLocale result = (ResourceLocale)cacheList.get((Object)cacheKey);
            cacheKey.clear();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putResourceInCache(ClassLoader loader, String resourceName, Locale defaultLocale, ResourceLocale value) {
        SoftCache softCache = cacheList;
        synchronized (softCache) {
            cacheKey.setKeyValues(loader, resourceName, defaultLocale);
            cacheList.put(cacheKey.clone(), (Object)value);
            underConstruction.remove(cacheKey);
            cacheKey.clear();
            cacheList.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceLocale loadLocale(final ClassLoader loader, String resourceName) {
        final String resName = resourceName.replace('.', '/');
        InputStream stream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                if (loader != null) {
                    return loader.getResourceAsStream(resName);
                }
                return ClassLoader.getSystemResourceAsStream(resName);
            }
        });
        if (stream != null) {
            stream = new BufferedInputStream(stream);
            byte[] content = null;
            try {
                int available = stream.available();
                content = new byte[available];
                stream.read(content, 0, available);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
            return new ResourceLocale(content);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LoaderReference
    extends WeakReference<Object> {
        private ResourceCacheKey localCacheKey;

        LoaderReference(Object referent, ReferenceQueue<Object> q, ResourceCacheKey key) {
            super(referent, q);
            this.localCacheKey = key;
        }

        ResourceCacheKey getCacheKey() {
            return this.localCacheKey;
        }
    }

    private static final class ResourceCacheKey
    implements Cloneable {
        private LoaderReference loaderRef;
        private String searchName;
        private Locale defaultLocale;
        private int hashCodeCache;

        private ResourceCacheKey() {
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            try {
                ResourceCacheKey otherEntry = (ResourceCacheKey)other;
                if (this.hashCodeCache != otherEntry.hashCodeCache) {
                    return false;
                }
                if (!this.searchName.equals(otherEntry.searchName)) {
                    return false;
                }
                if (this.defaultLocale == null ? otherEntry.defaultLocale != null : !this.defaultLocale.equals(otherEntry.defaultLocale)) {
                    return false;
                }
                if (this.loaderRef == null) {
                    return otherEntry.loaderRef == null;
                }
                Object loaderRefValue = this.loaderRef.get();
                return otherEntry.loaderRef != null && loaderRefValue != null && loaderRefValue == otherEntry.loaderRef.get();
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public Object clone() {
            try {
                ResourceCacheKey clone = (ResourceCacheKey)super.clone();
                if (this.loaderRef != null) {
                    clone.loaderRef = new LoaderReference(this.loaderRef.get(), referenceQueue, clone);
                }
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        public void setKeyValues(ClassLoader loader, String searchName, Locale defaultLocale) {
            this.searchName = searchName;
            this.hashCodeCache = searchName.hashCode();
            this.defaultLocale = defaultLocale;
            if (defaultLocale != null) {
                this.hashCodeCache ^= defaultLocale.hashCode();
            }
            if (loader == null) {
                this.loaderRef = null;
            } else {
                this.loaderRef = new LoaderReference(loader, referenceQueue, this);
                this.hashCodeCache ^= loader.hashCode();
            }
        }

        public void clear() {
            this.setKeyValues(null, "", null);
        }
    }
}

